/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.util.sdmx;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.sdmxsource.sdmx.api.constants.DATASET_ACTION;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.MESSAGE_TYPE;
import org.sdmxsource.sdmx.api.constants.QUERY_MESSAGE_TYPE;
import org.sdmxsource.sdmx.api.constants.REGISTRY_MESSAGE_TYPE;
import org.sdmxsource.sdmx.api.constants.SDMX_SCHEMA;
import org.sdmxsource.sdmx.api.constants.SdmxConstants;
import org.sdmxsource.sdmx.api.exception.SdmxException;
import org.sdmxsource.sdmx.api.util.ReadableDataLocation;
import org.sdmxsource.sdmx.util.exception.ParseException;
import org.sdmxsource.sdmx.util.stax.StaxUtil;
import org.sdmxsource.util.io.StreamUtil;

public class SdmxMessageUtil {
    public static void parseSdmxErrorMessage(ReadableDataLocation dataLocation) {
        InputStream stream = dataLocation.getInputStream();
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLStreamReader parser = factory.createXMLStreamReader(stream);
            String code = null;
            while (parser.hasNext()) {
                int event = parser.next();
                if (event != 1) continue;
                String nodeName = parser.getLocalName();
                if (nodeName.equals("ErrorMessage")) {
                    code = parser.getAttributeValue(null, "code");
                    continue;
                }
                if (!nodeName.equals("Text")) continue;
                throw new SdmxException(parser.getElementText(), code);
            }
        }
        catch (XMLStreamException e) {
            try {
                throw new ParseException(ExceptionCode.XML_PARSE_EXCEPTION, e);
            }
            catch (Throwable throwable) {
                StreamUtil.closeStream(stream);
                throw throwable;
            }
        }
        StreamUtil.closeStream(stream);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SDMX_SCHEMA getSchemaVersion(ReadableDataLocation sourceData) throws ParseException {
        if (SdmxMessageUtil.isEDI(sourceData)) {
            return SDMX_SCHEMA.EDI;
        }
        if (SdmxMessageUtil.isECV(sourceData)) {
            return SDMX_SCHEMA.ECV;
        }
        stream = sourceData.getInputStream();
        try {
            factory = XMLInputFactory.newInstance();
            parser = factory.createXMLStreamReader(stream);
            while (parser.hasNext()) {
                event = parser.next();
                if (event != 1) continue;
                i = 0;
                ** GOTO lbl15
            }
            {
                throw new ParseException(ExceptionCode.XML_PARSE_EXCEPTION, new Object[]{"No root node found"});
lbl15:
                // 2 sources

                while (i < parser.getNamespaceCount()) {
                    ns = parser.getNamespaceURI(i);
                    if (SdmxConstants.getNamespacesV1().contains(ns)) {
                        var7_8 = SDMX_SCHEMA.VERSION_ONE;
                        return var7_8;
                    }
                    if (SdmxConstants.getNamespacesV2().contains(ns)) {
                        var7_9 = SDMX_SCHEMA.VERSION_TWO;
                        return var7_9;
                    }
                    if (SdmxConstants.getNamespacesV2_1().contains(ns)) {
                        var7_10 = SDMX_SCHEMA.VERSION_TWO_POINT_ONE;
                        return var7_10;
                    }
                    ** try [egrp 7[TRYBLOCK] [6 : 218->257)] { 
lbl27:
                    // 1 sources

                    ++i;
                }
                throw new IllegalArgumentException("Can not determine structure type unknown namespaces defined - please ensure namespaces are defined in the root node");
            }
        }
lbl30:
        // 2 sources

        catch (XMLStreamException e) {
            throw new ParseException(ExceptionCode.XML_PARSE_EXCEPTION, new Object[]{e});
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static boolean isECVDelete(ReadableDataLocation dataLocation) {
        InputStream stream = dataLocation.getInputStream();
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(stream));
            char[] firstPortion = new char[100];
            br.read(firstPortion, 0, 10);
            String str = new String(firstPortion);
            boolean bl = str.toUpperCase().startsWith("ECV-");
            return bl;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error while trying to read dataLocation:" + dataLocation);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private static boolean isEDI(ReadableDataLocation sourceData) {
        InputStream stream = sourceData.getInputStream();
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(stream));
            char[] firstPortion = new char[100];
            br.read(firstPortion, 0, 100);
            String str = new String(firstPortion);
            boolean bl = str.toUpperCase().startsWith("UNA");
            return bl;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error while trying to read source:" + sourceData);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private static boolean isECV(ReadableDataLocation sourceData) {
        InputStream stream = sourceData.getInputStream();
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(stream));
            char[] firstPortion = new char[100];
            br.read(firstPortion, 0, 100);
            String str = new String(firstPortion);
            boolean bl = str.toUpperCase().startsWith("ECV");
            return bl;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error while trying to read source:" + sourceData);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    public static MESSAGE_TYPE getMessageType(ReadableDataLocation sourceData) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK], 12[WHILELOOP]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static REGISTRY_MESSAGE_TYPE getRegistryMessageType(ReadableDataLocation sourceData) {
        InputStream stream = sourceData.getInputStream();
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLStreamReader parser = factory.createXMLStreamReader(stream);
            boolean skippedHeader = StaxUtil.skipToEndNode(parser, "Header");
            if (!skippedHeader) {
                throw new IllegalArgumentException("Header not found");
            }
            String rootNode = null;
            while (parser.hasNext()) {
                int event = parser.next();
                if (event != 1) continue;
                rootNode = parser.getLocalName();
                return REGISTRY_MESSAGE_TYPE.getMessageType(rootNode);
            }
            throw new IllegalArgumentException("No nodes found after header");
        }
        catch (XMLStreamException th) {
            throw new RuntimeException(th);
        }
    }

    public static List<QUERY_MESSAGE_TYPE> getQueryMessageTypes(ReadableDataLocation sourceData) {
        MESSAGE_TYPE messageType = SdmxMessageUtil.getMessageType(sourceData);
        if (messageType != MESSAGE_TYPE.QUERY) {
            throw new IllegalArgumentException("Can not determine query type, as message is of type : " + messageType.toString());
        }
        ArrayList<QUERY_MESSAGE_TYPE> returnList = new ArrayList<QUERY_MESSAGE_TYPE>();
        InputStream stream = sourceData.getInputStream();
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLStreamReader parser = factory.createXMLStreamReader(stream);
            StaxUtil.skipToNode(parser, "Query");
            String nodeName = null;
            while (parser.hasNext()) {
                int event = parser.next();
                if (event == 1) {
                    nodeName = parser.getLocalName();
                    returnList.add(QUERY_MESSAGE_TYPE.parseString(nodeName));
                    StaxUtil.skipToEndNode(parser, nodeName);
                    continue;
                }
                if (event != 2 || !(nodeName = parser.getLocalName()).equals("Query")) continue;
                break;
            }
            return returnList;
        }
        catch (XMLStreamException th) {
            throw new RuntimeException(th);
        }
    }

    public static DATASET_ACTION getDataSetAction(ReadableDataLocation sourceData) {
        REGISTRY_MESSAGE_TYPE registryMessageType;
        MESSAGE_TYPE message = SdmxMessageUtil.getMessageType(sourceData);
        boolean continueToSubmitStructureRequest = false;
        if (message == MESSAGE_TYPE.REGISTRY_INTERFACE && (registryMessageType = SdmxMessageUtil.getRegistryMessageType(sourceData)) == REGISTRY_MESSAGE_TYPE.SUBMIT_STRUCTURE_REQUEST) {
            continueToSubmitStructureRequest = true;
        }
        InputStream stream = sourceData.getInputStream();
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLStreamReader parser = factory.createXMLStreamReader(stream);
            String currentNode = null;
            while (parser.hasNext()) {
                Object action;
                int event = parser.next();
                if (event == 1) {
                    currentNode = parser.getLocalName();
                    if (currentNode.equals("DataSetAction")) {
                        action = parser.getElementText();
                        if (((String)action).equals("Append") || ((String)action).equals("Update")) {
                            DATASET_ACTION dATASET_ACTION = DATASET_ACTION.APPEND;
                            return dATASET_ACTION;
                        }
                        if (((String)action).equals("Replace")) {
                            DATASET_ACTION dATASET_ACTION = DATASET_ACTION.REPLACE;
                            return dATASET_ACTION;
                        }
                        if (((String)action).equals("Delete")) {
                            DATASET_ACTION dATASET_ACTION = DATASET_ACTION.DELETE;
                            return dATASET_ACTION;
                        }
                    }
                    if (!currentNode.equals("SubmitStructureRequest")) continue;
                    action = parser.getAttributeValue(null, "action");
                    if (action != null) {
                        DATASET_ACTION dATASET_ACTION = DATASET_ACTION.getAction((String)action);
                        return dATASET_ACTION;
                    }
                    DATASET_ACTION dATASET_ACTION = DATASET_ACTION.APPEND;
                    return dATASET_ACTION;
                }
                if (event != 2 || !(currentNode = parser.getLocalName()).equals("Header") || continueToSubmitStructureRequest) continue;
                action = DATASET_ACTION.APPEND;
                return action;
            }
            DATASET_ACTION dATASET_ACTION = DATASET_ACTION.APPEND;
            return dATASET_ACTION;
        }
        catch (XMLStreamException th) {
            throw new RuntimeException(th);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

