/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.api.constants;

import org.sdmxsource.sdmx.api.constants.MESSAGE_TYPE;

public enum BASE_DATA_FORMAT {
    GENERIC("GenericData"),
    COMPACT("CompactData"),
    UTILITY("UtilityData"),
    EDI(null),
    CROSS_SECTIONAL("CrossSectionalData"),
    MESSAGE_GROUP("MessageGroup"),
    CSV(null),
    SDMXJSON(null);

    private String rootNode;

    private BASE_DATA_FORMAT(String rootNode) {
        this.rootNode = rootNode;
    }

    public String getRootNode() {
        return this.rootNode;
    }

    public static BASE_DATA_FORMAT getDataFormat(MESSAGE_TYPE messageType) {
        switch (messageType) {
            case COMPACT_DATA: {
                return COMPACT;
            }
            case CROSS_SECTIONAL_DATA: {
                return CROSS_SECTIONAL;
            }
            case GENERIC_DATA: {
                return GENERIC;
            }
            case UTILITY_DATA: {
                return UTILITY;
            }
        }
        throw new IllegalArgumentException((Object)((Object)messageType) + " is not a data message");
    }

    public String toString() {
        switch (this) {
            case COMPACT: {
                return "Structure Specific (Compact)";
            }
            case CROSS_SECTIONAL: {
                return "Cross Sectional";
            }
            case CSV: {
                return "CSV";
            }
            case EDI: {
                return "EDI";
            }
            case GENERIC: {
                return "Generic";
            }
            case MESSAGE_GROUP: {
                return "Message Group";
            }
            case SDMXJSON: {
                return "SDMX JSON";
            }
            case UTILITY: {
                return "Utility";
            }
        }
        return super.toString();
    }
}

