/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.ediparser.manager.impl;

import java.io.OutputStream;
import java.util.ArrayList;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.SdmxNotImplementedException;
import org.sdmxsource.sdmx.api.model.beans.SdmxBeans;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.util.ReadableDataLocation;
import org.sdmxsource.sdmx.ediparser.engine.writer.impl.EdiStructureEngine;
import org.sdmxsource.sdmx.ediparser.manager.EdiParseManager;
import org.sdmxsource.sdmx.ediparser.model.EDIWorkspace;
import org.sdmxsource.sdmx.ediparser.model.impl.EDIWorkspaceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EdiParseManagerImpl
implements EdiParseManager {
    @Autowired
    private EdiStructureEngine ediStructureEngine;

    @Override
    public EDIWorkspace parseEDIMessage(ReadableDataLocation ediMessageLocation) {
        return new EDIWorkspaceImpl(ediMessageLocation);
    }

    @Override
    public void writeToEDI(SdmxBeans beans, OutputStream out) {
        this.validateSupport(beans);
        this.ediStructureEngine.writeToEDI(beans, out);
    }

    private void validateSupport(SdmxBeans beans) {
        ArrayList<SDMX_STRUCTURE_TYPE> supportedStructres = new ArrayList<SDMX_STRUCTURE_TYPE>();
        supportedStructres.add(SDMX_STRUCTURE_TYPE.AGENCY_SCHEME);
        supportedStructres.add(SDMX_STRUCTURE_TYPE.DSD);
        supportedStructres.add(SDMX_STRUCTURE_TYPE.CONCEPT_SCHEME);
        supportedStructres.add(SDMX_STRUCTURE_TYPE.CODE_LIST);
        for (MaintainableBean maintainableBean : beans.getAllMaintainables(new SDMX_STRUCTURE_TYPE[0])) {
            if (supportedStructres.contains((Object)maintainableBean.getStructureType())) continue;
            throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, String.valueOf(maintainableBean.getStructureType().getType()) + " is not a supported by SDMX-EDI");
        }
    }
}

