/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.ediparser.util;

import java.math.BigInteger;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.model.beans.base.ComponentBean;
import org.sdmxsource.sdmx.api.model.beans.base.TextFormatBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodeBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodelistBean;
import org.sdmxsource.sdmx.api.model.beans.conceptscheme.ConceptBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.AttributeBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DimensionBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.PrimaryMeasureBean;
import org.sdmxsource.sdmx.ediparser.constants.EDI_CONSTANTS;
import org.sdmxsource.sdmx.ediparser.constants.EDI_PREFIX;
import org.sdmxsource.sdmx.ediparser.util.EDIUtil;
import org.sdmxsource.sdmx.util.beans.ConceptRefUtil;

public class EDIStructureWriterUtil {
    public static String parseCodelistIdentifier(CodelistBean codelist) {
        String codeListId = codelist.getId();
        if (codeListId.length() > 18) {
            throw new IllegalArgumentException("Codelist Id can not be more then 18 characters in EDI");
        }
        String codeListname = codelist.getName();
        if (codeListname.length() > 70) {
            throw new IllegalArgumentException("Codelist name can not be more then 70 characters in EDI");
        }
        StringBuilder sb = new StringBuilder();
        sb.append((Object)EDI_PREFIX.CODELIST);
        sb.append(codeListId);
        sb.append("+");
        sb.append("+");
        sb.append("+");
        sb.append(codeListname);
        sb.append("'");
        return sb.toString();
    }

    public static String parseCodeId(CodeBean code) {
        String codeId = code.getId();
        EDIUtil.parseId(codeId);
        StringBuilder sb = new StringBuilder();
        sb.append((Object)EDI_PREFIX.CODE_VALUE);
        sb.append(code.getId());
        sb.append("'");
        return sb.toString();
    }

    public static String parseCodeName(CodeBean code) {
        return EDIUtil.stringToEDIFreeText(code.getName(), 70, 350);
    }

    public static String parseConceptIdentifier(ConceptBean concept) {
        String conceptId = concept.getId().toUpperCase();
        EDIUtil.parseId(conceptId);
        return (Object)((Object)EDI_PREFIX.CONCEPT) + conceptId + "'";
    }

    public static String parseConceptName(ConceptBean concept) {
        return EDIUtil.stringToEDIFreeText(concept.getName(), 70, 70);
    }

    public static String parseDataStructureIdentifier(DataStructureBean kf) {
        String dsdId = kf.getId().toUpperCase();
        EDIUtil.parseId(dsdId);
        return (Object)((Object)EDI_PREFIX.DSD) + dsdId + "'";
    }

    public static String parseDataStructureName(DataStructureBean kf) {
        return EDIUtil.stringToEDIFreeText(EDIUtil.stringToEdi(kf.getName()), 70, 70);
    }

    public static String parseTimeFormat(int position, String conceptId) {
        return EDIStructureWriterUtil.parseSCDSegment(conceptId, 1, position);
    }

    public static String parseObservationAttribute(AttributeBean attributeBean, int position) {
        return EDIStructureWriterUtil.parseSCDSegment(ConceptRefUtil.getConceptId(attributeBean.getConceptRef()).toUpperCase(), 3, position);
    }

    public static String parsePrimaryMeasureIdentification(PrimaryMeasureBean primaryMeasureBean, int position) {
        return EDIStructureWriterUtil.parseSCDSegment(ConceptRefUtil.getConceptId(primaryMeasureBean.getConceptRef()).toUpperCase(), 3, position);
    }

    public static String parseDimensionIdentification(ComponentBean dimension, int position) {
        DimensionBean dim;
        int segmentType = -1;
        segmentType = dimension.getStructureType() == SDMX_STRUCTURE_TYPE.TIME_DIMENSION ? 1 : ((dim = (DimensionBean)dimension).isFrequencyDimension() ? 13 : 4);
        return EDIStructureWriterUtil.parseSCDSegment(ConceptRefUtil.getConceptId(dimension.getConceptRef()).toUpperCase(), segmentType, position);
    }

    private static String parseSCDSegment(String id, int segmentType, int position) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)EDI_PREFIX.DIMENSION);
        sb.append(segmentType);
        sb.append("+");
        sb.append(id);
        sb.append("+");
        sb.append("+");
        sb.append("+");
        sb.append("+");
        sb.append(":");
        sb.append(position);
        sb.append("'");
        return sb.toString();
    }

    public static String parseFieldLength(ComponentBean component, boolean coded) {
        String fieldLength;
        String string = fieldLength = coded ? EDI_CONSTANTS.DEFAULT_FIELD_LENGTH_CODED : EDI_CONSTANTS.DEFAULT_FIELD_LENGTH_UNCODED;
        if (component instanceof PrimaryMeasureBean) {
            fieldLength = EDI_CONSTANTS.DEFAULT_FIELD_LENGTH_PRIMARY_MEASURE;
        }
        if (component.getRepresentation() != null && component.getRepresentation().getTextFormat() != null) {
            TextFormatBean tf = component.getRepresentation().getTextFormat();
            boolean valueEquals = false;
            boolean alphaNumeric = true;
            int length = -1;
            BigInteger minLength = tf.getMinLength();
            BigInteger maxLength = tf.getMaxLength();
            if (tf.getTextType() != null) {
                switch (tf.getTextType()) {
                    case BIG_INTEGER: {
                        alphaNumeric = false;
                        break;
                    }
                    case COUNT: {
                        alphaNumeric = false;
                        break;
                    }
                    case INTEGER: {
                        alphaNumeric = false;
                        length = 11;
                        break;
                    }
                    case LONG: {
                        alphaNumeric = false;
                        length = 20;
                        break;
                    }
                    case DOUBLE: {
                        alphaNumeric = false;
                        break;
                    }
                    case SHORT: {
                        alphaNumeric = false;
                        length = 6;
                    }
                }
            }
            if (minLength != null && maxLength != null) {
                valueEquals = minLength.equals(maxLength);
            }
            if (minLength != null) {
                length = minLength.intValue();
            }
            if (maxLength != null) {
                length = maxLength.intValue();
            }
            if (length < 0) {
                length = 18;
            }
            String dataFormat = alphaNumeric ? "AN" : "N";
            String equalTo = valueEquals ? "" : "..";
            fieldLength = String.valueOf(dataFormat) + equalTo + length;
        }
        return (Object)((Object)EDI_PREFIX.FIELD_LENGTH) + fieldLength + "'";
    }

    public static String parseTimeFormatFieldLength() {
        return (Object)((Object)EDI_PREFIX.FIELD_LENGTH) + "AN3" + "'";
    }

    public static String parseCodelistReference(ComponentBean componentBean) {
        return (Object)((Object)EDI_PREFIX.CODELIST_REFERENCE) + componentBean.getRepresentation().getRepresentation().getMaintainableReference().getMaintainableId().toUpperCase() + "'";
    }

    public static String parseDimensionAttribute(AttributeBean attribute) {
        return (Object)((Object)EDI_PREFIX.ATTRIBUTE) + ConceptRefUtil.getConceptId(attribute.getConceptRef()).toUpperCase() + "'";
    }

    public static String parseTimePeriod(int pos) {
        return (Object)((Object)EDI_PREFIX.DIMENSION) + "1+TIME_PERIOD++++" + pos + "'";
    }

    public static String parseUseageStatus(AttributeBean attribute) {
        int useageStatus = attribute.isMandatory() ? 2 : 1;
        return String.valueOf(EDI_PREFIX.USEAGE_STATUS.getPrefix()) + useageStatus + ":USS" + "'";
    }

    public static String parseDimensionAttributeAttachmentLevel(AttributeBean attribute) {
        int attchementLevel = -1;
        switch (attribute.getAttachmentLevel()) {
            case DATA_SET: {
                attchementLevel = 1;
                break;
            }
            case DIMENSION_GROUP: {
                attchementLevel = 4;
                break;
            }
            case OBSERVATION: {
                attchementLevel = 5;
                break;
            }
            case GROUP: {
                attchementLevel = 9;
            }
        }
        return String.valueOf(EDI_PREFIX.ATTRIBUTE_ATTACHMENT_VALUE.getPrefix()) + attchementLevel + ":ALV" + "'";
    }
}

