/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.base;

import java.util.Set;
import org.apache.xmlbeans.XmlObject;
import org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.common.AnnotationsType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.TextFormatType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.ComponentType;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.SdmxException;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.model.beans.base.ComponentBean;
import org.sdmxsource.sdmx.api.model.beans.base.IdentifiableBean;
import org.sdmxsource.sdmx.api.model.beans.base.RepresentationBean;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.base.SdmxStructureBean;
import org.sdmxsource.sdmx.api.model.beans.reference.CrossReferenceBean;
import org.sdmxsource.sdmx.api.model.mutable.base.ComponentMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.IdentifiableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.RepresentationBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.util.RefUtil;
import org.sdmxsource.sdmx.util.beans.ConceptRefUtil;
import org.sdmxsource.sdmx.util.beans.reference.CrossReferenceBeanImpl;
import org.sdmxsource.util.ObjectUtil;

public abstract class ComponentBeanImpl
extends IdentifiableBeanImpl
implements ComponentBean {
    private static final long serialVersionUID = 1L;
    private CrossReferenceBean conceptRef;
    protected RepresentationBean localRepresentation;

    protected ComponentBeanImpl(ComponentMutableBean bean, IdentifiableBean parent) {
        super(bean, (SdmxStructureBean)parent);
        try {
            if (bean.getRepresentation() != null) {
                this.localRepresentation = new RepresentationBeanImpl(bean.getRepresentation(), (IdentifiableBean)this);
            }
            if (bean.getConceptRef() != null) {
                this.conceptRef = new CrossReferenceBeanImpl((SDMXBean)this, bean.getConceptRef());
            }
        }
        catch (Throwable th) {
            throw new SdmxException(th, "Error creating component: " + this.toString());
        }
        this.validateComponentAttributes();
    }

    protected ComponentBeanImpl(ComponentType createdFrom, SDMX_STRUCTURE_TYPE structureType, IdentifiableBean parent) {
        super(createdFrom, structureType, (SdmxStructureBean)parent);
        if (createdFrom.getLocalRepresentation() != null) {
            this.localRepresentation = new RepresentationBeanImpl(createdFrom.getLocalRepresentation(), (IdentifiableBean)this);
        }
        if (createdFrom.getConceptIdentity() != null) {
            this.conceptRef = RefUtil.createReference(this, createdFrom.getConceptIdentity());
        }
        this.validateComponentAttributes();
    }

    protected ComponentBeanImpl(XmlObject createdFrom, SDMX_STRUCTURE_TYPE structureType, org.sdmx.resources.sdmxml.schemas.v20.common.AnnotationsType annotationType, TextFormatType textFormat, String codelistAgency, String codelistId, String codelistVersion, String conceptSchemeAgency, String conceptSchemeId, String conceptSchemeVersion, String conceptAgency, String conceptId, IdentifiableBean parent) {
        super(createdFrom, structureType, conceptId, null, annotationType, (SdmxStructureBean)parent);
        if (!ObjectUtil.validString(conceptAgency)) {
            conceptAgency = this.getMaintainableParent().getAgencyId();
        }
        if (textFormat != null || ObjectUtil.validOneString(codelistAgency, codelistId, codelistVersion)) {
            if (ObjectUtil.validOneString(codelistAgency, codelistId, codelistVersion) && !ObjectUtil.validString(codelistAgency)) {
                codelistAgency = this.getMaintainableParent().getAgencyId();
            }
            this.localRepresentation = new RepresentationBeanImpl(textFormat, codelistAgency, codelistId, codelistVersion, this);
        }
        this.conceptRef = ConceptRefUtil.buildConceptRef(this, conceptSchemeAgency, conceptSchemeId, conceptSchemeVersion, conceptAgency, conceptId);
        this.validateComponentAttributes();
    }

    protected ComponentBeanImpl(XmlObject createdFrom, SDMX_STRUCTURE_TYPE structureType, AnnotationsType annotationType, String codelistId, String conceptId, SdmxStructureBean parent) {
        super(createdFrom, structureType, conceptId, null, annotationType, parent);
        if (ObjectUtil.validString(codelistId)) {
            this.localRepresentation = new RepresentationBeanImpl(codelistId, (IdentifiableBean)this);
        }
        this.conceptRef = new CrossReferenceBeanImpl(this, this.getMaintainableParent().getAgencyId(), "STANDALONE_CONCEPT_SCHEME", "1.0", SDMX_STRUCTURE_TYPE.CONCEPT, conceptId);
        this.validateComponentAttributes();
    }

    protected boolean deepEqualsInternal(ComponentBean bean, boolean includeFinalProperties) {
        if (bean == null) {
            return false;
        }
        if (!super.equivalent(this.conceptRef, bean.getConceptRef())) {
            return false;
        }
        if (!super.equivalent(this.localRepresentation, bean.getRepresentation(), includeFinalProperties)) {
            return false;
        }
        return super.deepEqualsInternal(bean, includeFinalProperties);
    }

    protected void validateComponentAttributes() throws SdmxSemmanticException {
        this.validateComponetReference();
        super.validateId(false);
    }

    protected void validateComponetReference() {
        if (this.conceptRef == null) {
            throw new SdmxSemmanticException(ExceptionCode.BEAN_MISSING_REQUIRED_ATTRIBUTE, this.structureType.getType(), "conceptRef");
        }
        if (this.conceptRef.getTargetReference() != SDMX_STRUCTURE_TYPE.CONCEPT) {
            throw new SdmxSemmanticException("Component reference is invalid, expected " + SDMX_STRUCTURE_TYPE.CONCEPT.getType() + " reference, got " + this.conceptRef.getTargetReference().getType() + " reference");
        }
    }

    @Override
    protected void validateId(boolean startWithIntAllowed) {
    }

    @Override
    protected Set<SDMXBean> getCompositesInternal() {
        Set<SDMXBean> composites = super.getCompositesInternal();
        super.addToCompositeSet(this.getRepresentation(), composites);
        return composites;
    }

    @Override
    public String getId() {
        if (ObjectUtil.validString(super.getId())) {
            return super.getId();
        }
        if (this.conceptRef != null) {
            return this.conceptRef.getChildReference().getId();
        }
        throw new SdmxSemmanticException("Id not set for component");
    }

    @Override
    public CrossReferenceBean getConceptRef() {
        return this.conceptRef;
    }

    @Override
    public RepresentationBean getRepresentation() {
        return this.localRepresentation;
    }

    @Override
    public boolean hasCodedRepresentation() {
        if (this.localRepresentation != null) {
            return this.localRepresentation.getRepresentation() != null;
        }
        return false;
    }
}

