/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.base;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.message.ContactType;
import org.sdmx.resources.sdmxml.schemas.v20.common.TextType;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.model.beans.base.ContactBean;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.base.TextTypeWrapper;
import org.sdmxsource.sdmx.api.model.mutable.base.ContactMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.base.TextTypeWrapperMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.SDMXBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.TextTypeWrapperImpl;
import org.sdmxsource.util.ObjectUtil;

public class ContactBeanImpl
extends SDMXBeanImpl
implements ContactBean {
    private static final long serialVersionUID = -1785478523789992314L;
    private String id;
    private List<TextTypeWrapper> name = new ArrayList<TextTypeWrapper>();
    private List<TextTypeWrapper> role = new ArrayList<TextTypeWrapper>();
    private List<TextTypeWrapper> departments = new ArrayList<TextTypeWrapper>();
    private List<String> email = new ArrayList<String>();
    private List<String> fax = new ArrayList<String>();
    private List<String> telephone = new ArrayList<String>();
    private List<String> uri = new ArrayList<String>();
    private List<String> x400 = new ArrayList<String>();

    public ContactBeanImpl(ContactMutableBean mutableBean) {
        this(mutableBean, null);
    }

    public ContactBeanImpl(ContactMutableBean mutableBean, SDMXBean parent) {
        super(mutableBean, parent);
        this.id = mutableBean.getId();
        this.copyTextTypes(this.name, mutableBean.getName());
        this.copyTextTypes(this.role, mutableBean.getRole());
        this.copyTextTypes(this.departments, mutableBean.getDepartments());
        if (mutableBean.getEmail() != null) {
            this.email = new ArrayList<String>(mutableBean.getEmail());
        }
        if (mutableBean.getTelephone() != null) {
            this.telephone = new ArrayList<String>(mutableBean.getTelephone());
        }
        if (mutableBean.getFax() != null) {
            this.fax = new ArrayList<String>(mutableBean.getFax());
        }
        if (mutableBean.getUri() != null) {
            this.uri = new ArrayList<String>(mutableBean.getUri());
        }
        if (mutableBean.getX400() != null) {
            this.x400 = new ArrayList<String>(mutableBean.getX400());
        }
    }

    private void copyTextTypes(List<TextTypeWrapper> copyTo, List<TextTypeWrapperMutableBean> mutable) {
        if (mutable != null) {
            for (TextTypeWrapperMutableBean currentTextType : mutable) {
                copyTo.add(new TextTypeWrapperImpl(currentTextType, (SDMXBean)this));
            }
        }
    }

    public ContactBeanImpl(List<TextTypeWrapper> name, List<TextTypeWrapper> role, List<TextTypeWrapper> departments, List<String> email, List<String> fax, List<String> telephone, List<String> uri, List<String> x400) {
        super(SDMX_STRUCTURE_TYPE.CONTACT, null);
        if (name != null) {
            this.name = new ArrayList<TextTypeWrapper>(name);
        }
        if (role != null) {
            this.role = new ArrayList<TextTypeWrapper>(role);
        }
        if (departments != null) {
            this.departments = new ArrayList<TextTypeWrapper>(departments);
        }
        if (email != null) {
            this.email = new ArrayList<String>(email);
        }
        if (fax != null) {
            this.fax = new ArrayList<String>(fax);
        }
        if (telephone != null) {
            this.telephone = new ArrayList<String>(telephone);
        }
        if (uri != null) {
            this.uri = new ArrayList<String>(uri);
        }
        if (x400 != null) {
            this.x400 = new ArrayList<String>(x400);
        }
    }

    public ContactBeanImpl(org.sdmx.resources.sdmxml.schemas.v21.message.ContactType contactType) {
        super(SDMX_STRUCTURE_TYPE.CONTACT, null);
        if (ObjectUtil.validCollection(contactType.getDepartmentList())) {
            for (org.sdmx.resources.sdmxml.schemas.v21.common.TextType tt : contactType.getDepartmentList()) {
                this.departments.add(new TextTypeWrapperImpl(tt.getLang(), tt.getStringValue(), null));
            }
        }
        if (ObjectUtil.validCollection(contactType.getEmailList())) {
            this.email = new ArrayList<String>(contactType.getEmailList());
        }
        if (ObjectUtil.validCollection(contactType.getFaxList())) {
            this.fax = new ArrayList<String>(contactType.getFaxList());
        }
        if (ObjectUtil.validCollection(contactType.getNameList())) {
            for (org.sdmx.resources.sdmxml.schemas.v21.common.TextType tt : contactType.getNameList()) {
                this.name.add(new TextTypeWrapperImpl(tt.getLang(), tt.getStringValue(), null));
            }
        }
        if (ObjectUtil.validCollection(contactType.getRoleList())) {
            for (org.sdmx.resources.sdmxml.schemas.v21.common.TextType tt : contactType.getRoleList()) {
                this.role.add(new TextTypeWrapperImpl(tt.getLang(), tt.getStringValue(), null));
            }
        }
        if (ObjectUtil.validCollection(contactType.getTelephoneList())) {
            this.telephone = new ArrayList<String>(contactType.getTelephoneList());
        }
        if (ObjectUtil.validCollection(contactType.getURIList())) {
            this.uri = new ArrayList<String>(contactType.getURIList());
        }
        if (ObjectUtil.validCollection(contactType.getX400List())) {
            this.x400 = new ArrayList<String>(contactType.getX400List());
        }
    }

    public ContactBeanImpl(org.sdmx.resources.sdmxml.schemas.v21.structure.ContactType contactType, SDMXBean parent) {
        super(SDMX_STRUCTURE_TYPE.CONTACT, parent);
        if (ObjectUtil.validCollection(contactType.getDepartmentList())) {
            for (org.sdmx.resources.sdmxml.schemas.v21.common.TextType tt : contactType.getDepartmentList()) {
                this.departments.add(new TextTypeWrapperImpl(tt.getLang(), tt.getStringValue(), null));
            }
        }
        if (ObjectUtil.validCollection(contactType.getEmailList())) {
            this.email = new ArrayList<String>(contactType.getEmailList());
        }
        if (ObjectUtil.validCollection(contactType.getFaxList())) {
            this.fax = new ArrayList<String>(contactType.getFaxList());
        }
        if (ObjectUtil.validCollection(contactType.getNameList())) {
            for (org.sdmx.resources.sdmxml.schemas.v21.common.TextType tt : contactType.getNameList()) {
                this.name.add(new TextTypeWrapperImpl(tt.getLang(), tt.getStringValue(), null));
            }
        }
        if (ObjectUtil.validCollection(contactType.getRoleList())) {
            for (org.sdmx.resources.sdmxml.schemas.v21.common.TextType tt : contactType.getRoleList()) {
                this.role.add(new TextTypeWrapperImpl(tt.getLang(), tt.getStringValue(), null));
            }
        }
        if (ObjectUtil.validCollection(contactType.getTelephoneList())) {
            this.telephone = new ArrayList<String>(contactType.getTelephoneList());
        }
        if (ObjectUtil.validCollection(contactType.getURIList())) {
            this.uri = new ArrayList<String>(contactType.getURIList());
        }
        if (ObjectUtil.validCollection(contactType.getX400List())) {
            this.x400 = new ArrayList<String>(contactType.getX400List());
        }
    }

    public ContactBeanImpl(org.sdmx.resources.sdmxml.schemas.v20.message.ContactType contactType) {
        super(SDMX_STRUCTURE_TYPE.CONTACT, null);
        if (ObjectUtil.validCollection(contactType.getDepartmentList())) {
            for (TextType tt : contactType.getDepartmentList()) {
                this.departments.add(new TextTypeWrapperImpl(tt.getLang(), tt.getStringValue(), null));
            }
        }
        if (ObjectUtil.validCollection(contactType.getEmailList())) {
            this.email = new ArrayList<String>(contactType.getEmailList());
        }
        if (ObjectUtil.validCollection(contactType.getFaxList())) {
            this.fax = new ArrayList<String>(contactType.getFaxList());
        }
        if (ObjectUtil.validCollection(contactType.getNameList())) {
            for (TextType tt : contactType.getNameList()) {
                this.name.add(new TextTypeWrapperImpl(tt.getLang(), tt.getStringValue(), null));
            }
        }
        if (ObjectUtil.validCollection(contactType.getRoleList())) {
            for (TextType tt : contactType.getRoleList()) {
                this.role.add(new TextTypeWrapperImpl(tt.getLang(), tt.getStringValue(), null));
            }
        }
        if (ObjectUtil.validCollection(contactType.getTelephoneList())) {
            this.telephone = new ArrayList<String>(contactType.getTelephoneList());
        }
        if (ObjectUtil.validCollection(contactType.getURIList())) {
            this.uri = new ArrayList<String>(contactType.getURIList());
        }
        if (ObjectUtil.validCollection(contactType.getX400List())) {
            this.x400 = new ArrayList<String>(contactType.getX400List());
        }
    }

    public ContactBeanImpl(ContactType contactType) {
        super(SDMX_STRUCTURE_TYPE.CONTACT, null);
        if (ObjectUtil.validCollection(contactType.getDepartmentList())) {
            for (org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.common.TextType tt : contactType.getDepartmentList()) {
                this.departments.add(new TextTypeWrapperImpl(tt.getLang(), tt.getStringValue(), null));
            }
        }
        if (ObjectUtil.validCollection(contactType.getEmailList())) {
            this.email = new ArrayList<String>(contactType.getEmailList());
        }
        if (ObjectUtil.validCollection(contactType.getFaxList())) {
            this.fax = new ArrayList<String>(contactType.getFaxList());
        }
        if (ObjectUtil.validCollection(contactType.getNameList())) {
            for (org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.common.TextType tt : contactType.getNameList()) {
                this.name.add(new TextTypeWrapperImpl(tt.getLang(), tt.getStringValue(), null));
            }
        }
        if (ObjectUtil.validCollection(contactType.getRoleList())) {
            for (org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.common.TextType tt : contactType.getRoleList()) {
                this.role.add(new TextTypeWrapperImpl(tt.getLang(), tt.getStringValue(), null));
            }
        }
        if (ObjectUtil.validCollection(contactType.getTelephoneList())) {
            this.telephone = new ArrayList<String>(contactType.getTelephoneList());
        }
        if (ObjectUtil.validCollection(contactType.getURIList())) {
            this.uri = new ArrayList<String>(contactType.getURIList());
        }
        if (ObjectUtil.validCollection(contactType.getX400List())) {
            this.x400 = new ArrayList<String>(contactType.getX400List());
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean deepEquals(SDMXBean bean, boolean includeFinalProperties) {
        if (bean instanceof ContactBean) {
            ContactBean contact = (ContactBean)bean;
            if (!super.equivalent(contact.getDepartments(), this.departments, includeFinalProperties)) {
                return false;
            }
            if (!super.equivalent(contact.getName(), this.name, includeFinalProperties)) {
                return false;
            }
            if (!super.equivalent(contact.getRole(), this.role, includeFinalProperties)) {
                return false;
            }
            if (!ObjectUtil.equivalent(contact.getEmail(), this.email)) {
                return false;
            }
            if (!ObjectUtil.equivalent(contact.getFax(), this.fax)) {
                return false;
            }
            if (!ObjectUtil.equivalent(contact.getUri(), this.uri)) {
                return false;
            }
            if (!ObjectUtil.equivalent(contact.getX400(), this.x400)) {
                return false;
            }
            return ObjectUtil.equivalent(contact.getTelephone(), this.telephone);
        }
        return false;
    }

    @Override
    public List<String> getEmail() {
        return new ArrayList<String>(this.email);
    }

    @Override
    public List<TextTypeWrapper> getName() {
        return new ArrayList<TextTypeWrapper>(this.name);
    }

    @Override
    public List<TextTypeWrapper> getRole() {
        return new ArrayList<TextTypeWrapper>(this.role);
    }

    @Override
    public List<TextTypeWrapper> getDepartments() {
        return new ArrayList<TextTypeWrapper>(this.departments);
    }

    @Override
    public List<String> getFax() {
        return new ArrayList<String>(this.fax);
    }

    @Override
    public List<String> getTelephone() {
        return new ArrayList<String>(this.telephone);
    }

    @Override
    public List<String> getUri() {
        return new ArrayList<String>(this.uri);
    }

    @Override
    public List<String> getX400() {
        return new ArrayList<String>(this.x400);
    }

    @Override
    protected Set<SDMXBean> getCompositesInternal() {
        HashSet<SDMXBean> composites = new HashSet<SDMXBean>();
        super.addToCompositeSet(this.name, composites);
        super.addToCompositeSet(this.role, composites);
        super.addToCompositeSet(this.departments, composites);
        return composites;
    }
}

