/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.base;

import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.sdmx.resources.sdmxml.schemas.v20.registry.DatasourceType;
import org.sdmx.resources.sdmxml.schemas.v21.common.QueryableDataSourceType;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.model.beans.base.DataSourceBean;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.base.SdmxStructureBean;
import org.sdmxsource.sdmx.api.model.mutable.base.DataSourceMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.base.MutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.SdmxStructureBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.base.DataSourceMutableBeanImpl;
import org.sdmxsource.util.ObjectUtil;

public class DataSourceBeanImpl
extends SdmxStructureBeanImpl
implements DataSourceBean {
    private static final long serialVersionUID = 1L;
    private URL dataUrl;
    private URL wsdlUrl;
    private URL wadlUrl;
    private boolean isRestDatasource;
    private boolean isSimpleDatasource;
    private boolean isWebServiceDatasource;

    public DataSourceBeanImpl(DataSourceMutableBean datasource, SdmxStructureBean parent) {
        super((MutableBean)datasource, parent);
        this.dataUrl = this.getUrl(datasource.getDataUrl());
        this.wsdlUrl = this.getUrl(datasource.getWSDLUrl());
        this.isRestDatasource = datasource.isRESTDatasource();
        this.isSimpleDatasource = datasource.isSimpleDatasource();
        this.isWebServiceDatasource = datasource.isWebServiceDatasource();
        this.validate();
    }

    public DataSourceBeanImpl(DatasourceType datasource, SdmxStructureBean parent) {
        super(SDMX_STRUCTURE_TYPE.DATASOURCE, parent);
        if (ObjectUtil.validString(datasource.getSimpleDatasource())) {
            this.isSimpleDatasource = true;
            this.dataUrl = this.getUrl(datasource.getSimpleDatasource());
        } else if (datasource.getQueryableDatasource() != null) {
            this.isSimpleDatasource = false;
            this.isRestDatasource = datasource.getQueryableDatasource().getIsRESTDatasource();
            this.isWebServiceDatasource = datasource.getQueryableDatasource().getIsWebServiceDatasource();
            this.dataUrl = this.getUrl(datasource.getQueryableDatasource().getDataUrl());
            this.wsdlUrl = this.getUrl(datasource.getQueryableDatasource().getWSDLUrl());
        }
        this.validate();
    }

    public DataSourceBeanImpl(org.sdmx.resources.sdmxml.schemas.v21.registry.QueryableDataSourceType datasource, SdmxStructureBean parent) {
        super(SDMX_STRUCTURE_TYPE.DATASOURCE, parent);
        this.isSimpleDatasource = false;
        this.isRestDatasource = datasource.getIsRESTDatasource();
        this.isWebServiceDatasource = datasource.getIsWebServiceDatasource();
        this.dataUrl = this.getUrl(datasource.getDataURL());
        this.wsdlUrl = this.getUrl(datasource.getWSDLURL());
        this.wadlUrl = this.getUrl(datasource.getWADLURL());
        this.validate();
    }

    public DataSourceBeanImpl(QueryableDataSourceType datasource, SdmxStructureBean parent) {
        super(SDMX_STRUCTURE_TYPE.DATASOURCE, parent);
        this.isSimpleDatasource = false;
        this.isRestDatasource = datasource.getIsRESTDatasource();
        this.isWebServiceDatasource = datasource.getIsWebServiceDatasource();
        this.dataUrl = this.getUrl(datasource.getDataURL());
        this.wsdlUrl = this.getUrl(datasource.getWSDLURL());
        this.wadlUrl = this.getUrl(datasource.getWADLURL());
        this.validate();
    }

    public DataSourceBeanImpl(String simpleDatasoruce, SdmxStructureBean parent) {
        super(SDMX_STRUCTURE_TYPE.DATASOURCE, parent);
        this.isSimpleDatasource = true;
        this.dataUrl = this.getUrl(simpleDatasoruce);
        this.validate();
    }

    @Override
    public boolean deepEquals(SDMXBean bean, boolean includeFinalProperties) {
        if (bean == null) {
            return false;
        }
        if (bean.getStructureType() == this.getStructureType()) {
            DataSourceBean that = (DataSourceBean)bean;
            if (!ObjectUtil.equivalent(this.dataUrl, that.getDataUrl())) {
                return false;
            }
            if (!ObjectUtil.equivalent(this.wsdlUrl, that.getWadlUrl())) {
                return false;
            }
            if (!ObjectUtil.equivalent(this.wadlUrl, that.getWadlUrl())) {
                return false;
            }
            if (this.isRestDatasource != that.isRESTDatasource()) {
                return false;
            }
            if (this.isSimpleDatasource != that.isSimpleDatasource()) {
                return false;
            }
            return this.isWebServiceDatasource == that.isWebServiceDatasource();
        }
        return false;
    }

    protected void validate() throws SdmxSemmanticException {
        if (this.dataUrl == null) {
            throw new SdmxSemmanticException(ExceptionCode.BEAN_MISSING_REQUIRED_ATTRIBUTE, "DataSource", "URL");
        }
        if (!(this.parent.getStructureType() == SDMX_STRUCTURE_TYPE.CONTENT_CONSTRAINT_ATTACHMENT || this.isRestDatasource || this.isWebServiceDatasource || this.isSimpleDatasource)) {
            throw new SdmxSemmanticException("Registration against a queryable source must either be a REST datasource or a web service datasource");
        }
    }

    private URL getUrl(String urlString) {
        try {
            if (ObjectUtil.validString(urlString)) {
                return new URL(urlString);
            }
        }
        catch (Throwable th) {
            throw new SdmxSemmanticException("Invalid URL '" + urlString + "'");
        }
        return null;
    }

    @Override
    public URL getDataUrl() {
        return this.dataUrl;
    }

    @Override
    public URL getWadlUrl() {
        return this.wadlUrl;
    }

    @Override
    public URL getWSDLUrl() {
        return this.wsdlUrl;
    }

    @Override
    public boolean isRESTDatasource() {
        return this.isRestDatasource;
    }

    @Override
    public boolean isSimpleDatasource() {
        return this.isSimpleDatasource;
    }

    @Override
    public boolean isWebServiceDatasource() {
        return this.isWebServiceDatasource;
    }

    @Override
    public DataSourceMutableBean createMutableInstance() {
        return new DataSourceMutableBeanImpl(this);
    }

    @Override
    protected Set<SDMXBean> getCompositesInternal() {
        return new HashSet<SDMXBean>();
    }
}

