/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.base;

import java.net.URL;
import java.util.List;
import org.apache.xmlbeans.XmlObject;
import org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.common.AnnotationsType;
import org.sdmx.resources.sdmxml.schemas.v20.common.TextType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.MaintainableType;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.constants.TERTIARY_BOOL;
import org.sdmxsource.sdmx.api.constants.TIME_FORMAT;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.model.base.SdmxDate;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.model.mutable.base.MaintainableMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.NameableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.SdmxDateImpl;
import org.sdmxsource.util.ObjectUtil;
import org.sdmxsource.util.VersionableUtil;

public abstract class MaintainableBeanImpl
extends NameableBeanImpl
implements MaintainableBean {
    private static final long serialVersionUID = 1L;
    protected SdmxDate endDate;
    protected SdmxDate startDate;
    private String version;
    protected String agencyId;
    protected TERTIARY_BOOL isFinal = TERTIARY_BOOL.UNSET;
    protected TERTIARY_BOOL isExternalReference = TERTIARY_BOOL.UNSET;
    protected boolean isStub;
    private URL serviceURL;
    private URL structureURL;

    protected MaintainableBeanImpl(MaintainableBean bean, URL actualLocation, boolean isServiceUrl) {
        super(bean);
        this.isStub = true;
        this.endDate = bean.getEndDate();
        this.startDate = bean.getStartDate();
        this.version = bean.getVersion();
        this.agencyId = bean.getAgencyId();
        this.serviceURL = bean.getServiceURL();
        this.structureURL = bean.getStructureURL();
        this.isExternalReference = TERTIARY_BOOL.TRUE;
        if (actualLocation == null) {
            throw new SdmxSemmanticException("Stub Beans require a URL defining the actual service to obtain the full Sdmx artefact from");
        }
        if (isServiceUrl) {
            this.serviceURL = actualLocation;
        } else {
            this.structureURL = actualLocation;
        }
        if (bean.isFinal() != null) {
            this.isFinal = bean.isFinal();
        }
        this.validateMaintainableAttributes();
    }

    protected MaintainableBeanImpl(MaintainableMutableBean bean) {
        super(bean, null);
        this.agencyId = bean.getAgencyId();
        this.isStub = bean.isStub();
        if (bean.getStartDate() != null) {
            this.startDate = new SdmxDateImpl(bean.getStartDate(), TIME_FORMAT.DATE_TIME);
        }
        if (bean.getEndDate() != null) {
            this.endDate = new SdmxDateImpl(bean.getEndDate(), TIME_FORMAT.DATE_TIME);
        }
        if (bean.getFinalStructure() != null) {
            this.isFinal = bean.getFinalStructure();
        }
        if (bean.getExternalReference() != null) {
            this.isExternalReference = bean.getExternalReference();
        }
        if (bean.getServiceURL() != null) {
            this.setServiceURL(bean.getServiceURL());
        }
        if (bean.getStructureURL() != null) {
            this.setStructureURL(bean.getStructureURL());
        }
        this.version = bean.getVersion();
        this.validateMaintainableAttributes();
    }

    protected MaintainableBeanImpl(MaintainableType createdFrom, SDMX_STRUCTURE_TYPE structureType) {
        super(createdFrom, structureType, null);
        this.agencyId = createdFrom.getAgencyID();
        if (createdFrom.getValidFrom() != null) {
            this.startDate = new SdmxDateImpl(createdFrom.getValidFrom().toString());
        }
        if (createdFrom.getValidTo() != null) {
            this.endDate = new SdmxDateImpl(createdFrom.getValidTo().toString());
        }
        this.isFinal = MaintainableBeanImpl.createTertiary(createdFrom.isSetIsFinal(), createdFrom.getIsFinal());
        this.version = createdFrom.getVersion();
        this.isExternalReference = MaintainableBeanImpl.createTertiary(createdFrom.isSetIsExternalReference(), createdFrom.getIsExternalReference());
        this.setServiceURL(createdFrom.getServiceURL());
        this.setStructureURL(createdFrom.getStructureURL());
        this.validateMaintainableAttributes();
    }

    protected MaintainableBeanImpl(XmlObject createdFrom, SDMX_STRUCTURE_TYPE structureType, Object endDate, Object startDate, String version, TERTIARY_BOOL isFinal, String agencyId, String id, String uri, List<TextType> name, List<TextType> description, TERTIARY_BOOL isExternalReference, org.sdmx.resources.sdmxml.schemas.v20.common.AnnotationsType annotationsType) {
        super(createdFrom, structureType, id, uri, name, description, annotationsType, null);
        this.agencyId = agencyId;
        if (startDate != null) {
            this.startDate = new SdmxDateImpl(startDate.toString());
        }
        if (endDate != null) {
            this.endDate = new SdmxDateImpl(endDate.toString());
        }
        if (isFinal != null) {
            this.isFinal = isFinal;
        }
        this.version = version;
        if (isExternalReference != null) {
            this.isExternalReference = isExternalReference;
        }
        if (this.isExternalReference == TERTIARY_BOOL.TRUE) {
            this.setStructureURL(uri);
        }
        this.validateMaintainableAttributes();
    }

    protected MaintainableBeanImpl(XmlObject createdFrom, SDMX_STRUCTURE_TYPE structureType, String version, String agencyId, String id, String uri, List<org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.common.TextType> name, TERTIARY_BOOL isExternalReference, AnnotationsType annotationsType) {
        super(createdFrom, structureType, id, uri, name, null, annotationsType, null);
        this.agencyId = agencyId;
        this.version = version;
        this.isExternalReference = isExternalReference;
        if (this.isExternalReference == TERTIARY_BOOL.TRUE) {
            this.setStructureURL(uri);
        }
        this.validateMaintainableAttributes();
    }

    protected boolean deepEqualsInternal(MaintainableBean bean, boolean includeFinalProperties) {
        if (bean == null) {
            return false;
        }
        if (includeFinalProperties) {
            if (!ObjectUtil.equivalent(this.startDate, bean.getStartDate())) {
                return false;
            }
            if (!ObjectUtil.equivalent(this.endDate, bean.getEndDate())) {
                return false;
            }
            if (!ObjectUtil.equivalent((Object)this.isExternalReference, (Object)bean.isExternalReference())) {
                return false;
            }
            if (!ObjectUtil.equivalent(this.serviceURL, bean.getServiceURL())) {
                return false;
            }
            if (!ObjectUtil.equivalent(this.structureURL, bean.getStructureURL())) {
                return false;
            }
        }
        if (!ObjectUtil.equivalent(this.agencyId, bean.getAgencyId())) {
            return false;
        }
        if (!ObjectUtil.equivalent((Object)this.isFinal, (Object)bean.isFinal())) {
            return false;
        }
        return super.deepEqualsInternal(bean, includeFinalProperties);
    }

    protected void validateMaintainableAttributes() throws SdmxSemmanticException {
        this.validateAgencyId();
        if (!ObjectUtil.validString(this.version)) {
            this.version = "1.0";
        }
        if (!VersionableUtil.validVersion(this.version)) {
            throw new SdmxSemmanticException(ExceptionCode.STRUCTURE_INVALID_VERSION, this.version);
        }
        if (this.endDate != null && this.startDate != null && this.startDate.isLater(this.endDate)) {
            throw new SdmxSemmanticException(ExceptionCode.END_DATE_BEFORE_START_DATE, new Object[0]);
        }
        if (this.isStub) {
            this.isExternalReference = TERTIARY_BOOL.TRUE;
        }
        if (this.isExternalReference == null) {
            this.isExternalReference = TERTIARY_BOOL.UNSET;
        }
        if (this.isExternalReference.isTrue() && this.structureURL == null) {
            throw new SdmxSemmanticException(ExceptionCode.EXTERNAL_STRUCTURE_MISSING_URI, new Object[0]);
        }
        if (ObjectUtil.validString(this.getId()) && this.getId().equals("ALL")) {
            throw new SdmxSemmanticException("ALL is a reserved word and can not be used for an id");
        }
    }

    protected void validateAgencyId() {
        if (!ObjectUtil.validString(this.getAgencyId())) {
            throw new SdmxSemmanticException(ExceptionCode.STRUCTURE_MAINTAINABLE_MISSING_AGENCY, new Object[]{this.structureType});
        }
    }

    @Override
    public String getAgencyId() {
        return this.agencyId;
    }

    @Override
    public SdmxDate getEndDate() {
        return this.endDate;
    }

    @Override
    public SdmxDate getStartDate() {
        return this.startDate;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public TERTIARY_BOOL isFinal() {
        return this.isFinal;
    }

    @Override
    public boolean isStub() {
        return this.isStub;
    }

    @Override
    public TERTIARY_BOOL isExternalReference() {
        return this.isExternalReference;
    }

    @Override
    public int compareTo(MaintainableBean maintainableBean) {
        return VersionableUtil.isHigherVersion(this.version, maintainableBean.getVersion()) ? 1 : -1;
    }

    private void setServiceURL(String serviceURLStr) {
        if (serviceURLStr == null) {
            this.serviceURL = null;
            return;
        }
        try {
            this.serviceURL = new URL(serviceURLStr);
        }
        catch (Throwable th) {
            throw new SdmxSemmanticException(th, "Could not create attribute 'serviceURL' with value '" + serviceURLStr + "'");
        }
    }

    private void setStructureURL(String structureURLStr) {
        if (structureURLStr == null) {
            this.structureURL = null;
            return;
        }
        try {
            this.structureURL = new URL(structureURLStr);
        }
        catch (Throwable th) {
            throw new SdmxSemmanticException(th, "Could not create attribute 'structureURL' with value '" + structureURLStr + "'");
        }
    }

    @Override
    public URL getServiceURL() {
        return this.serviceURL;
    }

    @Override
    public URL getStructureURL() {
        return this.structureURL;
    }
}

