/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.base;

import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.sdmx.resources.sdmxml.schemas.v21.structure.OrganisationUnitSchemeType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.OrganisationUnitType;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.model.beans.base.OrganisationUnitBean;
import org.sdmxsource.sdmx.api.model.beans.base.OrganisationUnitSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.mutable.base.OrganisationUnitMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.base.OrganisationUnitSchemeMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.ItemSchemeBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.OrganisationUnitBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.base.OrganisationUnitSchemeMutableBeanImpl;
import org.sdmxsource.util.ObjectUtil;

public class OrganisationUnitSchemeBeanImpl
extends ItemSchemeBeanImpl<OrganisationUnitBean>
implements OrganisationUnitSchemeBean {
    private static Logger LOG = Logger.getLogger(OrganisationUnitSchemeBeanImpl.class);
    private static final long serialVersionUID = -787661696574731583L;

    private OrganisationUnitSchemeBeanImpl(OrganisationUnitSchemeBean bean, URL actualLocation, boolean isServiceUrl) {
        super(bean, actualLocation, isServiceUrl);
        LOG.debug((Object)"Stub OrganisationUnitSchemeBean Built");
        try {
            this.validate();
        }
        catch (SdmxSemmanticException e) {
            throw new SdmxSemmanticException((Throwable)e, ExceptionCode.FAIL_VALIDATION, this);
        }
    }

    public OrganisationUnitSchemeBeanImpl(OrganisationUnitSchemeMutableBean bean) {
        super(bean);
        LOG.debug((Object)"Building OrganisationUnitSchemeBean from Mutable Bean");
        if (bean.getItems() != null) {
            for (OrganisationUnitMutableBean oumb : bean.getItems()) {
                this.items.add(new OrganisationUnitBeanImpl(oumb, (OrganisationUnitSchemeBean)this));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("OrganisationUnitSchemeBean Built " + this.getUrn()));
        }
        try {
            this.validate();
        }
        catch (SdmxSemmanticException e) {
            throw new SdmxSemmanticException((Throwable)e, ExceptionCode.FAIL_VALIDATION, this);
        }
    }

    public OrganisationUnitSchemeBeanImpl(OrganisationUnitSchemeType type) {
        super(type, SDMX_STRUCTURE_TYPE.ORGANISATION_UNIT_SCHEME);
        LOG.debug((Object)"Building OrganisationUnitSchemeBean from 2.1 SDMX");
        if (ObjectUtil.validCollection(type.getOrganisationUnitList())) {
            for (OrganisationUnitType currentType : type.getOrganisationUnitList()) {
                this.items.add(new OrganisationUnitBeanImpl(currentType, (OrganisationUnitSchemeBean)this));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("OrganisationUnitSchemeBean Built " + this.getUrn()));
        }
        try {
            this.validate();
        }
        catch (SdmxSemmanticException e) {
            throw new SdmxSemmanticException((Throwable)e, ExceptionCode.FAIL_VALIDATION, this);
        }
    }

    @Override
    public boolean deepEquals(SDMXBean bean, boolean includeFinalProperties) {
        if (bean == null) {
            return false;
        }
        if (bean.getStructureType() == this.getStructureType()) {
            return super.deepEqualsInternal((OrganisationUnitSchemeBean)bean, includeFinalProperties);
        }
        return false;
    }

    private void validate() throws SdmxSemmanticException {
        HashMap<OrganisationUnitBean, Set<OrganisationUnitBean>> parentChildMap = new HashMap<OrganisationUnitBean, Set<OrganisationUnitBean>>();
        for (OrganisationUnitBean currentUnit : this.getItems()) {
            Set<OrganisationUnitBean> children;
            if (!ObjectUtil.validString(currentUnit.getParentUnit())) continue;
            OrganisationUnitBean parentUnit = this.getUnit(currentUnit.getParentUnit());
            if (parentChildMap.containsKey(parentUnit)) {
                children = (Set)parentChildMap.get(parentUnit);
            } else {
                children = new HashSet();
                parentChildMap.put(parentUnit, children);
            }
            children.add(currentUnit);
            this.recurseParentMap((Set)parentChildMap.get(currentUnit), parentUnit, parentChildMap);
        }
    }

    private OrganisationUnitBean getUnit(String id) {
        for (OrganisationUnitBean organisationUnitBean : this.getItems()) {
            if (!organisationUnitBean.getId().equals(id)) continue;
            return organisationUnitBean;
        }
        throw new SdmxSemmanticException(ExceptionCode.CAN_NOT_RESOLVE_PARENT, id);
    }

    private void recurseParentMap(Set<OrganisationUnitBean> children, OrganisationUnitBean parentBean, Map<OrganisationUnitBean, Set<OrganisationUnitBean>> parentChildMap) {
        if (children != null) {
            if (children.contains(parentBean)) {
                throw new SdmxSemmanticException(ExceptionCode.PARENT_RECURSIVE_LOOP, parentBean.getId());
            }
            for (OrganisationUnitBean currentChild : children) {
                this.recurseParentMap(parentChildMap.get(currentChild), parentBean, parentChildMap);
            }
        }
    }

    @Override
    public MaintainableBean getStub(URL actualLocation, boolean isServiceUrl) {
        return new OrganisationUnitSchemeBeanImpl(this, actualLocation, isServiceUrl);
    }

    @Override
    public OrganisationUnitSchemeMutableBean getMutableInstance() {
        return new OrganisationUnitSchemeMutableBeanImpl(this);
    }
}

