/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.base;

import java.util.HashSet;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Set;
import org.apache.xmlbeans.XmlCursor;
import org.sdmx.resources.sdmxml.schemas.v20.common.TextType;
import org.sdmx.resources.sdmxml.schemas.v21.common.XHTMLType;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.base.TextTypeWrapper;
import org.sdmxsource.sdmx.api.model.mutable.base.TextTypeWrapperMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.SDMXBeanImpl;
import org.sdmxsource.util.ObjectUtil;

public class TextTypeWrapperImpl
extends SDMXBeanImpl
implements TextTypeWrapper {
    private static final long serialVersionUID = 1L;
    private String locale;
    private String value;
    private boolean isHtmlText;

    public TextTypeWrapperImpl(String locale, String value, SDMXBean parent) {
        super(SDMX_STRUCTURE_TYPE.TEXT_TYPE, parent);
        this.setLocale(locale);
        this.setValue(value);
        this.validate();
    }

    public TextTypeWrapperImpl(TextTypeWrapperMutableBean textType, SDMXBean parent) {
        super(textType, parent);
        this.setLocale(textType.getLocale());
        this.setValue(textType.getValue());
        this.validate();
    }

    public TextTypeWrapperImpl(org.sdmx.resources.sdmxml.schemas.v21.common.TextType textType, SDMXBean parent) {
        super(SDMX_STRUCTURE_TYPE.TEXT_TYPE, parent);
        this.setLocale(textType.getLang());
        this.setValue(textType.getStringValue());
        this.validate();
    }

    public TextTypeWrapperImpl(XHTMLType textType, SDMXBean parent) {
        super(SDMX_STRUCTURE_TYPE.TEXT_TYPE, parent);
        XmlCursor cursor = textType.newCursor();
        this.setLocale(textType.getLang());
        this.setValue(cursor.getTextValue());
        this.isHtmlText = true;
        this.validate();
    }

    public TextTypeWrapperImpl(TextType textType, SDMXBean parent) {
        super(SDMX_STRUCTURE_TYPE.TEXT_TYPE, parent);
        this.setLocale(textType.getLang());
        this.setValue(textType.getStringValue());
        this.validate();
    }

    public TextTypeWrapperImpl(org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.common.TextType textType, SDMXBean parent) {
        super(SDMX_STRUCTURE_TYPE.TEXT_TYPE, parent);
        this.setLocale(textType.getLang());
        this.setValue(textType.getStringValue());
        this.validate();
    }

    private void setLocale(String locale) {
        if (!ObjectUtil.validString(locale)) {
            locale = "en";
        }
        this.locale = locale = locale.replace("_", "-");
    }

    boolean isValidLocale(String value) {
        return this.isValid(this.parseLocale(value));
    }

    private Locale parseLocale(String locale) {
        String[] parts = locale.split("-");
        switch (parts.length) {
            case 3: {
                return new Locale(parts[0], parts[1], parts[2]);
            }
            case 2: {
                return new Locale(parts[0], parts[1]);
            }
            case 1: {
                return new Locale(parts[0]);
            }
        }
        throw new IllegalArgumentException("Invalid locale: " + locale);
    }

    private boolean isValid(Locale locale) {
        try {
            return locale.getISO3Language() != null && locale.getISO3Country() != null;
        }
        catch (MissingResourceException e) {
            return false;
        }
    }

    private void setValue(String value) {
        if (value != null) {
            this.value = value.trim();
        }
    }

    @Override
    public boolean deepEquals(SDMXBean bean, boolean includeFinalProperties) {
        if (bean == null) {
            return false;
        }
        if (bean.getStructureType() == this.getStructureType()) {
            TextTypeWrapper that = (TextTypeWrapper)bean;
            if (!ObjectUtil.equivalent(this.locale, that.getLocale())) {
                return false;
            }
            if (!ObjectUtil.equivalent(this.value, that.getValue())) {
                return false;
            }
            return this.isHtmlText == that.isHtml();
        }
        return false;
    }

    private void validate() throws SdmxSemmanticException {
        if (!ObjectUtil.validString(this.locale)) {
            this.locale = Locale.ENGLISH.getLanguage();
        }
        if (!this.isValidLocale(this.locale)) {
            throw new SdmxSemmanticException("Illegal Locale: " + this.locale);
        }
        if (!ObjectUtil.validString(this.value)) {
            throw new SdmxSemmanticException("Text Type can not have an empty string value");
        }
    }

    @Override
    public String getLocale() {
        return this.locale;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public boolean isHtml() {
        return this.isHtmlText;
    }

    @Override
    protected Set<SDMXBean> getCompositesInternal() {
        return new HashSet<SDMXBean>();
    }
}

