/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.categoryscheme;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.xmlbeans.XmlObject;
import org.sdmx.resources.sdmxml.schemas.v20.structure.CategoryType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.DataflowRefType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.MetadataflowRefType;
import org.sdmx.resources.sdmxml.schemas.v21.common.StructureReferenceType;
import org.sdmx.resources.sdmxml.schemas.v21.common.StructureUsageReferenceType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.ReportingCategoryType;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.SdmxException;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.model.beans.base.IdentifiableBean;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.categoryscheme.ReportingCategoryBean;
import org.sdmxsource.sdmx.api.model.beans.reference.CrossReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.api.model.mutable.categoryscheme.ReportingCategoryMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.ItemBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.util.RefUtil;
import org.sdmxsource.sdmx.util.beans.reference.CrossReferenceBeanImpl;
import org.sdmxsource.util.ObjectUtil;

public class ReportingCategoryBeanImpl
extends ItemBeanImpl
implements ReportingCategoryBean {
    private static final long serialVersionUID = 1L;
    private List<CrossReferenceBean> structuralMetadata = new ArrayList<CrossReferenceBean>();
    private List<CrossReferenceBean> provisioningMetadata = new ArrayList<CrossReferenceBean>();
    private List<ReportingCategoryBean> reportingCategories = new ArrayList<ReportingCategoryBean>();

    public ReportingCategoryBeanImpl(IdentifiableBean parent, ReportingCategoryMutableBean reportingCategory) {
        super(reportingCategory, parent);
        if (reportingCategory.getProvisioningMetadata() != null) {
            for (StructureReferenceBean sRef : reportingCategory.getProvisioningMetadata()) {
                this.provisioningMetadata.add(new CrossReferenceBeanImpl((SDMXBean)this, sRef));
            }
        }
        if (reportingCategory.getStructuralMetadata() != null) {
            for (StructureReferenceBean sRef : reportingCategory.getStructuralMetadata()) {
                this.structuralMetadata.add(new CrossReferenceBeanImpl((SDMXBean)this, sRef));
            }
        }
        if (reportingCategory.getItems() != null) {
            for (ReportingCategoryMutableBean currentBean : reportingCategory.getItems()) {
                this.reportingCategories.add(new ReportingCategoryBeanImpl((IdentifiableBean)this, currentBean));
            }
        }
        try {
            this.validate();
        }
        catch (SdmxSemmanticException ex) {
            throw new SdmxSemmanticException((Throwable)ex, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, this.getUrn());
        }
        catch (Throwable th) {
            throw new SdmxException(th, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, this.getUrn());
        }
    }

    public ReportingCategoryBeanImpl(IdentifiableBean parent, ReportingCategoryType category) {
        super(category, SDMX_STRUCTURE_TYPE.REPORTING_CATEGORY, parent);
        if (category.getProvisioningMetadataList() != null) {
            for (StructureUsageReferenceType structureUsageReferenceType : category.getProvisioningMetadataList()) {
                this.provisioningMetadata.add(RefUtil.createReference(this, structureUsageReferenceType));
            }
        }
        if (category.getStructuralMetadataList() != null) {
            for (StructureReferenceType structureReferenceType : category.getStructuralMetadataList()) {
                this.structuralMetadata.add(RefUtil.createReference(this, structureReferenceType));
            }
        }
        if (category.getReportingCategoryList() != null) {
            for (ReportingCategoryType reportingCategoryType : category.getReportingCategoryList()) {
                this.reportingCategories.add(new ReportingCategoryBeanImpl((IdentifiableBean)this, reportingCategoryType));
            }
        }
        try {
            this.validate();
        }
        catch (SdmxSemmanticException ex) {
            throw new SdmxSemmanticException((Throwable)ex, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, this.getUrn());
        }
        catch (Throwable th) {
            throw new SdmxException(th, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, this.getUrn());
        }
    }

    public ReportingCategoryBeanImpl(IdentifiableBean parent, CategoryType category) {
        super((XmlObject)category, SDMX_STRUCTURE_TYPE.REPORTING_CATEGORY, category.getId(), category.getUri(), category.getNameList(), category.getDescriptionList(), category.getAnnotations(), parent);
        if (category.getDataflowRefList() != null) {
            for (DataflowRefType dfRef : category.getDataflowRefList()) {
                if (ObjectUtil.validString(dfRef.getURN())) {
                    this.provisioningMetadata.add(new CrossReferenceBeanImpl((SDMXBean)this, dfRef.getURN()));
                    continue;
                }
                this.provisioningMetadata.add(new CrossReferenceBeanImpl(this, dfRef.getAgencyID(), dfRef.getDataflowID(), dfRef.getVersion(), SDMX_STRUCTURE_TYPE.DATAFLOW));
            }
        }
        if (category.getMetadataflowRefList() != null) {
            for (MetadataflowRefType mdfRef : category.getMetadataflowRefList()) {
                if (ObjectUtil.validString(mdfRef.getURN())) {
                    this.provisioningMetadata.add(new CrossReferenceBeanImpl((SDMXBean)this, mdfRef.getURN()));
                    continue;
                }
                this.provisioningMetadata.add(new CrossReferenceBeanImpl(this, mdfRef.getAgencyID(), mdfRef.getMetadataflowID(), mdfRef.getVersion(), SDMX_STRUCTURE_TYPE.METADATA_FLOW));
            }
        }
        if (category.getCategoryList() != null) {
            for (CategoryType childCategory : category.getCategoryList()) {
                this.reportingCategories.add(new ReportingCategoryBeanImpl((IdentifiableBean)this, childCategory));
            }
        }
        try {
            this.validate();
        }
        catch (SdmxSemmanticException ex) {
            throw new SdmxSemmanticException((Throwable)ex, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, this.getUrn());
        }
        catch (Throwable th) {
            throw new SdmxException(th, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, this.getUrn());
        }
    }

    @Override
    public boolean deepEquals(SDMXBean bean, boolean includeFinalProperties) {
        if (bean == null) {
            return false;
        }
        if (bean.getStructureType() == this.getStructureType()) {
            ReportingCategoryBean that = (ReportingCategoryBean)bean;
            if (!ObjectUtil.equivalent(this.structuralMetadata, that.getStructuralMetadata())) {
                return false;
            }
            if (!ObjectUtil.equivalent(this.provisioningMetadata, that.getProvisioningMetadata())) {
                return false;
            }
            if (!super.equivalent(this.reportingCategories, that.getItems(), includeFinalProperties)) {
                return false;
            }
            return super.deepEqualsInternal(that, includeFinalProperties);
        }
        return false;
    }

    private void validate() {
        if (ObjectUtil.validCollection(this.provisioningMetadata) && ObjectUtil.validCollection(this.structuralMetadata)) {
            throw new SdmxSemmanticException("Reporting Category can not have both structural metadata and provisioning metadata");
        }
        for (CrossReferenceBean crossReference : this.structuralMetadata) {
            if (crossReference.getTargetReference() == SDMX_STRUCTURE_TYPE.DSD || crossReference.getTargetReference() == SDMX_STRUCTURE_TYPE.MSD) continue;
            throw new SdmxSemmanticException("Reporting Category 'Structural Metadata' must either reference DSDs or MSDs, not " + crossReference.getTargetReference().getType());
        }
        for (CrossReferenceBean crossReference : this.provisioningMetadata) {
            if (crossReference.getTargetReference() == SDMX_STRUCTURE_TYPE.DATAFLOW || crossReference.getTargetReference() == SDMX_STRUCTURE_TYPE.METADATA_FLOW) continue;
            throw new SdmxSemmanticException("Reporting Category 'Provisioning Metadata' must either reference a Data Flow or Metadata Flow, not " + crossReference.getTargetReference().getType());
        }
    }

    @Override
    public List<ReportingCategoryBean> getItems() {
        return new ArrayList<ReportingCategoryBean>(this.reportingCategories);
    }

    @Override
    public List<CrossReferenceBean> getStructuralMetadata() {
        return new ArrayList<CrossReferenceBean>(this.structuralMetadata);
    }

    @Override
    public List<CrossReferenceBean> getProvisioningMetadata() {
        return new ArrayList<CrossReferenceBean>(this.provisioningMetadata);
    }

    @Override
    protected Set<SDMXBean> getCompositesInternal() {
        Set<SDMXBean> composites = super.getCompositesInternal();
        super.addToCompositeSet(this.reportingCategories, composites);
        return composites;
    }
}

