/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.codelist;

import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.ValidationException;
import org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.structure.CodeType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.CodeListType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.CodelistType;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.SdmxException;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodeBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodelistBean;
import org.sdmxsource.sdmx.api.model.mutable.codelist.CodeMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.codelist.CodelistMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.ItemSchemeBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.codelist.CodeBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.codelist.CodelistMutableBeanImpl;
import org.sdmxsource.util.ObjectUtil;

public class CodelistBeanImpl
extends ItemSchemeBeanImpl<CodeBean>
implements CodelistBean {
    private static final long serialVersionUID = 1L;

    private CodelistBeanImpl(CodelistBean bean, URL actualLocation, boolean isServiceUrl) {
        super(bean, actualLocation, isServiceUrl);
    }

    public CodelistBeanImpl(CodelistMutableBean codelist) {
        super(codelist);
        try {
            if (codelist.getItems() != null) {
                for (CodeMutableBean code : codelist.getItems()) {
                    this.items.add(new CodeBeanImpl((CodelistBean)this, code));
                }
            }
        }
        catch (SdmxSemmanticException ex) {
            throw new SdmxSemmanticException((Throwable)ex, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, this.getUrn());
        }
        catch (Throwable th) {
            throw new SdmxException(th, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, this.getUrn());
        }
        try {
            this.validate();
        }
        catch (SdmxSemmanticException ex) {
            throw new SdmxSemmanticException((Throwable)ex, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, this.getUrn());
        }
        catch (Throwable th) {
            throw new SdmxException(th, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, this.getUrn());
        }
    }

    public CodelistBeanImpl(org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.structure.CodeListType bean) {
        super(bean, SDMX_STRUCTURE_TYPE.CODE_LIST, bean.getVersion(), bean.getAgency(), bean.getId(), bean.getUri(), bean.getNameList(), CodelistBeanImpl.createTertiary(bean.isSetIsExternalReference(), bean.getIsExternalReference()), bean.getAnnotations());
        try {
            for (CodeType currentCode : bean.getCodeList()) {
                this.items.add(new CodeBeanImpl((CodelistBean)this, currentCode));
            }
        }
        catch (SdmxSemmanticException ex) {
            throw new SdmxSemmanticException((Throwable)ex, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, this.getUrn());
        }
        catch (Throwable th) {
            throw new SdmxException(th, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, this.getUrn());
        }
        try {
            this.validate();
        }
        catch (SdmxSemmanticException ex) {
            throw new SdmxSemmanticException((Throwable)ex, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, this.getUrn());
        }
        catch (Throwable th) {
            throw new SdmxException(th, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, this.getUrn());
        }
    }

    public CodelistBeanImpl(CodeListType bean) {
        super(bean, SDMX_STRUCTURE_TYPE.CODE_LIST, bean.getValidTo(), bean.getValidFrom(), bean.getVersion(), CodelistBeanImpl.createTertiary(bean.isSetIsFinal(), bean.getIsFinal()), bean.getAgencyID(), bean.getId(), bean.getUri(), bean.getNameList(), bean.getDescriptionList(), CodelistBeanImpl.createTertiary(bean.isSetIsExternalReference(), bean.getIsExternalReference()), bean.getAnnotations());
        try {
            for (org.sdmx.resources.sdmxml.schemas.v20.structure.CodeType currentCode : bean.getCodeList()) {
                this.items.add(new CodeBeanImpl((CodelistBean)this, currentCode));
            }
        }
        catch (SdmxSemmanticException ex) {
            throw new SdmxSemmanticException((Throwable)ex, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, this.getUrn());
        }
        catch (Throwable th) {
            throw new SdmxException(th, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, this.getUrn());
        }
        try {
            this.validate();
        }
        catch (SdmxSemmanticException ex) {
            throw new SdmxSemmanticException((Throwable)ex, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, this.getUrn());
        }
        catch (Throwable th) {
            throw new SdmxException(th, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, this.getUrn());
        }
    }

    public CodelistBeanImpl(CodelistType bean) {
        super(bean, SDMX_STRUCTURE_TYPE.CODE_LIST);
        try {
            for (org.sdmx.resources.sdmxml.schemas.v21.structure.CodeType currentCode : bean.getCodeList()) {
                this.items.add(new CodeBeanImpl((CodelistBean)this, currentCode));
            }
        }
        catch (SdmxSemmanticException ex) {
            throw new SdmxSemmanticException((Throwable)ex, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, this.getUrn());
        }
        catch (Throwable th) {
            throw new SdmxException(th, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, this.getUrn());
        }
        try {
            this.validate();
        }
        catch (SdmxSemmanticException ex) {
            throw new SdmxSemmanticException((Throwable)ex, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, this.getUrn());
        }
        catch (Throwable th) {
            throw new SdmxException(th, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, this.getUrn());
        }
    }

    @Override
    public boolean deepEquals(SDMXBean bean, boolean includeFinalProperties) {
        if (bean == null) {
            return false;
        }
        if (bean.getStructureType() == this.getStructureType()) {
            return super.deepEqualsInternal((CodelistBean)bean, includeFinalProperties);
        }
        return false;
    }

    private void validate() throws ValidationException {
        HashSet<String> urns = new HashSet<String>();
        if (this.items != null) {
            HashMap<CodeBean, Set<CodeBean>> parentChildMap = new HashMap<CodeBean, Set<CodeBean>>();
            for (CodeBean code : this.items) {
                Set<CodeBean> children;
                if (urns.contains(code.getUrn())) {
                    throw new SdmxSemmanticException(ExceptionCode.DUPLICATE_URN, code.getUrn());
                }
                urns.add(code.getUrn());
                if (!ObjectUtil.validString(code.getParentCode())) continue;
                CodeBean parentCode = this.getCode(this.items, code.getParentCode());
                if (parentChildMap.containsKey(parentCode)) {
                    children = (Set)parentChildMap.get(parentCode);
                } else {
                    children = new HashSet();
                    parentChildMap.put(parentCode, children);
                }
                children.add(code);
                this.recurseParentMap((Set)parentChildMap.get(code), parentCode, parentChildMap);
            }
        }
    }

    @Override
    protected void validateId(boolean startWithIntAllowed) {
        super.validateId(false);
    }

    private void recurseParentMap(Set<CodeBean> children, CodeBean parentCode, Map<CodeBean, Set<CodeBean>> parentChildMap) {
        if (children != null) {
            if (children.contains(parentCode)) {
                throw new SdmxSemmanticException(ExceptionCode.PARENT_RECURSIVE_LOOP, parentCode.getId());
            }
            for (CodeBean currentChild : children) {
                this.recurseParentMap(parentChildMap.get(currentChild), parentCode, parentChildMap);
            }
        }
    }

    private CodeBean getCode(List<CodeBean> codes, String id) {
        for (CodeBean currentCode : codes) {
            if (!currentCode.getId().equals(id)) continue;
            return currentCode;
        }
        throw new SdmxSemmanticException(ExceptionCode.CAN_NOT_RESOLVE_PARENT, id);
    }

    @Override
    public CodelistBean getStub(URL actualLocation, boolean isServiceUrl) {
        return new CodelistBeanImpl(this, actualLocation, isServiceUrl);
    }

    @Override
    public CodelistMutableBean getMutableInstance() {
        return new CodelistMutableBeanImpl(this);
    }

    @Override
    public CodeBean getCodeById(String id) {
        for (CodeBean currentCode : this.items) {
            if (!currentCode.getId().equals(id)) continue;
            return currentCode;
        }
        return null;
    }
}

