/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.codelist;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.apache.xmlbeans.XmlObject;
import org.sdmx.resources.sdmxml.schemas.v20.structure.CodeRefType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.HierarchyType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.LevelType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.HierarchicalCodeType;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.SdmxException;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.model.beans.base.IdentifiableBean;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.base.SdmxStructureBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.HierarchicalCodeBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.HierarchicalCodelistBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.HierarchyBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.LevelBean;
import org.sdmxsource.sdmx.api.model.mutable.base.HierarchyMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.reference.CodeRefMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.NameableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.codelist.HierarchicalCodeBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.codelist.LevelBeanImpl;
import org.sdmxsource.util.ObjectUtil;

public class HierarchyBeanImpl
extends NameableBeanImpl
implements HierarchyBean {
    private static final long serialVersionUID = 1L;
    private List<HierarchicalCodeBean> codeRefs = new ArrayList<HierarchicalCodeBean>();
    private LevelBean level;
    private boolean hasFormalLevels;

    public HierarchyBeanImpl(HierarchicalCodelistBean parent, HierarchyMutableBean hierarchy) {
        super(hierarchy, parent);
        if (hierarchy.getHierarchicalCodeBeans() != null) {
            for (CodeRefMutableBean currentCoderef : hierarchy.getHierarchicalCodeBeans()) {
                this.codeRefs.add(new HierarchicalCodeBeanImpl(currentCoderef, (SdmxStructureBean)this));
            }
        }
        this.hasFormalLevels = hierarchy.isFormalLevels();
        if (hierarchy.getChildLevel() != null) {
            this.level = new LevelBeanImpl((IdentifiableBean)this, hierarchy.getChildLevel());
        }
        try {
            this.validate();
        }
        catch (SdmxSemmanticException ex) {
            throw new SdmxSemmanticException((Throwable)ex, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, this.getUrn());
        }
        catch (Throwable th) {
            throw new SdmxException(th, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, this.getUrn());
        }
    }

    public HierarchyBeanImpl(HierarchicalCodelistBean parent, org.sdmx.resources.sdmxml.schemas.v21.structure.HierarchyType hierarchy) {
        super(hierarchy, SDMX_STRUCTURE_TYPE.HIERARCHY, parent);
        this.hasFormalLevels = hierarchy.getLeveled();
        if (hierarchy.getLevel() != null) {
            this.level = new LevelBeanImpl((IdentifiableBean)this, hierarchy.getLevel());
        }
        if (hierarchy.getHierarchicalCodeList() != null) {
            for (HierarchicalCodeType currentCoderef : hierarchy.getHierarchicalCodeList()) {
                this.codeRefs.add(new HierarchicalCodeBeanImpl(currentCoderef, (SdmxStructureBean)this));
            }
        }
        try {
            if (hierarchy.getLeveled() && this.level == null) {
                throw new SdmxSemmanticException("Hierarchy declares itself as levelled, but does not define any levels");
            }
            this.validate();
        }
        catch (SdmxSemmanticException ex) {
            throw new SdmxSemmanticException((Throwable)ex, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, this.getUrn());
        }
        catch (Throwable th) {
            throw new SdmxException(th, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, this.getUrn());
        }
    }

    public HierarchyBeanImpl(HierarchicalCodelistBean parent, HierarchyType hierarchy) {
        super((XmlObject)hierarchy, SDMX_STRUCTURE_TYPE.HIERARCHY, hierarchy.getId(), null, hierarchy.getNameList(), hierarchy.getDescriptionList(), hierarchy.getAnnotations(), (IdentifiableBean)parent);
        if (ObjectUtil.validCollection(hierarchy.getLevelList())) {
            TreeMap<Integer, LevelType> levelMap = new TreeMap<Integer, LevelType>();
            for (LevelType levl : hierarchy.getLevelList()) {
                levelMap.put(levl.getOrder().intValue(), levl);
            }
            ArrayList<LevelType> levelList = new ArrayList<LevelType>();
            for (int i = 1; i <= (Integer)levelMap.lastKey(); ++i) {
                if (levelMap.containsKey(i)) {
                    levelList.add((LevelType)levelMap.get(i));
                    continue;
                }
                LevelType defaultLevel = LevelType.Factory.newInstance();
                defaultLevel.setId("DEFAULT");
                defaultLevel.addNewName().setStringValue("Default");
                levelList.add(defaultLevel);
            }
            this.level = new LevelBeanImpl(this, levelList, 0);
            this.hasFormalLevels = true;
        }
        if (hierarchy.getCodeRefList() != null) {
            for (CodeRefType currentCoderef : hierarchy.getCodeRefList()) {
                this.codeRefs.add(new HierarchicalCodeBeanImpl(currentCoderef, (SdmxStructureBean)this));
            }
        }
        try {
            this.validate();
        }
        catch (SdmxSemmanticException ex) {
            throw new SdmxSemmanticException((Throwable)ex, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, this.getUrn());
        }
        catch (Throwable th) {
            throw new SdmxException(th, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, this.getUrn());
        }
    }

    @Override
    public boolean deepEquals(SDMXBean bean, boolean includeFinalProperties) {
        if (bean == null) {
            return false;
        }
        if (bean.getStructureType() == this.getStructureType()) {
            HierarchyBean that = (HierarchyBean)bean;
            if (!super.equivalent(this.codeRefs, that.getHierarchicalCodeBeans(), includeFinalProperties)) {
                return false;
            }
            if (!super.equivalent(this.level, that.getLevel(), includeFinalProperties)) {
                return false;
            }
            if (this.hasFormalLevels != that.hasFormalLevels()) {
                return false;
            }
            return super.deepEqualsInternal(that, includeFinalProperties);
        }
        return false;
    }

    private void validate() {
        if (!ObjectUtil.validCollection(this.codeRefs)) {
            throw new SdmxSemmanticException("Hierarchy must contain at least one hierarchical code");
        }
        if (this.hasFormalLevels) {
            this.validateHasLevel(this.codeRefs);
        }
    }

    private void validateHasLevel(List<HierarchicalCodeBean> codeRefs) {
        if (codeRefs != null) {
            for (HierarchicalCodeBean currentHCode : codeRefs) {
                this.validateHasLevel(currentHCode.getCodeRefs());
                if (currentHCode.getLevel(true) != null) continue;
                throw new SdmxSemmanticException("Hierarchy indicates formal levels, but Hierarchical Code '" + currentHCode.getUrn() + "' is missing a level reference and there is no default level for it's depth in the hierarchy");
            }
        }
    }

    @Override
    public List<HierarchicalCodeBean> getHierarchicalCodeBeans() {
        return new ArrayList<HierarchicalCodeBean>(this.codeRefs);
    }

    @Override
    public LevelBean getLevel() {
        return this.level;
    }

    @Override
    public LevelBean getLevelAtPosition(int levelPos) {
        LevelBean currentLevel = this.level;
        for (int i = 1; i <= levelPos; ++i) {
            if (currentLevel == null) {
                return null;
            }
            if (i == levelPos) {
                return currentLevel;
            }
            currentLevel = currentLevel.getChildLevel();
        }
        return null;
    }

    @Override
    public boolean hasFormalLevels() {
        return this.hasFormalLevels;
    }

    @Override
    public HierarchicalCodelistBean getMaintainableParent() {
        return (HierarchicalCodelistBean)super.getMaintainableParent();
    }

    @Override
    protected Set<SDMXBean> getCompositesInternal() {
        Set<SDMXBean> composites = super.getCompositesInternal();
        super.addToCompositeSet(this.codeRefs, composites);
        super.addToCompositeSet(this.level, composites);
        return composites;
    }
}

