/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.datastructure;

import org.sdmx.resources.sdmxml.schemas.v20.structure.CrossSectionalMeasureType;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.SdmxException;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.model.beans.base.IdentifiableBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.CrossSectionalDataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.CrossSectionalMeasureBean;
import org.sdmxsource.sdmx.api.model.mutable.datastructure.CrossSectionalMeasureMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.ComponentBeanImpl;

public class CrossSectionalMeasureBeanImpl
extends ComponentBeanImpl
implements CrossSectionalMeasureBean {
    private static final long serialVersionUID = -6945109855247194247L;
    private String measureDimension;
    private String code;

    public CrossSectionalMeasureBeanImpl(CrossSectionalMeasureMutableBean bean, CrossSectionalDataStructureBean parent) {
        super(bean, parent);
        this.measureDimension = bean.getMeasureDimension();
        this.code = bean.getCode();
        try {
            this.validate();
        }
        catch (SdmxSemmanticException ex) {
            throw new SdmxSemmanticException((Throwable)ex, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, this.getUrn());
        }
        catch (Throwable th) {
            throw new SdmxException(th, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, this.getUrn());
        }
    }

    public CrossSectionalMeasureBeanImpl(CrossSectionalMeasureType createdFrom, IdentifiableBean parent) {
        super(createdFrom, SDMX_STRUCTURE_TYPE.CROSS_SECTIONAL_MEASURE, createdFrom.getAnnotations(), createdFrom.getTextFormat(), createdFrom.getCodelistAgency(), createdFrom.getCodelist(), createdFrom.getCodelistVersion(), createdFrom.getConceptSchemeAgency(), createdFrom.getConceptSchemeRef(), createdFrom.getConceptVersion(), createdFrom.getConceptAgency(), createdFrom.getConceptRef(), parent);
        this.measureDimension = createdFrom.getMeasureDimension();
        this.code = createdFrom.getCode();
        try {
            this.validate();
        }
        catch (SdmxSemmanticException ex) {
            throw new SdmxSemmanticException((Throwable)ex, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, this.getUrn());
        }
        catch (Throwable th) {
            throw new SdmxException(th, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, this.getUrn());
        }
    }

    private void validate() {
        if (this.measureDimension == null) {
            throw new SdmxSemmanticException("Cross Sectional Measure Dimension missing mandatory Measure Dimension reference");
        }
        if (this.code == null) {
            throw new SdmxSemmanticException("Cross Sectional Measure Dimension missing mandatory Code reference");
        }
        if (((CrossSectionalDataStructureBean)this.getMaintainableParent()).getDimension(this.measureDimension) == null) {
            throw new SdmxSemmanticException("Cross Sectional Measure Dimension references non-existent dimension " + this.measureDimension);
        }
    }

    @Override
    public String getMeasureDimension() {
        return this.measureDimension;
    }

    @Override
    public String getCode() {
        return this.code;
    }
}

