/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.datastructure;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.ValidationException;
import org.apache.log4j.Logger;
import org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.structure.ComponentsType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.GroupType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.KeyFamilyType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.DataStructureComponentsType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.DataStructureType;
import org.sdmxsource.sdmx.api.constants.ATTRIBUTE_ATTACHMENT_LEVEL;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_SCHEMA;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.SdmxException;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.model.beans.base.ComponentBean;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.base.SdmxStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.AttributeBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.AttributeListBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DimensionBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DimensionListBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.GroupBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.MeasureListBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.PrimaryMeasureBean;
import org.sdmxsource.sdmx.api.model.beans.reference.CrossReferenceBean;
import org.sdmxsource.sdmx.api.model.mutable.datastructure.DataStructureMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.datastructure.GroupMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.MaintainableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.datastructure.AttributeListBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.datastructure.DimensionListBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.datastructure.GroupBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.datastructure.MeasureListBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.datastructure.DataStructureMutableBeanImpl;
import org.sdmxsource.util.ObjectUtil;

public class DataStructureBeanImpl
extends MaintainableBeanImpl
implements DataStructureBean {
    private static Logger LOG = Logger.getLogger(DataStructureBeanImpl.class);
    private static final long serialVersionUID = 5566227534589657654L;
    private List<GroupBean> groups = new ArrayList<GroupBean>();
    private DimensionListBean dimensionList;
    private AttributeListBean attributeList;
    private MeasureListBean measureList;

    private DataStructureBeanImpl(DataStructureBean bean, URL actualLocation, boolean isServiceUrl) {
        super(bean, actualLocation, isServiceUrl);
        LOG.debug((Object)"Stub DataStructureBean Built");
    }

    public DataStructureBeanImpl(DataStructureMutableBean bean) {
        super(bean);
        LOG.debug((Object)"Building DataStructureBean from Mutable Bean");
        try {
            if (bean.getGroups() != null) {
                for (GroupMutableBean mutable : bean.getGroups()) {
                    this.groups.add(new GroupBeanImpl(mutable, (SdmxStructureBean)this));
                }
            }
            if (bean.getMeasureList() != null) {
                this.measureList = new MeasureListBeanImpl(bean.getMeasureList(), (MaintainableBean)this);
            }
            if (bean.getDimensionList() != null) {
                this.dimensionList = new DimensionListBeanImpl(bean.getDimensionList(), this);
            }
            if (bean.getAttributeList() != null) {
                this.attributeList = new AttributeListBeanImpl(bean.getAttributeList(), this);
            }
        }
        catch (SdmxSemmanticException ex) {
            throw new SdmxSemmanticException((Throwable)ex, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, this.getUrn());
        }
        catch (Throwable th) {
            throw new SdmxException(th, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, this.getUrn());
        }
        try {
            this.validate();
        }
        catch (SdmxSemmanticException ex) {
            throw new SdmxSemmanticException((Throwable)ex, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, this.getUrn());
        }
        catch (Throwable th) {
            throw new SdmxException(th, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, this.getUrn());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("DataStructureBean Built " + this.getUrn()));
        }
    }

    public DataStructureBeanImpl(DataStructureType bean) {
        super(bean, SDMX_STRUCTURE_TYPE.DSD);
        LOG.debug((Object)"Building DataStructureBean from 2.1 SDMX");
        DataStructureComponentsType components = bean.getDataStructureComponents();
        try {
            if (components != null) {
                for (org.sdmx.resources.sdmxml.schemas.v21.structure.GroupType currentGroup : components.getGroupList()) {
                    this.groups.add(new GroupBeanImpl(currentGroup, (SdmxStructureBean)this));
                }
                if (components.getDimensionList() != null) {
                    this.dimensionList = new DimensionListBeanImpl(components.getDimensionList(), (MaintainableBean)this);
                }
                if (components.getAttributeList() != null) {
                    this.attributeList = new AttributeListBeanImpl(components.getAttributeList(), (MaintainableBean)this);
                }
                if (components.getMeasureList() != null) {
                    this.measureList = new MeasureListBeanImpl(components.getMeasureList(), (MaintainableBean)this);
                }
            }
        }
        catch (Throwable th) {
            throw new SdmxSemmanticException(th, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, this);
        }
        try {
            this.validate();
        }
        catch (ValidationException e) {
            throw new SdmxSemmanticException((Throwable)e, ExceptionCode.FAIL_VALIDATION, this);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("DataStructureBean Built " + this.getUrn()));
        }
    }

    public DataStructureBeanImpl(KeyFamilyType bean) {
        super(bean, SDMX_STRUCTURE_TYPE.DSD, bean.getValidTo(), bean.getValidFrom(), bean.getVersion(), DataStructureBeanImpl.createTertiary(bean.isSetIsFinal(), bean.getIsFinal()), bean.getAgencyID(), bean.getId(), bean.getUri(), bean.getNameList(), bean.getDescriptionList(), DataStructureBeanImpl.createTertiary(bean.isSetIsExternalReference(), bean.getIsExternalReference()), bean.getAnnotations());
        LOG.debug((Object)"Building DataStructureBean from 2.0 SDMX");
        org.sdmx.resources.sdmxml.schemas.v20.structure.ComponentsType components = bean.getComponents();
        try {
            if (components != null) {
                for (GroupType currentGroup : components.getGroupList()) {
                    this.groups.add(new GroupBeanImpl(currentGroup, (SdmxStructureBean)this));
                }
                if (components.getDimensionList() != null) {
                    this.dimensionList = new DimensionListBeanImpl(bean, (MaintainableBean)this);
                }
                if (components.getPrimaryMeasure() != null) {
                    this.measureList = new MeasureListBeanImpl(components.getPrimaryMeasure(), (MaintainableBean)this);
                }
                if (components.getAttributeList() != null) {
                    this.attributeList = new AttributeListBeanImpl(bean, (MaintainableBean)this);
                }
            } else {
                this.isStub = true;
            }
        }
        catch (SdmxSemmanticException ex) {
            throw new SdmxSemmanticException((Throwable)ex, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, this.getUrn());
        }
        catch (Throwable th) {
            throw new SdmxException(th, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, this.getUrn());
        }
        try {
            this.validate();
        }
        catch (ValidationException e) {
            throw new SdmxSemmanticException((Throwable)e, ExceptionCode.FAIL_VALIDATION, this);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("DataStructureBean Built " + this.getUrn()));
        }
    }

    public DataStructureBeanImpl(org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.structure.KeyFamilyType bean) {
        super(bean, SDMX_STRUCTURE_TYPE.DSD, bean.getVersion(), bean.getAgency(), bean.getId(), bean.getUri(), bean.getNameList(), null, bean.getAnnotations());
        LOG.debug((Object)"Building DataStructureBean from 1.0 SDMX");
        ComponentsType components = bean.getComponents();
        if (components != null) {
            for (org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.structure.GroupType currentGroup : components.getGroupList()) {
                this.groups.add(new GroupBeanImpl(currentGroup, (SdmxStructureBean)this));
            }
            if (components.getDimensionList() != null) {
                this.dimensionList = new DimensionListBeanImpl(bean, (MaintainableBean)this);
            }
            if (components.getPrimaryMeasure() != null) {
                this.measureList = new MeasureListBeanImpl(components.getPrimaryMeasure(), (MaintainableBean)this);
            }
            if (components.getAttributeList() != null) {
                this.attributeList = new AttributeListBeanImpl(bean, (MaintainableBean)this);
            }
        } else {
            this.isStub = true;
        }
        try {
            this.validate();
        }
        catch (ValidationException e) {
            throw new SdmxSemmanticException((Throwable)e, ExceptionCode.FAIL_VALIDATION, this);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("DataStructureBean Built " + this.getUrn()));
        }
    }

    @Override
    public boolean deepEquals(SDMXBean bean, boolean includeFinalProperties) {
        if (bean == null) {
            return false;
        }
        if (bean.getStructureType() == this.getStructureType()) {
            DataStructureBean that = (DataStructureBean)bean;
            if (!super.equivalent(this.groups, that.getGroups(), includeFinalProperties)) {
                return false;
            }
            if (!super.equivalent(this.dimensionList, that.getDimensionList(), includeFinalProperties)) {
                return false;
            }
            if (!super.equivalent(this.attributeList, that.getAttributeList(), includeFinalProperties)) {
                return false;
            }
            if (!super.equivalent(this.measureList, that.getMeasureList(), includeFinalProperties)) {
                return false;
            }
            return super.deepEqualsInternal(that, includeFinalProperties);
        }
        return false;
    }

    private void validate() throws ValidationException {
        if (!this.isExternalReference.isTrue()) {
            HashMap<String, DimensionBean> dimensionMap = new HashMap<String, DimensionBean>();
            HashSet<String> conceptIds = new HashSet<String>();
            HashSet<Integer> dimPos = new HashSet<Integer>();
            if (!ObjectUtil.validCollection(this.getDimensions(new SDMX_STRUCTURE_TYPE[0]))) {
                throw new SdmxSemmanticException("DSD must have at least one dimension");
            }
            for (DimensionBean dimension : this.getDimensions(new SDMX_STRUCTURE_TYPE[0])) {
                if (dimPos.contains(dimension.getPosition())) {
                    throw new SdmxSemmanticException("Two dimensions can not share the same dimension position : " + dimension.getPosition());
                }
                dimPos.add(dimension.getPosition());
                String conceptId = dimension.getId();
                this.validateUniqueComponentBean(conceptIds, dimension);
                dimensionMap.put(conceptId, dimension);
            }
            boolean foundFreq = false;
            for (DimensionBean dimension : this.getDimensions(new SDMX_STRUCTURE_TYPE[0])) {
                if (!dimension.isFrequencyDimension()) continue;
                if (foundFreq) {
                    throw new SdmxSemmanticException("DataStructure can not have more then one frequency dimension");
                }
                foundFreq = true;
            }
            HashSet<String> groupIds = new HashSet<String>();
            if (this.groups != null) {
                for (GroupBean group : this.groups) {
                    for (String dimensionRef : group.getDimensionRefs()) {
                        if (dimensionMap.containsKey(dimensionRef)) continue;
                        DimensionBean timeDimensionBean = this.getTimeDimension();
                        if (timeDimensionBean != null && timeDimensionBean.getId().equals(dimensionRef)) {
                            throw new SdmxSemmanticException(ExceptionCode.GROUP_CANNOT_REFERENCE_TIME_DIMENSION, group.getId());
                        }
                        throw new SdmxSemmanticException(ExceptionCode.REFERENCE_ERROR, new Object[]{(Object)((Object)SDMX_STRUCTURE_TYPE.DIMENSION) + " " + dimensionRef, SDMX_STRUCTURE_TYPE.GROUP, group.toString()});
                    }
                    if (groupIds.contains(group.getId())) {
                        throw new SdmxSemmanticException(ExceptionCode.KEY_FAMILY_DUPLICATE_GROUP_ID, group.getId());
                    }
                    groupIds.add(group.getId());
                }
            }
            if (this.getPrimaryMeasure() != null) {
                this.validateUniqueComponentBean(conceptIds, this.getPrimaryMeasure());
            } else if (!this.isStub) {
                throw new SdmxSemmanticException(ExceptionCode.BEAN_MISSING_REQUIRED_ELEMENT, new Object[]{this.structureType, "PrimaryMeasure"});
            }
            for (AttributeBean currentBean : this.getAttributes()) {
                this.validateUniqueComponentBean(conceptIds, currentBean);
                if (currentBean.getAttachmentLevel() != ATTRIBUTE_ATTACHMENT_LEVEL.GROUP) continue;
                if (currentBean.getAttachmentGroup() == null) {
                    throw new SdmxSemmanticException(ExceptionCode.KEY_FAMILY_GROUP_ATTRIBUTE_MISSING_GROUPID, currentBean.toString());
                }
                if (groupIds.contains(currentBean.getAttachmentGroup())) continue;
                throw new SdmxSemmanticException(ExceptionCode.REFERENCE_ERROR, new Object[]{SDMX_STRUCTURE_TYPE.GROUP, SDMX_STRUCTURE_TYPE.DATA_ATTRIBUTE, currentBean.toString()});
            }
        }
    }

    @Override
    public boolean isCompatible(SDMX_SCHEMA schemaVersion) {
        switch (schemaVersion) {
            case VERSION_ONE: {
                for (ComponentBean componentBean : this.getDimensions(SDMX_STRUCTURE_TYPE.DIMENSION)) {
                    if (componentBean.getRepresentation() != null && componentBean.getRepresentation().getRepresentation() != null) continue;
                    return false;
                }
            }
            case VERSION_TWO: {
                HashSet<String> componentIds = new HashSet<String>();
                for (ComponentBean currentComponent : this.getComponents()) {
                    if (currentComponent.getConceptRef().getTargetReference() != SDMX_STRUCTURE_TYPE.CONCEPT) continue;
                    String conceptId = currentComponent.getConceptRef().getFullId();
                    if (componentIds.contains(conceptId)) {
                        return false;
                    }
                    componentIds.add(conceptId);
                }
                break;
            }
        }
        return true;
    }

    private void validateUniqueComponentBean(Set<String> conceptIds, ComponentBean componentBean) {
        String conceptId = componentBean.getId();
        if (conceptIds.contains(conceptId)) {
            throw new SdmxSemmanticException("Duplicate Data Structure Component Id : " + conceptId);
        }
        conceptIds.add(conceptId);
    }

    @Override
    public DataStructureBean getStub(URL actualLocation, boolean isServiceUrl) {
        return new DataStructureBeanImpl(this, actualLocation, isServiceUrl);
    }

    @Override
    public List<CrossReferenceBean> getCrossReferencedConstrainables() {
        return new ArrayList<CrossReferenceBean>();
    }

    @Override
    public DataStructureMutableBean getMutableInstance() {
        return new DataStructureMutableBeanImpl(this);
    }

    @Override
    public DimensionListBean getDimensionList() {
        return this.dimensionList;
    }

    @Override
    public AttributeListBean getAttributeList() {
        return this.attributeList;
    }

    @Override
    public MeasureListBean getMeasureList() {
        return this.measureList;
    }

    @Override
    public List<ComponentBean> getComponents() {
        ArrayList<ComponentBean> returnList = new ArrayList<ComponentBean>();
        returnList.addAll(this.getDimensionList().getDimensions());
        returnList.addAll(this.getAttributes());
        returnList.add(this.getPrimaryMeasure());
        return returnList;
    }

    @Override
    public AttributeBean getAttribute(String id) {
        if (ObjectUtil.validString(id)) {
            for (AttributeBean currentAttribute : this.getAttributes()) {
                if (!currentAttribute.getId().equals(id)) continue;
                return currentAttribute;
            }
        }
        return null;
    }

    @Override
    public List<AttributeBean> getSeriesAttributes(String crossSectionalConcept) {
        if (crossSectionalConcept == null) {
            return this.getDimensionGroupAttributes();
        }
        ArrayList<AttributeBean> returnList = new ArrayList<AttributeBean>();
        for (AttributeBean att : this.getDimensionGroupAttributes()) {
            if (att.getDimensionReferences().contains(crossSectionalConcept)) continue;
            returnList.add(att);
        }
        return returnList;
    }

    @Override
    public List<AttributeBean> getObservationAttributes(String crossSectionalConcept) {
        if (crossSectionalConcept == null) {
            return this.getObservationAttributes();
        }
        ArrayList<AttributeBean> returnList = new ArrayList<AttributeBean>();
        for (AttributeBean att : this.getDimensionGroupAttributes()) {
            if (!att.getDimensionReferences().contains(crossSectionalConcept)) continue;
            returnList.add(att);
        }
        returnList.addAll(this.getObservationAttributes());
        return returnList;
    }

    @Override
    public List<DimensionBean> getDimensions(SDMX_STRUCTURE_TYPE ... includeTypes) {
        if (this.dimensionList != null) {
            ArrayList<DimensionBean> returnList = new ArrayList<DimensionBean>();
            for (DimensionBean dim : this.dimensionList.getDimensions()) {
                if (includeTypes != null && includeTypes.length > 0) {
                    for (SDMX_STRUCTURE_TYPE currentType : includeTypes) {
                        if (currentType != dim.getStructureType()) continue;
                        returnList.add(dim);
                    }
                    continue;
                }
                returnList.add(dim);
            }
            return returnList;
        }
        return new ArrayList<DimensionBean>();
    }

    @Override
    public DimensionBean getDimension(String conceptId) {
        return (DimensionBean)this.getComponent(this.getDimensions(new SDMX_STRUCTURE_TYPE[0]), conceptId);
    }

    @Override
    public DimensionBean getFrequencyDimension() {
        for (DimensionBean currentDimension : this.getDimensions(new SDMX_STRUCTURE_TYPE[0])) {
            if (!currentDimension.isFrequencyDimension()) continue;
            return currentDimension;
        }
        return null;
    }

    @Override
    public boolean hasFrequencyDimension() {
        for (DimensionBean currentDimension : this.getDimensions(SDMX_STRUCTURE_TYPE.DIMENSION)) {
            if (!currentDimension.isFrequencyDimension()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ComponentBean getComponent(String conceptId) {
        ComponentBean component = null;
        component = this.getComponent(this.getDimensions(new SDMX_STRUCTURE_TYPE[0]), conceptId);
        if (component != null) {
            return component;
        }
        component = this.getComponent(this.getAttributes(), conceptId);
        if (component != null) {
            return component;
        }
        if (this.measureList != null && this.measureList.getPrimaryMeasure().getId().equals(conceptId)) {
            return this.measureList.getPrimaryMeasure();
        }
        return null;
    }

    private ComponentBean getComponent(List<? extends ComponentBean> components, String conceptId) {
        for (ComponentBean componentBean : components) {
            if (!componentBean.getId().equals(conceptId)) continue;
            return componentBean;
        }
        return null;
    }

    @Override
    public List<GroupBean> getGroups() {
        return new ArrayList<GroupBean>(this.groups);
    }

    @Override
    public GroupBean getGroup(String groupId) {
        for (GroupBean currentGroup : this.groups) {
            if (!currentGroup.getId().equals(groupId)) continue;
            return currentGroup;
        }
        return null;
    }

    @Override
    public DimensionBean getTimeDimension() {
        for (DimensionBean currentDimension : this.getDimensions(new SDMX_STRUCTURE_TYPE[0])) {
            if (!currentDimension.isTimeDimension()) continue;
            return currentDimension;
        }
        return null;
    }

    @Override
    public PrimaryMeasureBean getPrimaryMeasure() {
        if (this.measureList != null) {
            return this.measureList.getPrimaryMeasure();
        }
        return null;
    }

    @Override
    public List<AttributeBean> getAttributes() {
        if (this.attributeList != null) {
            return this.attributeList.getAttributes();
        }
        return new ArrayList<AttributeBean>();
    }

    @Override
    public List<AttributeBean> getDatasetAttributes() {
        return this.getAttribute(ATTRIBUTE_ATTACHMENT_LEVEL.DATA_SET);
    }

    @Override
    public List<AttributeBean> getGroupAttributes(String groupId, boolean includeDimensionGroups) {
        GroupBean group = this.getGroup(groupId);
        if (group == null) {
            throw new IllegalArgumentException("Group not found on Data Structure '" + this.getUrn() + "' with id: " + groupId);
        }
        List<AttributeBean> allGroupAttributes = this.getGroupAttributes();
        ArrayList<AttributeBean> returnList = new ArrayList<AttributeBean>();
        for (AttributeBean currentAttribute : allGroupAttributes) {
            if (currentAttribute.getAttachmentGroup() == null || !currentAttribute.getAttachmentGroup().equals(groupId)) continue;
            returnList.add(currentAttribute);
        }
        for (AttributeBean cuAttributeBean : this.getDimensionGroupAttributes()) {
            List<String> grpDimRefs;
            List<String> attrDimRefs = cuAttributeBean.getDimensionReferences();
            if (!attrDimRefs.containsAll(grpDimRefs = group.getDimensionRefs()) || !grpDimRefs.containsAll(attrDimRefs)) continue;
            returnList.add(cuAttributeBean);
        }
        return returnList;
    }

    @Override
    public List<AttributeBean> getGroupAttributes() {
        return this.getAttribute(ATTRIBUTE_ATTACHMENT_LEVEL.GROUP);
    }

    @Override
    public List<AttributeBean> getDimensionGroupAttributes() {
        return this.getAttribute(ATTRIBUTE_ATTACHMENT_LEVEL.DIMENSION_GROUP);
    }

    @Override
    public List<AttributeBean> getObservationAttributes() {
        return this.getAttribute(ATTRIBUTE_ATTACHMENT_LEVEL.OBSERVATION);
    }

    @Override
    public AttributeBean getGroupAttribute(String conceptId) {
        return this.getAttribute(ATTRIBUTE_ATTACHMENT_LEVEL.GROUP, conceptId);
    }

    @Override
    public AttributeBean getDimensionGroupAttribute(String conceptId) {
        return this.getAttribute(ATTRIBUTE_ATTACHMENT_LEVEL.DIMENSION_GROUP, conceptId);
    }

    @Override
    public AttributeBean getObservationAttribute(String conceptId) {
        return this.getAttribute(ATTRIBUTE_ATTACHMENT_LEVEL.OBSERVATION, conceptId);
    }

    private List<AttributeBean> getAttribute(ATTRIBUTE_ATTACHMENT_LEVEL type) {
        ArrayList<AttributeBean> returnList = new ArrayList<AttributeBean>();
        for (AttributeBean currentAttribute : this.getAttributes()) {
            if (currentAttribute.getAttachmentLevel() != type) continue;
            returnList.add(currentAttribute);
        }
        return returnList;
    }

    private AttributeBean getAttribute(ATTRIBUTE_ATTACHMENT_LEVEL type, String conceptId) {
        for (AttributeBean currentAttribute : this.getAttribute(type)) {
            if (!currentAttribute.getId().equals(conceptId)) continue;
            return currentAttribute;
        }
        return null;
    }

    @Override
    protected Set<SDMXBean> getCompositesInternal() {
        Set<SDMXBean> composites = super.getCompositesInternal();
        super.addToCompositeSet(this.groups, composites);
        super.addToCompositeSet(this.dimensionList, composites);
        super.addToCompositeSet(this.attributeList, composites);
        super.addToCompositeSet(this.measureList, composites);
        return composites;
    }
}

