/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.mapping;

import java.util.ArrayList;
import java.util.List;
import org.sdmx.resources.sdmxml.schemas.v20.structure.CategoryIDType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.CategoryMapType;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.base.SdmxStructureBean;
import org.sdmxsource.sdmx.api.model.beans.mapping.CategoryMapBean;
import org.sdmxsource.sdmx.api.model.mutable.base.MutableBean;
import org.sdmxsource.sdmx.api.model.mutable.mapping.CategoryMapMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.SdmxStructureBeanImpl;
import org.sdmxsource.util.ObjectUtil;

public class CategoryMapBeanImpl
extends SdmxStructureBeanImpl
implements CategoryMapBean {
    private static final long serialVersionUID = 1L;
    private String alias;
    private List<String> sourceId = new ArrayList<String>();
    private List<String> targetId = new ArrayList<String>();

    protected CategoryMapBeanImpl(CategoryMapMutableBean bean, SdmxStructureBean parent) {
        super((MutableBean)bean, parent);
        this.alias = bean.getAlias();
        if (bean.getSourceId() != null) {
            this.sourceId = new ArrayList<String>(bean.getSourceId());
        }
        if (bean.getTargetId() != null) {
            this.targetId = new ArrayList<String>(bean.getTargetId());
        }
        this.validate();
    }

    protected CategoryMapBeanImpl(CategoryMapType catType, SdmxStructureBean parent) {
        super(SDMX_STRUCTURE_TYPE.CATEGORY_MAP, parent);
        this.validate();
    }

    protected CategoryMapBeanImpl(org.sdmx.resources.sdmxml.schemas.v20.structure.CategoryMapType catType, SdmxStructureBean parent) {
        super(SDMX_STRUCTURE_TYPE.CATEGORY_MAP, parent);
        this.alias = catType.getCategoryAlias();
        this.populateCategoryIdList(this.sourceId, catType.getCategoryID());
        this.populateCategoryIdList(this.targetId, catType.getTargetCategoryID());
        this.validate();
    }

    private void populateCategoryIdList(List<String> catIdList, CategoryIDType currentIdType) {
        catIdList.add(currentIdType.getID());
        if (currentIdType.getCategoryID() != null) {
            this.populateCategoryIdList(catIdList, currentIdType.getCategoryID());
        }
    }

    @Override
    public boolean deepEquals(SDMXBean bean, boolean includeFinalProperties) {
        if (bean == null) {
            return false;
        }
        if (bean.getStructureType() == this.getStructureType()) {
            CategoryMapBean that = (CategoryMapBean)bean;
            if (!ObjectUtil.equivalentCollection(this.sourceId, that.getSourceId())) {
                return false;
            }
            if (!ObjectUtil.equivalentCollection(this.targetId, that.getTargetId())) {
                return false;
            }
            return ObjectUtil.equivalent(this.alias, that.getAlias());
        }
        return false;
    }

    protected void validate() throws SdmxSemmanticException {
        if (this.sourceId == null) {
            throw new SdmxSemmanticException(ExceptionCode.BEAN_MISSING_REQUIRED_ELEMENT, "CategoryMap", "CategoryID");
        }
        if (this.targetId == null) {
            throw new SdmxSemmanticException(ExceptionCode.BEAN_MISSING_REQUIRED_ELEMENT, "CategoryMap", "TargetCategoryID");
        }
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public List<String> getSourceId() {
        return new ArrayList<String>(this.sourceId);
    }

    @Override
    public List<String> getTargetId() {
        return new ArrayList<String>(this.targetId);
    }
}

