/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.mapping;

import javax.xml.bind.ValidationException;
import org.apache.xmlbeans.XmlObject;
import org.sdmx.resources.sdmxml.schemas.v21.structure.CodeMapType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.CodelistMapType;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.SdmxException;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.model.beans.base.IdentifiableBean;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.mapping.CodelistMapBean;
import org.sdmxsource.sdmx.api.model.beans.mapping.StructureSetBean;
import org.sdmxsource.sdmx.api.model.mutable.mapping.CodelistMapMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.mapping.ItemMapBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.mapping.ItemSchemeMapBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.util.RefUtil;
import org.sdmxsource.sdmx.util.beans.reference.CrossReferenceBeanImpl;
import org.sdmxsource.util.ObjectUtil;

public class CodelistMapBeanImpl
extends ItemSchemeMapBeanImpl
implements CodelistMapBean {
    private static final long serialVersionUID = 1L;
    private String srcAlias;
    private String targetAlias;

    public CodelistMapBeanImpl(CodelistMapMutableBean bean, StructureSetBean parent) {
        super(bean, SDMX_STRUCTURE_TYPE.CODE_LIST_MAP, (IdentifiableBean)parent);
        this.srcAlias = bean.getSrcAlias();
        this.targetAlias = bean.getTargetAlias();
        if (bean.getTargetRef() != null) {
            this.targetRef = new CrossReferenceBeanImpl((SDMXBean)this, bean.getTargetRef());
        }
        if (bean.getSourceRef() != null) {
            this.sourceRef = new CrossReferenceBeanImpl((SDMXBean)this, bean.getSourceRef());
        }
        try {
            this.validate();
        }
        catch (ValidationException e) {
            throw new SdmxSemmanticException((Throwable)e, ExceptionCode.FAIL_VALIDATION, this);
        }
    }

    public CodelistMapBeanImpl(CodelistMapType codelistMapType, StructureSetBean parent) {
        super(codelistMapType, SDMX_STRUCTURE_TYPE.CODE_LIST_MAP, (IdentifiableBean)parent);
        try {
            this.sourceRef = RefUtil.createReference(this, codelistMapType.getSource());
            this.targetRef = RefUtil.createReference(this, codelistMapType.getTarget());
            if (codelistMapType.getCodeMapList() != null) {
                for (CodeMapType codeMap : codelistMapType.getCodeMapList()) {
                    ItemMapBeanImpl item = new ItemMapBeanImpl(codeMap.getSource().getRef().getId(), codeMap.getTarget().getRef().getId(), this);
                    this.items.add(item);
                }
            }
        }
        catch (SdmxSemmanticException ex) {
            throw new SdmxSemmanticException((Throwable)ex, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, this.getUrn());
        }
        catch (Throwable th) {
            throw new SdmxException(th, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, this.getUrn());
        }
        try {
            this.validate();
        }
        catch (ValidationException e) {
            throw new SdmxSemmanticException((Throwable)e, ExceptionCode.FAIL_VALIDATION, this);
        }
    }

    public CodelistMapBeanImpl(org.sdmx.resources.sdmxml.schemas.v20.structure.CodelistMapType codeMapType, StructureSetBean parent) {
        super((XmlObject)codeMapType, SDMX_STRUCTURE_TYPE.CODE_LIST_MAP, codeMapType.getId(), null, codeMapType.getNameList(), codeMapType.getDescriptionList(), codeMapType.getAnnotations(), (IdentifiableBean)parent);
        try {
            String agencyId;
            if (codeMapType.getCodelistRef() != null) {
                if (ObjectUtil.validString(codeMapType.getCodelistRef().getURN())) {
                    this.sourceRef = new CrossReferenceBeanImpl((SDMXBean)this, codeMapType.getCodelistRef().getURN());
                } else {
                    agencyId = codeMapType.getCodelistRef().getAgencyID();
                    if (!ObjectUtil.validString(agencyId)) {
                        agencyId = this.getMaintainableParent().getAgencyId();
                    }
                    this.sourceRef = new CrossReferenceBeanImpl(this, agencyId, codeMapType.getCodelistRef().getCodelistID(), codeMapType.getCodelistRef().getVersion(), SDMX_STRUCTURE_TYPE.CODE_LIST);
                }
            } else if (codeMapType.getHierarchicalCodelistRef() != null) {
                if (ObjectUtil.validString(codeMapType.getHierarchicalCodelistRef().getURN())) {
                    this.sourceRef = new CrossReferenceBeanImpl((SDMXBean)this, codeMapType.getHierarchicalCodelistRef().getURN());
                } else {
                    agencyId = codeMapType.getHierarchicalCodelistRef().getAgencyID();
                    if (!ObjectUtil.validString(agencyId)) {
                        agencyId = this.getMaintainableParent().getAgencyId();
                    }
                    this.sourceRef = new CrossReferenceBeanImpl(this, agencyId, codeMapType.getHierarchicalCodelistRef().getHierarchicalCodelistID(), codeMapType.getHierarchicalCodelistRef().getVersion(), SDMX_STRUCTURE_TYPE.HIERARCHICAL_CODELIST);
                }
            }
            if (codeMapType.getTargetCodelistRef() != null) {
                if (ObjectUtil.validString(codeMapType.getTargetCodelistRef().getURN())) {
                    this.targetRef = new CrossReferenceBeanImpl((SDMXBean)this, codeMapType.getTargetCodelistRef().getURN());
                } else {
                    agencyId = codeMapType.getTargetCodelistRef().getAgencyID();
                    if (!ObjectUtil.validString(agencyId)) {
                        agencyId = this.getMaintainableParent().getAgencyId();
                    }
                    this.targetRef = new CrossReferenceBeanImpl(this, agencyId, codeMapType.getTargetCodelistRef().getCodelistID(), codeMapType.getTargetCodelistRef().getVersion(), SDMX_STRUCTURE_TYPE.CODE_LIST);
                }
            } else if (codeMapType.getTargetHierarchicalCodelistRef() != null) {
                if (ObjectUtil.validString(codeMapType.getTargetHierarchicalCodelistRef().getURN())) {
                    this.targetRef = new CrossReferenceBeanImpl((SDMXBean)this, codeMapType.getTargetHierarchicalCodelistRef().getURN());
                } else {
                    agencyId = codeMapType.getTargetHierarchicalCodelistRef().getAgencyID();
                    if (!ObjectUtil.validString(agencyId)) {
                        agencyId = this.getMaintainableParent().getAgencyId();
                    }
                    this.targetRef = new CrossReferenceBeanImpl(this, agencyId, codeMapType.getTargetHierarchicalCodelistRef().getHierarchicalCodelistID(), codeMapType.getTargetHierarchicalCodelistRef().getVersion(), SDMX_STRUCTURE_TYPE.HIERARCHICAL_CODELIST);
                }
            }
            if (codeMapType.getCodeMapList() != null) {
                for (org.sdmx.resources.sdmxml.schemas.v20.structure.CodeMapType codeMap : codeMapType.getCodeMapList()) {
                    ItemMapBeanImpl item = new ItemMapBeanImpl(codeMap.getCodeAlias(), codeMap.getMapCodeRef(), codeMap.getMapTargetCodeRef(), this);
                    this.items.add(item);
                }
            }
        }
        catch (SdmxSemmanticException ex) {
            throw new SdmxSemmanticException((Throwable)ex, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, this.getUrn());
        }
        catch (Throwable th) {
            throw new SdmxException(th, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, this.getUrn());
        }
        try {
            this.validate();
        }
        catch (ValidationException e) {
            throw new SdmxSemmanticException((Throwable)e, ExceptionCode.FAIL_VALIDATION, this);
        }
    }

    @Override
    public boolean deepEquals(SDMXBean bean, boolean includeFinalProperties) {
        if (bean == null) {
            return false;
        }
        if (bean.getStructureType() == this.getStructureType()) {
            CodelistMapBean that = (CodelistMapBean)bean;
            if (!ObjectUtil.equivalent(this.srcAlias, that.getSrcAlias())) {
                return false;
            }
            if (!ObjectUtil.equivalent(this.srcAlias, that.getTargetAlias())) {
                return false;
            }
            return super.deepEqualsInternal(that, includeFinalProperties);
        }
        return false;
    }

    protected void validate() throws ValidationException {
        if (this.sourceRef == null) {
            throw new SdmxSemmanticException(ExceptionCode.BEAN_MISSING_REQUIRED_ELEMENT, new Object[]{this.structureType, "Source"});
        }
        if (this.targetRef == null) {
            throw new SdmxSemmanticException(ExceptionCode.BEAN_MISSING_REQUIRED_ELEMENT, new Object[]{this.structureType, "Target"});
        }
        if (this.items == null) {
            throw new SdmxSemmanticException(ExceptionCode.BEAN_MISSING_REQUIRED_ELEMENT, new Object[]{this.structureType, "CodeMap"});
        }
    }

    @Override
    public String getSrcAlias() {
        return this.srcAlias;
    }

    @Override
    public String getTargetAlias() {
        return this.targetAlias;
    }
}

