/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.mapping;

import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.base.SdmxStructureBean;
import org.sdmxsource.sdmx.api.model.beans.mapping.ItemMapBean;
import org.sdmxsource.sdmx.api.model.mutable.base.MutableBean;
import org.sdmxsource.sdmx.api.model.mutable.mapping.ItemMapMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.SdmxStructureBeanImpl;
import org.sdmxsource.sdmx.util.beans.ValidationUtil;
import org.sdmxsource.util.ObjectUtil;

public class ItemMapBeanImpl
extends SdmxStructureBeanImpl
implements ItemMapBean {
    private static final long serialVersionUID = 1L;
    private String sourceId;
    private String targetId;

    public ItemMapBeanImpl(ItemMapMutableBean bean, SdmxStructureBean parent) {
        super((MutableBean)bean, parent);
        this.sourceId = bean.getSourceId();
        this.targetId = bean.getTargetId();
        this.validate();
    }

    public ItemMapBeanImpl(String id, String target, SdmxStructureBean parent) {
        super(SDMX_STRUCTURE_TYPE.ITEM_MAP, parent);
        this.sourceId = id;
        this.targetId = target;
        this.validate();
    }

    public ItemMapBeanImpl(String alias, String id, String target, SdmxStructureBean parent) {
        super(SDMX_STRUCTURE_TYPE.ITEM_MAP, parent);
        this.sourceId = id;
        this.targetId = target;
        this.validate();
    }

    @Override
    public boolean deepEquals(SDMXBean bean, boolean includeFinalProperties) {
        if (bean == null) {
            return false;
        }
        if (bean.getStructureType() == this.getStructureType()) {
            ItemMapBean that = (ItemMapBean)bean;
            if (!ObjectUtil.equivalent(this.sourceId, that.getSourceId())) {
                return false;
            }
            return ObjectUtil.equivalent(this.targetId, that.getTargetId());
        }
        return false;
    }

    protected void validate() throws SdmxSemmanticException {
        if (!ObjectUtil.validString(this.sourceId)) {
            throw new SdmxSemmanticException(ExceptionCode.BEAN_MISSING_REQUIRED_ELEMENT, "ItemMap", "Source Id");
        }
        if (!ObjectUtil.validString(this.targetId)) {
            throw new SdmxSemmanticException(ExceptionCode.BEAN_MISSING_REQUIRED_ELEMENT, "ItemMap", "Target Id");
        }
        this.sourceId = ValidationUtil.cleanAndValidateId(this.sourceId, true);
        this.targetId = ValidationUtil.cleanAndValidateId(this.targetId, true);
    }

    @Override
    public String getSourceId() {
        return this.sourceId;
    }

    @Override
    public String getTargetId() {
        return this.targetId;
    }
}

