/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.mapping;

import java.util.ArrayList;
import java.util.List;
import org.sdmx.resources.sdmxml.schemas.v20.structure.CategorySchemeRefType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.ConceptSchemeRefType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.HierarchicalCodelistRefType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.KeyFamilyRefType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.MetadataStructureRefType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.OrganisationSchemeRefType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.RelatedStructuresType;
import org.sdmx.resources.sdmxml.schemas.v21.common.StructureOrUsageReferenceType;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.base.SdmxStructureBean;
import org.sdmxsource.sdmx.api.model.beans.mapping.RelatedStructuresBean;
import org.sdmxsource.sdmx.api.model.beans.reference.CrossReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.api.model.mutable.base.MutableBean;
import org.sdmxsource.sdmx.api.model.mutable.mapping.RelatedStructuresMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.SdmxStructureBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.util.RefUtil;
import org.sdmxsource.sdmx.util.beans.reference.CrossReferenceBeanImpl;
import org.sdmxsource.util.ObjectUtil;

public class RelatedStructuresBeanImpl
extends SdmxStructureBeanImpl
implements RelatedStructuresBean {
    private static final long serialVersionUID = 1L;
    private List<CrossReferenceBean> keyFamilyRef = new ArrayList<CrossReferenceBean>();
    private List<CrossReferenceBean> metadataStructureRef = new ArrayList<CrossReferenceBean>();
    private List<CrossReferenceBean> conceptSchemeRef = new ArrayList<CrossReferenceBean>();
    private List<CrossReferenceBean> categorySchemeRef = new ArrayList<CrossReferenceBean>();
    private List<CrossReferenceBean> orgSchemeRef = new ArrayList<CrossReferenceBean>();
    private List<CrossReferenceBean> hierCodelistRef = new ArrayList<CrossReferenceBean>();

    public RelatedStructuresBeanImpl(RelatedStructuresMutableBean bean, SdmxStructureBean parent) {
        super((MutableBean)bean, parent);
        this.keyFamilyRef = this.createCrossReferenceList(bean.getDataStructureRef());
        this.metadataStructureRef = this.createCrossReferenceList(bean.getMetadataStructureRef());
        this.conceptSchemeRef = this.createCrossReferenceList(bean.getConceptSchemeRef());
        this.categorySchemeRef = this.createCrossReferenceList(bean.getCategorySchemeRef());
        this.orgSchemeRef = this.createCrossReferenceList(bean.getOrgSchemeRef());
        this.hierCodelistRef = this.createCrossReferenceList(bean.getHierCodelistRef());
    }

    private List<CrossReferenceBean> createCrossReferenceList(List<StructureReferenceBean> structureReferences) {
        ArrayList<CrossReferenceBean> retrurnList = new ArrayList<CrossReferenceBean>();
        if (structureReferences != null) {
            for (StructureReferenceBean currentStructureReference : structureReferences) {
                retrurnList.add(new CrossReferenceBeanImpl((SDMXBean)this, currentStructureReference));
            }
        }
        return retrurnList;
    }

    public RelatedStructuresBeanImpl(List<StructureOrUsageReferenceType> relStrucTypeList, SdmxStructureBean parent) {
        super(SDMX_STRUCTURE_TYPE.RELATED_STRUCTURES, parent);
        block8: for (StructureOrUsageReferenceType relStrucType : relStrucTypeList) {
            CrossReferenceBean structureReference = RefUtil.createReference(this, relStrucType);
            switch (structureReference.getTargetReference()) {
                case DSD: {
                    this.keyFamilyRef.add(structureReference);
                    continue block8;
                }
                case MSD: {
                    this.metadataStructureRef.add(structureReference);
                    continue block8;
                }
                case CONCEPT_SCHEME: {
                    this.conceptSchemeRef.add(structureReference);
                    continue block8;
                }
                case CATEGORY_SCHEME: {
                    this.categorySchemeRef.add(structureReference);
                    continue block8;
                }
                case ORGANISATION_UNIT_SCHEME: {
                    this.orgSchemeRef.add(structureReference);
                    continue block8;
                }
                case HIERARCHICAL_CODELIST: {
                    this.hierCodelistRef.add(structureReference);
                    continue block8;
                }
            }
            throw new SdmxSemmanticException("RelatedStructuresBean can not reference : " + structureReference.getTargetReference().getType());
        }
    }

    public RelatedStructuresBeanImpl(RelatedStructuresType relStrucType, SdmxStructureBean parent) {
        super(SDMX_STRUCTURE_TYPE.RELATED_STRUCTURES, parent);
        if (relStrucType.getKeyFamilyRefList() != null) {
            for (KeyFamilyRefType keyFam : relStrucType.getKeyFamilyRefList()) {
                if (ObjectUtil.validString(keyFam.getURN())) {
                    this.keyFamilyRef.add(new CrossReferenceBeanImpl((SDMXBean)this, keyFam.getURN()));
                    continue;
                }
                this.keyFamilyRef.add(new CrossReferenceBeanImpl(this, keyFam.getKeyFamilyAgencyID(), keyFam.getKeyFamilyID(), keyFam.getVersion(), SDMX_STRUCTURE_TYPE.DSD));
            }
        }
        if (relStrucType.getMetadataStructureRefList() != null) {
            for (MetadataStructureRefType metStruc : relStrucType.getMetadataStructureRefList()) {
                if (ObjectUtil.validString(metStruc.getURN())) {
                    this.metadataStructureRef.add(new CrossReferenceBeanImpl((SDMXBean)this, metStruc.getURN()));
                    continue;
                }
                this.metadataStructureRef.add(new CrossReferenceBeanImpl(this, metStruc.getMetadataStructureAgencyID(), metStruc.getMetadataStructureID(), metStruc.getVersion(), SDMX_STRUCTURE_TYPE.MSD));
            }
        }
        if (relStrucType.getConceptSchemeRefList() != null) {
            for (ConceptSchemeRefType conStruc : relStrucType.getConceptSchemeRefList()) {
                if (ObjectUtil.validString(conStruc.getURN())) {
                    this.conceptSchemeRef.add(new CrossReferenceBeanImpl((SDMXBean)this, conStruc.getURN()));
                    continue;
                }
                this.conceptSchemeRef.add(new CrossReferenceBeanImpl(this, conStruc.getAgencyID(), conStruc.getConceptSchemeID(), conStruc.getVersion(), SDMX_STRUCTURE_TYPE.CONCEPT_SCHEME));
            }
        }
        if (relStrucType.getCategorySchemeRefList() != null) {
            for (CategorySchemeRefType catStruc : relStrucType.getCategorySchemeRefList()) {
                if (ObjectUtil.validString(catStruc.getURN())) {
                    this.categorySchemeRef.add(new CrossReferenceBeanImpl((SDMXBean)this, catStruc.getURN()));
                    continue;
                }
                this.categorySchemeRef.add(new CrossReferenceBeanImpl(this, catStruc.getAgencyID(), catStruc.getCategorySchemeID(), catStruc.getVersion(), SDMX_STRUCTURE_TYPE.CATEGORY_SCHEME));
            }
        }
        if (relStrucType.getOrganisationSchemeRefList() != null) {
            for (OrganisationSchemeRefType orgScheme : relStrucType.getOrganisationSchemeRefList()) {
                if (ObjectUtil.validString(orgScheme.getURN())) {
                    this.orgSchemeRef.add(new CrossReferenceBeanImpl((SDMXBean)this, orgScheme.getURN()));
                    continue;
                }
                this.orgSchemeRef.add(new CrossReferenceBeanImpl(this, orgScheme.getAgencyID(), orgScheme.getOrganisationSchemeID(), orgScheme.getVersion(), SDMX_STRUCTURE_TYPE.ORGANISATION_UNIT_SCHEME));
            }
        }
        if (relStrucType.getHierarchicalCodelistRefList() != null) {
            for (HierarchicalCodelistRefType hierCode : relStrucType.getHierarchicalCodelistRefList()) {
                if (ObjectUtil.validString(hierCode.getURN())) {
                    this.hierCodelistRef.add(new CrossReferenceBeanImpl((SDMXBean)this, hierCode.getURN()));
                    continue;
                }
                this.hierCodelistRef.add(new CrossReferenceBeanImpl(this, hierCode.getAgencyID(), hierCode.getHierarchicalCodelistID(), hierCode.getVersion(), SDMX_STRUCTURE_TYPE.HIERARCHICAL_CODELIST));
            }
        }
    }

    @Override
    public boolean deepEquals(SDMXBean bean, boolean includeFinalProperties) {
        if (bean == null) {
            return false;
        }
        if (bean.getStructureType() == this.getStructureType()) {
            RelatedStructuresBean that = (RelatedStructuresBean)bean;
            if (!ObjectUtil.equivalentCollection(this.keyFamilyRef, that.getDataStructureRef())) {
                return false;
            }
            if (!ObjectUtil.equivalentCollection(this.metadataStructureRef, that.getMetadataStructureRef())) {
                return false;
            }
            if (!ObjectUtil.equivalentCollection(this.conceptSchemeRef, that.getConceptSchemeRef())) {
                return false;
            }
            if (!ObjectUtil.equivalentCollection(this.categorySchemeRef, that.getCategorySchemeRef())) {
                return false;
            }
            if (!ObjectUtil.equivalentCollection(this.orgSchemeRef, that.getOrgSchemeRef())) {
                return false;
            }
            return ObjectUtil.equivalentCollection(this.hierCodelistRef, that.getHierCodelistRef());
        }
        return false;
    }

    @Override
    public List<CrossReferenceBean> getDataStructureRef() {
        return new ArrayList<CrossReferenceBean>(this.keyFamilyRef);
    }

    @Override
    public List<CrossReferenceBean> getMetadataStructureRef() {
        return new ArrayList<CrossReferenceBean>(this.metadataStructureRef);
    }

    @Override
    public List<CrossReferenceBean> getConceptSchemeRef() {
        return new ArrayList<CrossReferenceBean>(this.conceptSchemeRef);
    }

    @Override
    public List<CrossReferenceBean> getCategorySchemeRef() {
        return new ArrayList<CrossReferenceBean>(this.categorySchemeRef);
    }

    @Override
    public List<CrossReferenceBean> getOrgSchemeRef() {
        return new ArrayList<CrossReferenceBean>(this.orgSchemeRef);
    }

    @Override
    public List<CrossReferenceBean> getHierCodelistRef() {
        return new ArrayList<CrossReferenceBean>(this.hierCodelistRef);
    }
}

