/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.metadatastructure;

import javax.xml.bind.ValidationException;
import org.sdmx.resources.sdmxml.schemas.v21.common.ObjectTypeCodelistType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.IdentifiableObjectTargetType;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.constants.TEXT_TYPE;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.model.beans.base.IdentifiableBean;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.metadatastructure.IdentifiableTargetBean;
import org.sdmxsource.sdmx.api.model.beans.metadatastructure.MetadataTargetBean;
import org.sdmxsource.sdmx.api.model.mutable.metadatastructure.IdentifiableTargetMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.ComponentBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.RepresentationBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.base.RepresentationMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.base.TextFormatMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.util.XmlBeansEnumUtil;

public class IdentifiableTargetBeanImpl
extends ComponentBeanImpl
implements IdentifiableTargetBean {
    private static final long serialVersionUID = 1936328008391577535L;
    private SDMX_STRUCTURE_TYPE referencedStructureType;

    public IdentifiableTargetBeanImpl(IdentifiableTargetMutableBean bean, MetadataTargetBean parent) {
        super(bean, parent);
        this.referencedStructureType = bean.getReferencedStructureType();
        try {
            this.validate();
        }
        catch (ValidationException e) {
            throw new SdmxSemmanticException((Throwable)e, ExceptionCode.FAIL_VALIDATION, this);
        }
    }

    protected IdentifiableTargetBeanImpl(IdentifiableObjectTargetType identifiableTargetType, MetadataTargetBean parent) {
        super(identifiableTargetType, SDMX_STRUCTURE_TYPE.IDENTIFIABLE_OBJECT_TARGET, parent);
        this.referencedStructureType = XmlBeansEnumUtil.getSdmxStructureType(identifiableTargetType.getObjectType());
        try {
            this.validate();
        }
        catch (ValidationException e) {
            throw new SdmxSemmanticException((Throwable)e, ExceptionCode.FAIL_VALIDATION, this);
        }
    }

    @Override
    public boolean deepEquals(SDMXBean bean, boolean includeFinalProperties) {
        if (bean == null) {
            return false;
        }
        if (bean.getStructureType() == this.getStructureType()) {
            IdentifiableTargetBean that = (IdentifiableTargetBean)bean;
            if (this.referencedStructureType != that.getReferencedStructureType()) {
                return false;
            }
            return super.deepEqualsInternal(that, includeFinalProperties);
        }
        return false;
    }

    private void validate() throws ValidationException {
        ObjectTypeCodelistType.Enum objIdEnum = XmlBeansEnumUtil.build(this.referencedStructureType);
        this.referencedStructureType = XmlBeansEnumUtil.getSdmxStructureType(objIdEnum);
        if (this.localRepresentation == null) {
            TextFormatMutableBeanImpl textFormatMutable = new TextFormatMutableBeanImpl();
            textFormatMutable.setTextType(TEXT_TYPE.IDENTIFIABLE_REFERENCE);
            RepresentationMutableBeanImpl representationMutable = new RepresentationMutableBeanImpl();
            representationMutable.setTextFormat(textFormatMutable);
            this.localRepresentation = new RepresentationBeanImpl(representationMutable, (IdentifiableBean)this);
            return;
        }
        if (this.localRepresentation.getRepresentation() == null) {
            if (this.localRepresentation.getTextFormat() == null || this.localRepresentation.getTextFormat().getTextType() != TEXT_TYPE.IDENTIFIABLE_REFERENCE) {
                TextFormatMutableBeanImpl textFormatMutable = new TextFormatMutableBeanImpl();
                textFormatMutable.setTextType(TEXT_TYPE.IDENTIFIABLE_REFERENCE);
                RepresentationMutableBeanImpl representationMutable = new RepresentationMutableBeanImpl();
                representationMutable.setTextFormat(textFormatMutable);
                this.localRepresentation = new RepresentationBeanImpl(representationMutable, (IdentifiableBean)this);
            }
        } else if (this.localRepresentation.getTextFormat() != null) {
            throw new SdmxSemmanticException("Can not have both TextFormat and Representation set on IdentifiableObjectTarget");
        }
        if (this.referencedStructureType == null) {
            throw new SdmxSemmanticException("Identifiable target is missing Target Structure Type (objectType)");
        }
    }

    @Override
    protected void validateComponetReference() {
    }

    @Override
    public SDMX_STRUCTURE_TYPE getReferencedStructureType() {
        return this.referencedStructureType;
    }
}

