/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.metadatastructure;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.ValidationException;
import org.sdmx.resources.sdmxml.schemas.v20.structure.MetadataAttributeType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.UsageStatusType;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.constants.TERTIARY_BOOL;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.model.beans.base.IdentifiableBean;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.metadatastructure.MetadataAttributeBean;
import org.sdmxsource.sdmx.api.model.mutable.metadatastructure.MetadataAttributeMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.ComponentBeanImpl;
import org.sdmxsource.util.ObjectUtil;

public class MetadataAttributeBeanImpl
extends ComponentBeanImpl
implements MetadataAttributeBean {
    private static final long serialVersionUID = 1L;
    private List<MetadataAttributeBean> metadataAttributes = new ArrayList<MetadataAttributeBean>();
    private Integer minOccurs;
    private Integer maxOccurs;
    private TERTIARY_BOOL presentational = TERTIARY_BOOL.UNSET;

    public MetadataAttributeBeanImpl(IdentifiableBean parent, MetadataAttributeMutableBean bean) {
        super(bean, parent);
        try {
            if (bean.getMetadataAttributes() != null) {
                for (MetadataAttributeMutableBean currentMa : bean.getMetadataAttributes()) {
                    this.metadataAttributes.add(new MetadataAttributeBeanImpl((IdentifiableBean)this, currentMa));
                }
            }
            if (bean.getMinOccurs() != null) {
                this.minOccurs = new Integer(bean.getMinOccurs());
            }
            if (bean.getMaxOccurs() != null) {
                this.maxOccurs = new Integer(bean.getMaxOccurs());
            }
            this.presentational = bean.getPresentational();
        }
        catch (Throwable th) {
            throw new SdmxSemmanticException(th, "Error creating structure: " + this);
        }
        try {
            this.validate();
        }
        catch (ValidationException e) {
            throw new SdmxSemmanticException((Throwable)e, ExceptionCode.FAIL_VALIDATION, this);
        }
    }

    public MetadataAttributeBeanImpl(org.sdmx.resources.sdmxml.schemas.v21.structure.MetadataAttributeType metadataAttribute, IdentifiableBean parent) {
        super(metadataAttribute, SDMX_STRUCTURE_TYPE.METADATA_ATTRIBUTE, parent);
        if (metadataAttribute.getMinOccurs() != null) {
            this.minOccurs = metadataAttribute.getMinOccurs().intValue();
        }
        if (metadataAttribute.getMaxOccurs() != null && metadataAttribute.getMaxOccurs() instanceof BigInteger) {
            this.maxOccurs = ((BigInteger)metadataAttribute.getMaxOccurs()).intValue();
        }
        if (metadataAttribute.isSetIsPresentational()) {
            this.presentational = TERTIARY_BOOL.parseBoolean(metadataAttribute.getIsPresentational());
        }
        if (metadataAttribute.getMetadataAttributeList() != null) {
            for (org.sdmx.resources.sdmxml.schemas.v21.structure.MetadataAttributeType currentMaType : metadataAttribute.getMetadataAttributeList()) {
                this.metadataAttributes.add(new MetadataAttributeBeanImpl(currentMaType, (IdentifiableBean)this));
            }
        }
        try {
            this.validate();
        }
        catch (ValidationException e) {
            throw new SdmxSemmanticException((Throwable)e, ExceptionCode.FAIL_VALIDATION, this);
        }
    }

    public MetadataAttributeBeanImpl(IdentifiableBean parent, MetadataAttributeType metadataAttribute) {
        super(metadataAttribute, SDMX_STRUCTURE_TYPE.METADATA_ATTRIBUTE, metadataAttribute.getAnnotations(), metadataAttribute.getTextFormat(), metadataAttribute.getRepresentationSchemeAgency(), metadataAttribute.getRepresentationScheme(), null, metadataAttribute.getConceptSchemeAgency(), metadataAttribute.getConceptSchemeRef(), metadataAttribute.getConceptVersion(), metadataAttribute.getConceptAgency(), metadataAttribute.getConceptRef(), parent);
        if (metadataAttribute.getUsageStatus() != null) {
            if (metadataAttribute.getUsageStatus() == UsageStatusType.MANDATORY) {
                this.minOccurs = 1;
                this.maxOccurs = 1;
            } else {
                this.minOccurs = 0;
            }
        }
        if (metadataAttribute.getMetadataAttributeList() != null) {
            for (MetadataAttributeType currentMa : metadataAttribute.getMetadataAttributeList()) {
                this.metadataAttributes.add(new MetadataAttributeBeanImpl((IdentifiableBean)this, currentMa));
            }
        }
        try {
            this.validate();
        }
        catch (ValidationException e) {
            throw new SdmxSemmanticException((Throwable)e, ExceptionCode.FAIL_VALIDATION, this);
        }
    }

    @Override
    public boolean deepEquals(SDMXBean bean, boolean includeFinalProperties) {
        if (bean == null) {
            return false;
        }
        if (bean.getStructureType() == this.getStructureType()) {
            MetadataAttributeBean that = (MetadataAttributeBean)bean;
            if (!super.equivalent(this.metadataAttributes, that.getMetadataAttributes(), includeFinalProperties)) {
                return false;
            }
            if (!ObjectUtil.equivalent(this.minOccurs, that.getMinOccurs())) {
                return false;
            }
            if (!ObjectUtil.equivalent(this.maxOccurs, that.getMaxOccurs())) {
                return false;
            }
            if (this.presentational != that.getPresentational()) {
                return false;
            }
            return super.deepEqualsInternal(that, includeFinalProperties);
        }
        return false;
    }

    protected void validate() throws ValidationException {
        if (this.metadataAttributes != null) {
            HashSet<String> conceptIds = new HashSet<String>();
            for (MetadataAttributeBean metadataAttribute : this.metadataAttributes) {
                if (metadataAttribute.getConceptRef() == null) {
                    throw new SdmxSemmanticException("Metadata Attribute must reference a concept");
                }
                String ids = metadataAttribute.getId();
                if (conceptIds.contains(ids)) {
                    throw new SdmxSemmanticException(ExceptionCode.DUPLICATE_CONCEPT, metadataAttribute.toString());
                }
                conceptIds.add(ids);
            }
        }
        if (this.minOccurs != null && this.maxOccurs != null && this.minOccurs.compareTo(this.maxOccurs) > 0) {
            throw new SdmxSemmanticException("Max Occurs '" + this.maxOccurs + "' can not be a lower value then Min Occurs '" + this.minOccurs + "'.  Please note the abscence of Max Occurs defaults to value of 1 - specify the value as 'unbounded' is this is not the case.");
        }
    }

    @Override
    public List<MetadataAttributeBean> getMetadataAttributes() {
        return new ArrayList<MetadataAttributeBean>(this.metadataAttributes);
    }

    @Override
    public Integer getMinOccurs() {
        if (this.minOccurs == null) {
            return null;
        }
        return new Integer(this.minOccurs);
    }

    @Override
    public Integer getMaxOccurs() {
        if (this.maxOccurs == null) {
            return null;
        }
        return new Integer(this.maxOccurs);
    }

    @Override
    public TERTIARY_BOOL getPresentational() {
        return this.presentational;
    }

    @Override
    protected Set<SDMXBean> getCompositesInternal() {
        Set<SDMXBean> composites = super.getCompositesInternal();
        super.addToCompositeSet(this.metadataAttributes, composites);
        return composites;
    }
}

