/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.process;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.sdmx.resources.sdmxml.schemas.v21.structure.TransitionType;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.base.SdmxStructureBean;
import org.sdmxsource.sdmx.api.model.beans.base.TextTypeWrapper;
import org.sdmxsource.sdmx.api.model.beans.process.ProcessBean;
import org.sdmxsource.sdmx.api.model.beans.process.ProcessStepBean;
import org.sdmxsource.sdmx.api.model.beans.process.TransitionBean;
import org.sdmxsource.sdmx.api.model.mutable.base.TextTypeWrapperMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.base.TransitionMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.IdentifiableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.TextTypeWrapperImpl;
import org.sdmxsource.sdmx.sdmxbeans.util.RefUtil;
import org.sdmxsource.sdmx.sdmxbeans.util.TextTypeUtil;
import org.sdmxsource.util.ObjectUtil;

public class TransitionBeanImpl
extends IdentifiableBeanImpl
implements TransitionBean {
    private static final long serialVersionUID = 1L;
    private String targetStep;
    private List<TextTypeWrapper> condition = new ArrayList<TextTypeWrapper>();
    private String localId;
    private transient ProcessStepBean processStep;

    public TransitionBeanImpl(TransitionMutableBean bean, SdmxStructureBean parent) {
        super(bean, parent);
        this.targetStep = bean.getTargetStep();
        if (bean.getConditions() != null) {
            for (TextTypeWrapperMutableBean ttMut : bean.getConditions()) {
                if (!ObjectUtil.validString(ttMut.getValue())) continue;
                this.condition.add(new TextTypeWrapperImpl(ttMut, (SDMXBean)this));
            }
        }
        this.localId = bean.getLocalId();
        this.validate();
    }

    public TransitionBeanImpl(TransitionType transition, SdmxStructureBean parent) {
        super(transition, SDMX_STRUCTURE_TYPE.TRANSITION, parent);
        if (transition.getTargetStep() != null) {
            this.targetStep = RefUtil.createLocalIdReference(transition.getTargetStep());
        }
        if (transition.getConditionList() != null) {
            this.condition = TextTypeUtil.wrapTextTypeV21(transition.getConditionList(), this);
        }
        this.localId = transition.getLocalID();
        this.validate();
    }

    public TransitionBeanImpl(org.sdmx.resources.sdmxml.schemas.v20.structure.TransitionType trans, SdmxStructureBean parent) {
        super(TransitionBeanImpl.generateId(), SDMX_STRUCTURE_TYPE.TRANSITION, parent);
        this.targetStep = trans.getTargetStep();
        if (trans.getCondition() != null) {
            this.condition.add(new TextTypeWrapperImpl(trans.getCondition(), (SDMXBean)this));
        }
    }

    private static String generateId() {
        return UUID.randomUUID().toString();
    }

    @Override
    public boolean deepEquals(SDMXBean bean, boolean includeFinalProperties) {
        if (bean == null) {
            return false;
        }
        if (bean.getStructureType() == this.getStructureType()) {
            TransitionBean that = (TransitionBean)bean;
            if (!super.equivalent(this.condition, that.getCondition(), includeFinalProperties)) {
                return false;
            }
            if (!ObjectUtil.equivalent(this.targetStep, that.getTargetStep())) {
                return false;
            }
            if (!ObjectUtil.equivalent(this.localId, that.getLocalId())) {
                return false;
            }
            return super.deepEqualsInternal(that, includeFinalProperties);
        }
        return false;
    }

    private void validate() throws SdmxSemmanticException {
        if (!ObjectUtil.validString(this.targetStep)) {
            throw new SdmxSemmanticException("Transition is missing mandatory 'Target Step'");
        }
    }

    protected void verifyProcessSteps() {
        ProcessBean parentProcess = (ProcessBean)this.getMaintainableParent();
        this.setTargetStep(parentProcess.getProcessSteps(), this.targetStep.split("\\."), 0);
    }

    private void setTargetStep(List<ProcessStepBean> processSteps, String[] targetStepSplit, int currentPosition) {
        for (ProcessStepBean currentProcessStep : processSteps) {
            if (!currentProcessStep.getId().equals(targetStepSplit[currentPosition])) continue;
            int nextPos = currentPosition + 1;
            if (targetStepSplit.length > nextPos) {
                this.setTargetStep(currentProcessStep.getProcessSteps(), targetStepSplit, nextPos);
                return;
            }
            this.processStep = currentProcessStep;
            return;
        }
        throw new SdmxSemmanticException("Can not resolve reference to ProcessStep with reference '" + this.targetStep + "'");
    }

    @Override
    public ProcessStepBean getTargetStep() {
        if (this.targetStep != null && this.processStep == null) {
            this.verifyProcessSteps();
        }
        return this.processStep;
    }

    @Override
    public List<TextTypeWrapper> getCondition() {
        return new ArrayList<TextTypeWrapper>(this.condition);
    }

    @Override
    public List<TextTypeWrapper> getAllTextTypes() {
        List<TextTypeWrapper> returnList = super.getAllTextTypes();
        returnList.addAll(this.condition);
        return returnList;
    }

    @Override
    public String getLocalId() {
        return this.localId;
    }

    @Override
    protected Set<SDMXBean> getCompositesInternal() {
        Set<SDMXBean> composites = super.getCompositesInternal();
        super.addToCompositeSet(this.condition, composites);
        return composites;
    }
}

