/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.reference;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sdmxsource.sdmx.api.constants.DATA_QUERY_DETAIL;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.model.base.SdmxDate;
import org.sdmxsource.sdmx.api.model.beans.reference.MaintainableRefBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.api.model.query.RESTDataQuery;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.SdmxDateImpl;
import org.sdmxsource.sdmx.util.beans.reference.StructureReferenceBeanImpl;
import org.sdmxsource.util.ObjectUtil;

public class RESTDataQueryImpl
implements RESTDataQuery {
    public static String ALL = "ALL";
    private StructureReferenceBean flowRef;
    private StructureReferenceBean providerRef;
    private SdmxDate startPeriod;
    private SdmxDate endPeriod;
    private SdmxDate updatedAfter;
    private Integer firstNObs;
    private Integer lastNObs;
    private DATA_QUERY_DETAIL queryDetail;
    private String dimensionAtObservation;
    private List<Set<String>> queryList = new ArrayList<Set<String>>();

    @Override
    public String getRestQuery() {
        return this.toString();
    }

    public RESTDataQueryImpl(String restString) {
        this(restString, null);
    }

    public RESTDataQueryImpl(String restString, Map<String, String> queryParameters) {
        int dataIndex = restString.indexOf("data/");
        if (dataIndex < 0) {
            throw new IllegalArgumentException("Data query expected to start with 'data/'");
        }
        String queryString = restString.substring(dataIndex);
        if (queryParameters == null) {
            queryParameters = new HashMap<String, String>();
        }
        if (queryString.indexOf("?") > 0) {
            String params = queryString.substring(queryString.indexOf("?") + 1);
            queryString = queryString.substring(0, queryString.indexOf("?"));
            for (String currentParam : params.split("&")) {
                String[] param = currentParam.split("=");
                queryParameters.put(param[0], param[1]);
            }
        }
        this.parserQueryString(queryString.split("/"));
        this.parserQueryParameters(queryParameters);
    }

    public RESTDataQueryImpl(String[] queryString, Map<String, String> queryParameters) {
        this.parserQueryString(queryString);
        this.parserQueryParameters(queryParameters);
    }

    private void parserQueryString(String[] queryString) {
        if (queryString.length < 2) {
            throw new SdmxSemmanticException("Data query expected to contain Flow as the second argument");
        }
        this.setFlowRef(queryString[1]);
        if (queryString.length < 3) {
            throw new SdmxSemmanticException("Data query expected to contain a Key as the third argument");
        }
        this.setKey(queryString[2]);
        if (queryString.length > 3) {
            this.setProvider(queryString[3]);
        }
        if (queryString.length > 4) {
            throw new SdmxSemmanticException("Data query expected unexpected 4th argument");
        }
    }

    @Override
    public StructureReferenceBean getFlowRef() {
        return this.flowRef;
    }

    @Override
    public StructureReferenceBean getProviderRef() {
        return this.providerRef;
    }

    @Override
    public SdmxDate getStartPeriod() {
        return this.startPeriod;
    }

    @Override
    public SdmxDate getEndPeriod() {
        return this.endPeriod;
    }

    @Override
    public SdmxDate getUpdatedAfter() {
        return this.updatedAfter;
    }

    @Override
    public Integer getlastNObsertations() {
        return this.lastNObs;
    }

    @Override
    public Integer getFirstNObservations() {
        return this.firstNObs;
    }

    @Override
    public DATA_QUERY_DETAIL getQueryDetail() {
        return this.queryDetail;
    }

    @Override
    public String getDimensionAtObservation() {
        return this.dimensionAtObservation;
    }

    @Override
    public List<Set<String>> getQueryList() {
        return this.queryList;
    }

    private void setFlowRef(String flowRef) {
        if (!flowRef.equals(ALL)) {
            this.flowRef = this.parseFlowRef(flowRef);
        }
    }

    private void setProvider(String provider) {
        if (!provider.equals(ALL)) {
            this.providerRef = this.parseProviderRef(provider);
        }
    }

    private StructureReferenceBean parseProviderRef(String str) {
        String[] split = str.split(",");
        if (split.length > 2) {
            throw new SdmxSemmanticException("Unexpected number of data provider reference arguments (, seperated) for reference: " + str + " - expecting a maximum of two arguments (Agency Id, Id)");
        }
        if (split.length == 2) {
            return new StructureReferenceBeanImpl(split[0], "DATA_PROVIDERS", "1.0", SDMX_STRUCTURE_TYPE.DATA_PROVIDER, split[1]);
        }
        return new StructureReferenceBeanImpl(null, "DATA_PROVIDERS", "1.0", SDMX_STRUCTURE_TYPE.DATA_PROVIDER, split[0]);
    }

    private StructureReferenceBean parseFlowRef(String str) {
        String[] split = str.split(",");
        if (split.length > 3) {
            throw new SdmxSemmanticException("Unexpected number of reference arguments (, seperated) for reference: " + str + " - expecting a maximum of three arguments (Agency Id, Id, and Version)");
        }
        if (split.length == 3) {
            return new StructureReferenceBeanImpl(split[0], split[1], split[2], SDMX_STRUCTURE_TYPE.DATAFLOW, new String[0]);
        }
        if (split.length == 2) {
            return new StructureReferenceBeanImpl(split[0], split[1], null, SDMX_STRUCTURE_TYPE.DATAFLOW, new String[0]);
        }
        return new StructureReferenceBeanImpl(null, split[0], null, SDMX_STRUCTURE_TYPE.DATAFLOW, new String[0]);
    }

    private void setKey(String key) {
        if (!key.equals(ALL)) {
            String[] split;
            for (String currentKey : split = key.split("\\.", Integer.MAX_VALUE)) {
                HashSet<String> selectionsList = new HashSet<String>();
                this.queryList.add(selectionsList);
                for (String currentSelection : currentKey.split("\\+")) {
                    if (!ObjectUtil.validString(currentSelection)) continue;
                    selectionsList.add(currentSelection);
                }
            }
        }
    }

    private void setDetail(String detail) {
        this.queryDetail = DATA_QUERY_DETAIL.parseString(detail);
    }

    private void setStartPeriod(String startPeriod) {
        try {
            this.startPeriod = new SdmxDateImpl(startPeriod);
        }
        catch (NumberFormatException e) {
            throw new SdmxSemmanticException("Could not format 'startPeriod' value " + startPeriod + " as a date");
        }
    }

    private void setEndPeriod(String endPeriod) {
        try {
            this.endPeriod = new SdmxDateImpl(endPeriod);
        }
        catch (NumberFormatException e) {
            throw new SdmxSemmanticException("Could not format 'endPeriod' value " + endPeriod + " as a date");
        }
    }

    private void setUpdatedAfterDate(String updatedAfter) {
        try {
            this.updatedAfter = new SdmxDateImpl(updatedAfter);
        }
        catch (NumberFormatException e) {
            throw new SdmxSemmanticException("Could not format 'updatedAfter' value " + updatedAfter + " as a date");
        }
    }

    private void setLastXObs(String maxObs) {
        try {
            this.lastNObs = Integer.parseInt(maxObs);
        }
        catch (NumberFormatException e) {
            throw new SdmxSemmanticException("Query parameter 'lastNObservations' expects an Integer, was given: " + maxObs);
        }
    }

    private void setFirstXObs(String maxObs) {
        try {
            this.firstNObs = Integer.parseInt(maxObs);
        }
        catch (NumberFormatException e) {
            throw new SdmxSemmanticException("Query parameter 'firstNObservations' expects an Integer, was given: " + maxObs);
        }
    }

    private void setDimensionAtObservation(String dimatObs) {
        this.dimensionAtObservation = dimatObs;
    }

    private void parserQueryParameters(Map<String, String> params) {
        if (params != null) {
            for (String key : params.keySet()) {
                if (key.equalsIgnoreCase("startPeriod")) {
                    this.setStartPeriod(params.get(key));
                    continue;
                }
                if (key.equalsIgnoreCase("endPeriod")) {
                    this.setEndPeriod(params.get(key));
                    continue;
                }
                if (key.equalsIgnoreCase("updatedAfter")) {
                    this.setUpdatedAfterDate(params.get(key));
                    continue;
                }
                if (key.equalsIgnoreCase("firstNObservations")) {
                    this.setFirstXObs(params.get(key));
                    continue;
                }
                if (key.equalsIgnoreCase("lastNObservations")) {
                    this.setLastXObs(params.get(key));
                    continue;
                }
                if (key.equalsIgnoreCase("dimensionAtObservation")) {
                    this.setDimensionAtObservation(params.get(key));
                    continue;
                }
                if (key.equalsIgnoreCase("detail")) {
                    this.setDetail(params.get(key));
                    continue;
                }
                throw new SdmxSemmanticException("Unknown query parameter  '" + key + "' allowed parameters [startPeriod, endPeriod, updatedAfter, firstNObservations, lastNObservations, dimensionAtObservation, detail]");
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("data/");
        if (this.flowRef == null) {
            sb.append("ALL");
        } else {
            MaintainableRefBean flowRefMaint = this.flowRef.getMaintainableReference();
            String flowAgency = flowRefMaint.getAgencyId() == null ? "ALL" : flowRefMaint.getAgencyId();
            String flowId = flowRefMaint.getMaintainableId() == null ? "ALL" : flowRefMaint.getMaintainableId();
            String flowVersion = flowRefMaint.getVersion() == null ? "ALL" : flowRefMaint.getVersion();
            sb.append(flowAgency + "," + flowId + "," + flowVersion);
        }
        sb.append("/");
        String concat = "";
        if (!ObjectUtil.validCollection(this.queryList)) {
            sb.append("ALL");
        } else {
            for (Set<String> currentQuery : this.queryList) {
                sb.append(concat);
                concat = "";
                for (String code : currentQuery) {
                    sb.append(concat);
                    sb.append(code);
                    concat = "+";
                }
                concat = ".";
            }
        }
        sb.append("/");
        if (this.providerRef == null) {
            sb.append("ALL");
        } else {
            MaintainableRefBean provRefMaint = this.providerRef.getMaintainableReference();
            String provAgency = provRefMaint.getAgencyId() == null ? "ALL" : provRefMaint.getAgencyId();
            String provId = this.providerRef.getChildReference() == null ? "ALL" : this.providerRef.getChildReference().getId();
            sb.append(provAgency + "," + provId);
        }
        concat = "?";
        if (this.startPeriod != null) {
            sb.append(concat + "startPeriod=" + this.startPeriod.getDateInSdmxFormat());
            concat = "&";
        }
        if (this.endPeriod != null) {
            sb.append(concat + "endPeriod=" + this.endPeriod.getDateInSdmxFormat());
            concat = "&";
        }
        if (this.updatedAfter != null) {
            sb.append(concat + "updatedAfter=" + this.updatedAfter.getDateInSdmxFormat());
            concat = "&";
        }
        if (this.firstNObs != null) {
            sb.append(concat + "firstNObservations=" + this.firstNObs);
            concat = "&";
        }
        if (this.lastNObs != null) {
            sb.append(concat + "lastNObservations=" + this.lastNObs);
            concat = "&";
        }
        if (this.queryDetail != null) {
            sb.append(concat + "detail=" + this.queryDetail.getRestParam());
            concat = "&";
        }
        if (ObjectUtil.validString(this.dimensionAtObservation)) {
            sb.append(concat + "dimensionAtObservation=" + this.dimensionAtObservation);
            concat = "&";
        }
        return sb.toString();
    }
}

