/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.reference;

import java.util.Map;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.constants.STRUCTURE_QUERY_DETAIL;
import org.sdmxsource.sdmx.api.constants.STRUCTURE_REFERENCE_DETAIL;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.model.query.StructureQueryMetadata;

public class StructureQueryMetadataImpl
implements StructureQueryMetadata {
    private static final long serialVersionUID = 4511749640571382502L;
    private STRUCTURE_QUERY_DETAIL structureQueryDetail = STRUCTURE_QUERY_DETAIL.FULL;
    private STRUCTURE_REFERENCE_DETAIL structureReferenceDetail = STRUCTURE_REFERENCE_DETAIL.NONE;
    private SDMX_STRUCTURE_TYPE specificStructureReference;
    private boolean returnLatest;

    public StructureQueryMetadataImpl(STRUCTURE_QUERY_DETAIL structureQueryDetail, STRUCTURE_REFERENCE_DETAIL structureReferenceDetail, SDMX_STRUCTURE_TYPE specificStructureReference, boolean returnLatest) {
        if (structureQueryDetail != null) {
            this.structureQueryDetail = structureQueryDetail;
        }
        if (structureReferenceDetail != null) {
            this.structureReferenceDetail = structureReferenceDetail;
        }
        if (specificStructureReference != null) {
            this.specificStructureReference = specificStructureReference;
        }
        this.returnLatest = returnLatest;
    }

    public StructureQueryMetadataImpl(String[] queryString, Map<String, String> queryParameters) {
        this.parserQueryString(queryString);
        this.parserQueryParameters(queryParameters);
    }

    private void parserQueryString(String[] queryString) {
        if (queryString.length >= 4) {
            if (queryString[3].equalsIgnoreCase("LATEST")) {
                this.returnLatest = true;
            }
        } else {
            this.returnLatest = true;
        }
    }

    private void parserQueryParameters(Map<String, String> params) {
        if (params != null) {
            for (String key : params.keySet()) {
                String value = params.get(key);
                if (key.equalsIgnoreCase("detail")) {
                    try {
                        this.structureQueryDetail = STRUCTURE_QUERY_DETAIL.parseString(value);
                        continue;
                    }
                    catch (SdmxSemmanticException e) {
                        throw new SdmxSemmanticException(e, "unable to parse value for key " + key);
                    }
                }
                if (key.equalsIgnoreCase("references")) {
                    try {
                        this.structureReferenceDetail = STRUCTURE_REFERENCE_DETAIL.parseString(value);
                        if (this.structureReferenceDetail != STRUCTURE_REFERENCE_DETAIL.SPECIFIC) continue;
                        this.specificStructureReference = SDMX_STRUCTURE_TYPE.parseClass(value);
                        continue;
                    }
                    catch (SdmxSemmanticException e) {
                        throw new SdmxSemmanticException(e, "unable to parse value for key " + key);
                    }
                }
                throw new SdmxSemmanticException("Unknown query parameter : " + key);
            }
        }
    }

    @Override
    public STRUCTURE_QUERY_DETAIL getStructureQueryDetail() {
        return this.structureQueryDetail;
    }

    @Override
    public STRUCTURE_REFERENCE_DETAIL getStructureReferenceDetail() {
        return this.structureReferenceDetail;
    }

    @Override
    public SDMX_STRUCTURE_TYPE getSpecificStructureReference() {
        return this.specificStructureReference;
    }

    @Override
    public boolean isReturnLatest() {
        return this.returnLatest;
    }
}

