/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.registry;

import org.sdmx.resources.sdmxml.schemas.v21.common.SetReferenceType;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.base.SdmxStructureBean;
import org.sdmxsource.sdmx.api.model.beans.reference.CrossReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.registry.DataSetReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.registry.MetadataTargetKeyValuesBean;
import org.sdmxsource.sdmx.api.model.mutable.base.MutableBean;
import org.sdmxsource.sdmx.api.model.mutable.registry.DataSetReferenceMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.SdmxStructureBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.util.RefUtil;
import org.sdmxsource.sdmx.util.beans.reference.CrossReferenceBeanImpl;
import org.sdmxsource.util.ObjectUtil;

public class DataSetReferenceBeanImpl
extends SdmxStructureBeanImpl
implements DataSetReferenceBean {
    private static final long serialVersionUID = -2093848883988082080L;
    private String datasetId;
    private CrossReferenceBean dataProviderReference;

    public DataSetReferenceBeanImpl(DataSetReferenceMutableBean mutableBean, MetadataTargetKeyValuesBean parent) {
        super((MutableBean)mutableBean, (SdmxStructureBean)parent);
        this.datasetId = mutableBean.getDatasetId();
        if (mutableBean.getDataProviderReference() != null) {
            this.dataProviderReference = new CrossReferenceBeanImpl((SDMXBean)this, mutableBean.getDataProviderReference());
            try {
                this.validate();
            }
            catch (SdmxSemmanticException e) {
                throw new SdmxSemmanticException((Throwable)e, ExceptionCode.FAIL_VALIDATION, this);
            }
        }
    }

    public DataSetReferenceBeanImpl(SetReferenceType sRefType, MetadataTargetKeyValuesBean parent) {
        super(SDMX_STRUCTURE_TYPE.DATASET_REFERENCE, (SdmxStructureBean)parent);
        this.datasetId = sRefType.getID();
        this.dataProviderReference = RefUtil.createReference(this, sRefType.getDataProvider());
        try {
            this.validate();
        }
        catch (SdmxSemmanticException e) {
            throw new SdmxSemmanticException((Throwable)e, ExceptionCode.FAIL_VALIDATION, this);
        }
    }

    private void validate() {
        if (!ObjectUtil.validString(this.datasetId)) {
            throw new SdmxSemmanticException("Dataset Reference missing mandatory 'id' identifier");
        }
        if (this.dataProviderReference == null) {
            throw new SdmxSemmanticException("Dataset Reference missing mandatory 'data provider reference'");
        }
    }

    @Override
    public boolean deepEquals(SDMXBean bean, boolean includeFinalProperties) {
        if (bean == null) {
            return false;
        }
        if (bean instanceof DataSetReferenceBean) {
            DataSetReferenceBean that = (DataSetReferenceBean)bean;
            if (!ObjectUtil.equivalent(this.getDataProviderReference(), that.getDataProviderReference())) {
                return false;
            }
            if (!ObjectUtil.equivalent(this.getDatasetId(), that.getDatasetId())) {
                return false;
            }
        }
        return false;
    }

    @Override
    public String getDatasetId() {
        return this.datasetId;
    }

    @Override
    public CrossReferenceBean getDataProviderReference() {
        return this.dataProviderReference;
    }
}

