/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.registry;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.sdmx.resources.sdmxml.schemas.v21.common.ComponentValueSetType;
import org.sdmx.resources.sdmxml.schemas.v21.common.ObjectReferenceType;
import org.sdmx.resources.sdmxml.schemas.v21.common.SetReferenceType;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.base.SdmxStructureBean;
import org.sdmxsource.sdmx.api.model.beans.reference.CrossReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.registry.DataSetReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.registry.MetadataTargetKeyValuesBean;
import org.sdmxsource.sdmx.api.model.beans.registry.MetadataTargetRegionBean;
import org.sdmxsource.sdmx.api.model.mutable.registry.DataSetReferenceMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.registry.MetadataTargetKeyValuesMutable;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.registry.DataSetReferenceBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.registry.KeyValuesImpl;
import org.sdmxsource.sdmx.sdmxbeans.util.RefUtil;
import org.sdmxsource.sdmx.util.beans.reference.CrossReferenceBeanImpl;
import org.sdmxsource.util.ObjectUtil;

public class MetadataTargetKeyValuesBeanImpl
extends KeyValuesImpl
implements MetadataTargetKeyValuesBean {
    private static final long serialVersionUID = 423683652240779717L;
    private List<CrossReferenceBean> objectReferences = new ArrayList<CrossReferenceBean>();
    private List<DataSetReferenceBean> datasetReferences = new ArrayList<DataSetReferenceBean>();

    public MetadataTargetKeyValuesBeanImpl(MetadataTargetKeyValuesMutable mutable, MetadataTargetRegionBean parent) {
        super(mutable, (SdmxStructureBean)parent);
        if (mutable.getObjectReferences() != null) {
            for (StructureReferenceBean sRef : mutable.getObjectReferences()) {
                this.objectReferences.add(new CrossReferenceBeanImpl((SDMXBean)this, sRef));
            }
        }
        if (mutable.getDatasetReferences() != null) {
            for (DataSetReferenceMutableBean currentRef : mutable.getDatasetReferences()) {
                this.datasetReferences.add(new DataSetReferenceBeanImpl(currentRef, (MetadataTargetKeyValuesBean)this));
            }
        }
    }

    public MetadataTargetKeyValuesBeanImpl(ComponentValueSetType keyValueType, MetadataTargetRegionBean parent) {
        super(keyValueType, (SdmxStructureBean)parent);
        if (keyValueType.getDataSetList() != null) {
            for (SetReferenceType currentDatasetRef : keyValueType.getDataSetList()) {
                this.datasetReferences.add(new DataSetReferenceBeanImpl(currentDatasetRef, (MetadataTargetKeyValuesBean)this));
            }
        }
        if (keyValueType.getObjectList() != null) {
            for (ObjectReferenceType currentRef : keyValueType.getObjectList()) {
                this.objectReferences.add(RefUtil.createReference(this, currentRef));
            }
        }
    }

    @Override
    protected Set<SDMXBean> getCompositesInternal() {
        Set<SDMXBean> composites = super.getCompositesInternal();
        super.addToCompositeSet(this.datasetReferences, composites);
        return composites;
    }

    @Override
    public boolean deepEquals(SDMXBean bean, boolean includeFinalProperties) {
        if (bean == null) {
            return false;
        }
        if (bean instanceof MetadataTargetKeyValuesBean) {
            MetadataTargetKeyValuesBean that = (MetadataTargetKeyValuesBean)bean;
            if (!ObjectUtil.equivalentCollection(this.objectReferences, that.getObjectReferences())) {
                return false;
            }
            return super.equivalent(this.datasetReferences, that.getDatasetReferences(), includeFinalProperties);
        }
        return false;
    }

    @Override
    public List<CrossReferenceBean> getObjectReferences() {
        return new ArrayList<CrossReferenceBean>(this.objectReferences);
    }

    @Override
    public List<DataSetReferenceBean> getDatasetReferences() {
        return new ArrayList<DataSetReferenceBean>(this.datasetReferences);
    }
}

