/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.registry;

import java.util.Date;
import org.sdmx.resources.sdmxml.schemas.v20.registry.NotifyRegistryEventType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.AgencySchemeType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.AttachmentConstraintType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.CategorisationType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.CategorySchemeType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.CodelistType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.ConceptSchemeType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.ContentConstraintType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.DataConsumerSchemeType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.DataProviderSchemeType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.DataStructureType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.DataflowType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.HierarchicalCodelistType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.MetadataStructureType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.MetadataflowType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.OrganisationUnitSchemeType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.ProcessType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.ProvisionAgreementType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.ReportingTaxonomyType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.StructureSetType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.StructuresType;
import org.sdmxsource.sdmx.api.constants.DATASET_ACTION;
import org.sdmxsource.sdmx.api.model.beans.SdmxBeans;
import org.sdmxsource.sdmx.api.model.beans.registry.NotificationEvent;
import org.sdmxsource.sdmx.api.model.beans.registry.RegistrationBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.AgencySchemeBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.DataConsumerSchemeBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.DataProviderSchemeBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.OrganisationUnitSchemeBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.categoryscheme.CategorisationBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.categoryscheme.CategorySchemeBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.categoryscheme.ReportingTaxonomyBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.codelist.CodelistBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.codelist.HierarchicalCodelistBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.conceptscheme.ConceptSchemeBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.datastructure.DataStructureBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.datastructure.DataflowBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.mapping.StructureSetBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.metadatastructure.MetadataStructureDefinitionBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.metadatastructure.MetadataflowBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.process.ProcessBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.registry.AttachmentConstraintBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.registry.ContentConstraintBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.registry.ProvisionAgreementBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.registry.RegistrationBeanImpl;
import org.sdmxsource.sdmx.util.beans.container.SdmxBeansImpl;
import org.sdmxsource.sdmx.util.date.DateUtil;

public class NotificationEventImpl
implements NotificationEvent {
    private Date eventTime;
    private String objectUrn;
    private String subscriptionUrn;
    private DATASET_ACTION action;
    private RegistrationBean registration;
    private SdmxBeans beans;

    public NotificationEventImpl(org.sdmx.resources.sdmxml.schemas.v21.registry.NotifyRegistryEventType notification) {
        this.eventTime = DateUtil.formatDate(notification.getEventTime(), true);
        this.objectUrn = notification.getObjectURN();
        this.subscriptionUrn = notification.getSubscriptionURN();
        this.action = DATASET_ACTION.valueOf(notification.getEventAction().toString().toUpperCase());
        if (notification.getRegistrationEvent() != null) {
            this.registration = new RegistrationBeanImpl(notification.getRegistrationEvent().getRegistration());
        } else {
            this.beans = new SdmxBeansImpl();
            StructuresType structures = notification.getStructuralEvent().getStructures();
            if (structures.getCategorisations() != null) {
                for (CategorisationType categorisationType : structures.getCategorisations().getCategorisationList()) {
                    this.beans.addCategorisation(new CategorisationBeanImpl(categorisationType));
                }
            }
            if (structures.getCategorySchemes() != null) {
                for (CategorySchemeType categorySchemeType : structures.getCategorySchemes().getCategorySchemeList()) {
                    this.beans.addCategoryScheme(new CategorySchemeBeanImpl(categorySchemeType));
                }
            }
            if (structures.getCodelists() != null) {
                for (CodelistType codelistType : structures.getCodelists().getCodelistList()) {
                    this.beans.addCodelist(new CodelistBeanImpl(codelistType));
                }
            }
            if (structures.getConcepts() != null) {
                for (ConceptSchemeType conceptSchemeType : structures.getConcepts().getConceptSchemeList()) {
                    this.beans.addConceptScheme(new ConceptSchemeBeanImpl(conceptSchemeType));
                }
            }
            if (structures.getConstraints() != null) {
                for (AttachmentConstraintType attachmentConstraintType : structures.getConstraints().getAttachmentConstraintList()) {
                    this.beans.addAttachmentConstraint(new AttachmentConstraintBeanImpl(attachmentConstraintType));
                }
                for (ContentConstraintType contentConstraintType : structures.getConstraints().getContentConstraintList()) {
                    this.beans.addContentConstraintBean(new ContentConstraintBeanImpl(contentConstraintType));
                }
            }
            if (structures.getDataflows() != null) {
                for (DataflowType dataflowType : structures.getDataflows().getDataflowList()) {
                    this.beans.addDataflow(new DataflowBeanImpl(dataflowType));
                }
            }
            if (structures.getDataStructures() != null) {
                for (DataStructureType dataStructureType : structures.getDataStructures().getDataStructureList()) {
                    this.beans.addDataStructure(new DataStructureBeanImpl(dataStructureType));
                }
            }
            if (structures.getHierarchicalCodelists() != null) {
                for (HierarchicalCodelistType hierarchicalCodelistType : structures.getHierarchicalCodelists().getHierarchicalCodelistList()) {
                    this.beans.addHierarchicalCodelist(new HierarchicalCodelistBeanImpl(hierarchicalCodelistType));
                }
            }
            if (structures.getMetadataflows() != null) {
                for (MetadataflowType metadataflowType : structures.getMetadataflows().getMetadataflowList()) {
                    this.beans.addMetadataFlow(new MetadataflowBeanImpl(metadataflowType));
                }
            }
            if (structures.getMetadataStructures() != null) {
                for (MetadataStructureType metadataStructureType : structures.getMetadataStructures().getMetadataStructureList()) {
                    this.beans.addMetadataStructure(new MetadataStructureDefinitionBeanImpl(metadataStructureType));
                }
            }
            if (structures.getOrganisationSchemes() != null) {
                for (AgencySchemeType agencySchemeType : structures.getOrganisationSchemes().getAgencySchemeList()) {
                    this.beans.addAgencyScheme(new AgencySchemeBeanImpl(agencySchemeType));
                }
                for (DataConsumerSchemeType dataConsumerSchemeType : structures.getOrganisationSchemes().getDataConsumerSchemeList()) {
                    this.beans.addDataConsumerScheme(new DataConsumerSchemeBeanImpl(dataConsumerSchemeType));
                }
                for (DataProviderSchemeType dataProviderSchemeType : structures.getOrganisationSchemes().getDataProviderSchemeList()) {
                    this.beans.addDataProviderScheme(new DataProviderSchemeBeanImpl(dataProviderSchemeType));
                }
                for (OrganisationUnitSchemeType organisationUnitSchemeType : structures.getOrganisationSchemes().getOrganisationUnitSchemeList()) {
                    this.beans.addOrganisationUnitScheme(new OrganisationUnitSchemeBeanImpl(organisationUnitSchemeType));
                }
            }
            if (structures.getProcesses() != null) {
                for (ProcessType processType : structures.getProcesses().getProcessList()) {
                    this.beans.addProcess(new ProcessBeanImpl(processType));
                }
            }
            if (structures.getProvisionAgreements() != null) {
                for (ProvisionAgreementType provisionAgreementType : structures.getProvisionAgreements().getProvisionAgreementList()) {
                    this.beans.addProvisionAgreement(new ProvisionAgreementBeanImpl(provisionAgreementType));
                }
            }
            if (structures.getReportingTaxonomies() != null) {
                for (ReportingTaxonomyType reportingTaxonomyType : structures.getReportingTaxonomies().getReportingTaxonomyList()) {
                    this.beans.addReportingTaxonomy(new ReportingTaxonomyBeanImpl(reportingTaxonomyType));
                }
            }
            if (structures.getStructureSets() != null) {
                for (StructureSetType structureSetType : structures.getStructureSets().getStructureSetList()) {
                    this.beans.addStructureSet(new StructureSetBeanImpl(structureSetType));
                }
            }
        }
    }

    public NotificationEventImpl(NotifyRegistryEventType notification) {
        this.eventTime = DateUtil.formatDate(notification.getEventTime(), true);
        this.objectUrn = notification.getObjectURN();
        this.subscriptionUrn = notification.getSubscriptionURN();
        this.action = DATASET_ACTION.valueOf(notification.getEventAction().toString().toUpperCase());
        if (notification.getRegistrationEvent() != null) {
            this.registration = new RegistrationBeanImpl(notification.getRegistrationEvent().getRegistration());
        }
    }

    @Override
    public Date getEventTime() {
        return this.eventTime;
    }

    @Override
    public String getObjectUrn() {
        return this.objectUrn;
    }

    @Override
    public String getSubscriptionUrn() {
        return this.subscriptionUrn;
    }

    @Override
    public DATASET_ACTION getAction() {
        return this.action;
    }

    @Override
    public SdmxBeans getBeans() {
        return this.beans;
    }

    @Override
    public RegistrationBean getRegistration() {
        return this.registration;
    }
}

