/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.registry;

import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.sdmx.resources.sdmxml.schemas.v20.registry.DatasourceType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.ProvisionAgreementRefType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.RegistrationType;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.constants.TERTIARY_BOOL;
import org.sdmxsource.sdmx.api.constants.TIME_FORMAT;
import org.sdmxsource.sdmx.api.exception.SdmxNotImplementedException;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.model.base.SdmxDate;
import org.sdmxsource.sdmx.api.model.beans.base.DataSourceBean;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.base.SdmxStructureBean;
import org.sdmxsource.sdmx.api.model.beans.reference.CrossReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.registry.RegistrationBean;
import org.sdmxsource.sdmx.api.model.mutable.registry.RegistrationMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.DataSourceBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.MaintainableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.SdmxDateImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.registry.RegistrationMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.util.RefUtil;
import org.sdmxsource.sdmx.util.beans.reference.CrossReferenceBeanImpl;
import org.sdmxsource.util.ObjectUtil;
import org.sdmxsource.util.random.RandomUtil;

public class RegistrationBeanImpl
extends MaintainableBeanImpl
implements RegistrationBean {
    private static Logger LOG = Logger.getLogger(RegistrationBeanImpl.class);
    private static final long serialVersionUID = 1L;
    private SdmxDate lastUpdated = new SdmxDateImpl(new Date(), TIME_FORMAT.DATE_TIME);
    private SdmxDate validFrom;
    private SdmxDate validTo;
    private DataSourceBean dataSource;
    private CrossReferenceBean provisionAgreementRef;
    private TERTIARY_BOOL indexTimeSeries = TERTIARY_BOOL.UNSET;
    private TERTIARY_BOOL indexDataset = TERTIARY_BOOL.UNSET;
    private TERTIARY_BOOL indexAttributes = TERTIARY_BOOL.UNSET;
    private TERTIARY_BOOL indexReportingPeriod = TERTIARY_BOOL.UNSET;

    public RegistrationBeanImpl(RegistrationMutableBean registrationMutable) {
        super(registrationMutable);
        LOG.debug((Object)"Building RegistrationBean from Mutable Bean");
        if (registrationMutable.getLastUpdated() != null) {
            this.lastUpdated = new SdmxDateImpl(registrationMutable.getLastUpdated(), TIME_FORMAT.DATE_TIME);
        }
        if (registrationMutable.getValidFrom() != null) {
            this.validFrom = new SdmxDateImpl(registrationMutable.getValidFrom(), TIME_FORMAT.DATE_TIME);
        }
        if (registrationMutable.getValidTo() != null) {
            this.validTo = new SdmxDateImpl(registrationMutable.getValidTo(), TIME_FORMAT.DATE_TIME);
        }
        if (registrationMutable.getProvisionAgreementRef() != null) {
            this.provisionAgreementRef = new CrossReferenceBeanImpl((SDMXBean)this, registrationMutable.getProvisionAgreementRef());
        }
        if (registrationMutable.getIndexAttributes() != null) {
            this.indexAttributes = registrationMutable.getIndexAttributes();
        }
        if (registrationMutable.getIndexDataset() != null) {
            this.indexDataset = registrationMutable.getIndexDataset();
        }
        if (registrationMutable.getIndexReportingPeriod() != null) {
            this.indexReportingPeriod = registrationMutable.getIndexReportingPeriod();
        }
        if (registrationMutable.getIndexTimeSeries() != null) {
            this.indexTimeSeries = registrationMutable.getIndexTimeSeries();
        }
        if (registrationMutable.getDataSource() != null) {
            this.dataSource = new DataSourceBeanImpl(registrationMutable.getDataSource(), (SdmxStructureBean)this);
        }
        this.validate();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("RegistrationBean Built " + this.getUrn()));
        }
    }

    public RegistrationBeanImpl(org.sdmx.resources.sdmxml.schemas.v21.registry.RegistrationType registrationType) {
        super(null, SDMX_STRUCTURE_TYPE.REGISTRATION, null, null, null, TERTIARY_BOOL.FALSE, "NA", registrationType.getId(), null, null, null, TERTIARY_BOOL.FALSE, null);
        LOG.debug((Object)"Building RegistrationBean from 2.1 SDMX");
        if (registrationType.getValidFrom() != null) {
            this.validFrom = new SdmxDateImpl(registrationType.getValidFrom().getTime(), TIME_FORMAT.DATE_TIME);
        }
        if (registrationType.getLastUpdated() != null) {
            this.lastUpdated = new SdmxDateImpl(registrationType.getLastUpdated().getTime(), TIME_FORMAT.DATE_TIME);
        }
        if (registrationType.getValidTo() != null) {
            this.validTo = new SdmxDateImpl(registrationType.getValidTo().getTime(), TIME_FORMAT.DATE_TIME);
        }
        if (registrationType.getDatasource() != null) {
            if (ObjectUtil.validCollection(registrationType.getDatasource().getQueryableDataSourceList())) {
                this.dataSource = new DataSourceBeanImpl(registrationType.getDatasource().getQueryableDataSourceList().get(0), (SdmxStructureBean)this);
            } else if (ObjectUtil.validCollection(registrationType.getDatasource().getSimpleDataSourceList())) {
                this.dataSource = new DataSourceBeanImpl(registrationType.getDatasource().getSimpleDataSourceList().get(0), (SdmxStructureBean)this);
            }
        }
        if (registrationType.getProvisionAgreement() != null) {
            this.provisionAgreementRef = RefUtil.createReference(this, registrationType.getProvisionAgreement());
        }
        if (registrationType.isSetIndexAttributes()) {
            this.indexAttributes = TERTIARY_BOOL.parseBoolean(registrationType.getIndexAttributes());
        }
        if (registrationType.isSetIndexDataSet()) {
            this.indexDataset = TERTIARY_BOOL.parseBoolean(registrationType.getIndexDataSet());
        }
        if (registrationType.isSetIndexReportingPeriod()) {
            this.indexReportingPeriod = TERTIARY_BOOL.parseBoolean(registrationType.getIndexReportingPeriod());
        }
        if (registrationType.isSetIndexTimeSeries()) {
            this.indexTimeSeries = TERTIARY_BOOL.parseBoolean(registrationType.getIndexTimeSeries());
        }
        this.validate();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("RegistrationBean Built " + this.getUrn()));
        }
    }

    public RegistrationBeanImpl(RegistrationType registrationType) {
        super(null, SDMX_STRUCTURE_TYPE.REGISTRATION, null, null, null, TERTIARY_BOOL.FALSE, "NA", null, null, null, null, TERTIARY_BOOL.FALSE, null);
        LOG.debug((Object)"Building RegistrationBean from 2.0 SDMX");
        if (registrationType.getValidFrom() != null) {
            this.validFrom = new SdmxDateImpl(registrationType.getValidFrom().getTime(), TIME_FORMAT.DATE_TIME);
        }
        if (registrationType.getLastUpdated() != null) {
            this.lastUpdated = new SdmxDateImpl(registrationType.getLastUpdated().getTime(), TIME_FORMAT.DATE_TIME);
        }
        if (registrationType.getValidTo() != null) {
            this.validTo = new SdmxDateImpl(registrationType.getValidTo().getTime(), TIME_FORMAT.DATE_TIME);
        }
        if (registrationType.getDatasource() != null) {
            this.dataSource = new DataSourceBeanImpl(registrationType.getDatasource(), (SdmxStructureBean)this);
        }
        if (registrationType.getProvisionAgreementRef() != null) {
            ProvisionAgreementRefType provRef = registrationType.getProvisionAgreementRef();
            if (ObjectUtil.validString(provRef.getURN())) {
                this.provisionAgreementRef = new CrossReferenceBeanImpl((SDMXBean)this, registrationType.getProvisionAgreementRef().getURN());
            } else if (ObjectUtil.validOneString(provRef.getDataflowID(), provRef.getOrganisationSchemeID())) {
                throw new SdmxNotImplementedException("Registrations submitted in version 2.0 of SDMX must reference a Provision agreement by URN.  Note : The 2.1 URN syntax for provision agreements must be used; the 2.0 URN syntax for provision agreements is not longer supported");
            }
        }
        this.validate();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("RegistrationBean Built " + this.getUrn()));
        }
    }

    public RegistrationBeanImpl(ProvisionAgreementRefType provRef, DatasourceType datasourceType) {
        super(null, SDMX_STRUCTURE_TYPE.REGISTRATION, null, null, null, TERTIARY_BOOL.FALSE, "NA", null, null, null, null, TERTIARY_BOOL.FALSE, null);
        LOG.debug((Object)"Building RegistrationBean from Provision and Datasource");
        if (datasourceType != null) {
            this.dataSource = new DataSourceBeanImpl(datasourceType, (SdmxStructureBean)this);
        }
        if (provRef != null) {
            this.provisionAgreementRef = new CrossReferenceBeanImpl((SDMXBean)this, provRef.getURN());
        }
        this.validate();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("RegistrationBean Built " + this.getUrn()));
        }
    }

    private void validate() throws SdmxSemmanticException {
        if (this.provisionAgreementRef == null) {
            throw new SdmxSemmanticException("Registration must reference a provision agreement");
        }
        if (this.provisionAgreementRef.getTargetReference() != SDMX_STRUCTURE_TYPE.PROVISION_AGREEMENT) {
            throw new SdmxSemmanticException("Registration must reference a provision agreement, actual referenced structre supplied was " + this.provisionAgreementRef.getTargetReference().getType());
        }
        if (this.dataSource == null) {
            throw new SdmxSemmanticException("Registration must have a datasource");
        }
        this.agencyId = this.provisionAgreementRef.getMaintainableReference().getAgencyId();
        if (!ObjectUtil.validString(this.getId())) {
            this.setId(this.generateId());
        }
        super.validateId(true);
        super.validateAgencyId();
    }

    @Override
    protected void validateAgencyId() {
    }

    @Override
    protected void validateId(boolean startWithIntAllowed) {
    }

    @Override
    public boolean deepEquals(SDMXBean bean, boolean includeFinalProperties) {
        throw new SdmxNotImplementedException("deepEquals on registration");
    }

    private String generateId() {
        return RandomUtil.generateRandomString();
    }

    @Override
    public boolean isIndexed() {
        return this.indexAttributes.isTrue() || this.indexDataset.isTrue() || this.indexReportingPeriod.isTrue() || this.indexTimeSeries.isTrue();
    }

    @Override
    public MaintainableBean getStub(URL actualLocation, boolean isServiceUrl) {
        return this;
    }

    @Override
    public RegistrationMutableBean getMutableInstance() {
        return new RegistrationMutableBeanImpl(this);
    }

    @Override
    public TERTIARY_BOOL getIndexTimeSeries() {
        return this.indexTimeSeries;
    }

    @Override
    public TERTIARY_BOOL getIndexDataset() {
        return this.indexDataset;
    }

    @Override
    public TERTIARY_BOOL getIndexAttributes() {
        return this.indexAttributes;
    }

    @Override
    public TERTIARY_BOOL getIndexReportingPeriod() {
        return this.indexReportingPeriod;
    }

    @Override
    public DataSourceBean getDataSource() {
        return this.dataSource;
    }

    @Override
    public SdmxDate getLastUpdated() {
        return this.lastUpdated;
    }

    @Override
    public List<CrossReferenceBean> getCrossReferencedConstrainables() {
        ArrayList<CrossReferenceBean> returnList = new ArrayList<CrossReferenceBean>();
        returnList.add(this.getProvisionAgreementRef());
        return returnList;
    }

    @Override
    public CrossReferenceBean getProvisionAgreementRef() {
        return this.provisionAgreementRef;
    }

    @Override
    public SdmxDate getValidFrom() {
        return this.validFrom;
    }

    @Override
    public SdmxDate getValidTo() {
        return this.validTo;
    }

    @Override
    protected Set<SDMXBean> getCompositesInternal() {
        Set<SDMXBean> composites = super.getCompositesInternal();
        super.addToCompositeSet(this.dataSource, composites);
        return composites;
    }
}

