/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.data;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sdmxsource.sdmx.api.constants.TIME_FORMAT;
import org.sdmxsource.sdmx.api.model.data.KeyValue;
import org.sdmxsource.sdmx.api.model.data.Keyable;
import org.sdmxsource.sdmx.api.model.data.Observation;
import org.sdmxsource.sdmx.util.date.DateUtil;
import org.sdmxsource.util.ObjectUtil;

public class ObservationImpl
implements Observation {
    private Keyable seriesKey;
    private String obsValue;
    private String obsTime;
    private List<KeyValue> attributes = new ArrayList<KeyValue>();
    private Date date;
    private TIME_FORMAT timeFormat;
    private boolean isCrossSection;
    private KeyValue crossSectionValue;
    private Map<String, KeyValue> attributeMap = new HashMap<String, KeyValue>();

    public ObservationImpl(Keyable seriesKey, String obsTime, String obsValue, List<KeyValue> attributes, KeyValue crossSectionValue) {
        this.seriesKey = seriesKey;
        this.obsValue = obsValue;
        this.obsTime = obsTime;
        if (seriesKey == null) {
            throw new IllegalArgumentException("Series Key can not be null");
        }
        if (attributes != null) {
            this.attributes = new ArrayList<KeyValue>(attributes);
            for (KeyValue currentKv : attributes) {
                this.attributeMap.put(currentKv.getConcept(), currentKv);
            }
        }
        this.crossSectionValue = crossSectionValue;
        this.isCrossSection = true;
    }

    public ObservationImpl(Keyable seriesKey, String obsTime, String obsValue, List<KeyValue> attributes) {
        this.obsValue = obsValue;
        this.seriesKey = seriesKey;
        if (seriesKey == null) {
            throw new IllegalArgumentException("Series Key can not be null");
        }
        if (!ObjectUtil.validString(obsTime)) {
            if (seriesKey.isTimeSeries()) {
                throw new IllegalArgumentException("Observation for Key '" + seriesKey + "' does not specify the observation time");
            }
            throw new IllegalArgumentException("Observation for Key '" + seriesKey + "' does not specify the observation concept: " + seriesKey.getCrossSectionConcept());
        }
        if (!ObjectUtil.validString(obsValue)) {
            this.obsValue = "NaN";
        }
        this.obsTime = obsTime;
        if (attributes != null) {
            this.attributes = new ArrayList<KeyValue>(attributes);
            for (KeyValue currentKv : attributes) {
                this.attributeMap.put(currentKv.getConcept(), currentKv);
            }
        }
        this.isCrossSection = false;
    }

    @Override
    public Keyable getSeriesKey() {
        return this.seriesKey;
    }

    @Override
    public String getObservationValue() {
        return this.obsValue;
    }

    @Override
    public KeyValue getAttribute(String concept) {
        return this.attributeMap.get(concept);
    }

    @Override
    public String getObsTime() {
        return this.obsTime;
    }

    @Override
    public boolean isCrossSection() {
        return this.isCrossSection;
    }

    @Override
    public KeyValue getCrossSectionalValue() {
        return this.crossSectionValue;
    }

    @Override
    public Date getObsAsTimeDate() {
        if (this.obsTime == null) {
            return null;
        }
        if (this.date == null) {
            this.date = DateUtil.formatDate(this.obsTime, true);
        }
        return new Date(this.date.getTime());
    }

    @Override
    public TIME_FORMAT getObsTimeFormat() {
        if (this.obsTime == null) {
            return null;
        }
        if (this.timeFormat == null) {
            this.timeFormat = DateUtil.getTimeFormatOfDate(this.obsTime);
        }
        return this.timeFormat;
    }

    @Override
    public List<KeyValue> getAttributes() {
        return new ArrayList<KeyValue>(this.attributes);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        return obj.toString().equals(this.toString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String concat = "";
        for (KeyValue kv : this.attributes) {
            sb.append(concat + kv.getConcept() + ":" + kv.getCode());
            concat = ",";
        }
        if (this.isCrossSection) {
            return "Obs " + this.crossSectionValue.getConcept() + ":" + this.crossSectionValue.getCode() + " = " + this.obsValue + " - Attributes : " + sb.toString();
        }
        return "Obs " + this.obsTime + " = " + this.obsValue + " - Attributes : " + sb.toString();
    }

    @Override
    public int compareTo(Observation o) {
        if (this.obsTime == null) {
            if (o.getObsTime() == null) {
                return 0;
            }
            return -1;
        }
        if (o.getObsTime() == null) {
            return 1;
        }
        if (this.obsTime.length() == o.getObsTime().length()) {
            return this.obsTime.compareTo(o.getObsTime());
        }
        return this.getObsAsTimeDate().compareTo(o.getObsAsTimeDate());
    }
}

