/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.data.query;

import java.util.Set;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataflowBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DimensionBean;

public abstract class BaseDataQuery {
    protected String dimensionAtObservation;
    protected Integer firstNObs;
    protected Integer lastNObs;
    protected DataflowBean dataflowBean;
    protected DataStructureBean dataStructureBean;

    protected void validateQuery() {
        if (this.dataflowBean == null) {
            throw new IllegalArgumentException("Can not create DataQuery, Dataflow is required");
        }
        if (this.dataStructureBean == null) {
            throw new IllegalArgumentException("Can not create DataQuery, DataStructure is required");
        }
        this.validateQueryComponents();
        this.validateDimensionAtObservation();
    }

    private void validateQueryComponents() throws SdmxSemmanticException {
        for (String currentComponetId : this.getQueryComponentIds()) {
            if (this.dataStructureBean.getComponent(currentComponetId) != null) continue;
            throw new SdmxSemmanticException("Data Structure '" + this.dataStructureBean.getUrn() + "' does not contain component with id: " + currentComponetId);
        }
    }

    protected abstract Set<String> getQueryComponentIds();

    private void validateDimensionAtObservation() {
        DimensionBean dimension;
        if (this.dimensionAtObservation == null) {
            this.dimensionAtObservation = this.dataStructureBean.getTimeDimension() != null ? this.dataStructureBean.getTimeDimension().getId() : (this.dataStructureBean.getDimensions(SDMX_STRUCTURE_TYPE.MEASURE_DIMENSION).size() > 0 ? this.dataStructureBean.getDimensions(SDMX_STRUCTURE_TYPE.MEASURE_DIMENSION).get(0).getId() : "AllDimensions");
        } else if (!this.dimensionAtObservation.equals("AllDimensions") && (dimension = this.dataStructureBean.getDimension(this.dimensionAtObservation)) == null) {
            StringBuilder sb = new StringBuilder();
            for (DimensionBean dim : this.dataStructureBean.getDimensions(SDMX_STRUCTURE_TYPE.DIMENSION, SDMX_STRUCTURE_TYPE.MEASURE_DIMENSION, SDMX_STRUCTURE_TYPE.TIME_DIMENSION)) {
                sb.append(dim.getId() + System.getProperty("line.separator"));
            }
            throw new IllegalArgumentException("Can not create DataQuery, The dimension at observation '" + this.dimensionAtObservation + "' is not included in the Dimension list of the DSD.  Allowed values are " + sb.toString());
        }
    }

    public String getDimensionAtObservation() {
        return this.dimensionAtObservation;
    }
}

