/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.data.query.complex;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.ORDERED_OPERATOR;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.model.base.SdmxDate;
import org.sdmxsource.sdmx.api.model.data.query.complex.ComplexComponentValue;
import org.sdmxsource.sdmx.api.model.data.query.complex.ComplexDataQuerySelection;
import org.sdmxsource.sdmx.api.model.data.query.complex.ComplexDataQuerySelectionGroup;

public class ComplexDataQuerySelectionGroupImpl
implements ComplexDataQuerySelectionGroup {
    private static final long serialVersionUID = 6323143498242961423L;
    private Set<ComplexDataQuerySelection> complexSelections = new HashSet<ComplexDataQuerySelection>();
    private Set<ComplexComponentValue> primaryMeasureValues = new HashSet<ComplexComponentValue>();
    private Map<String, ComplexDataQuerySelection> complexSelectionForConcept = new HashMap<String, ComplexDataQuerySelection>();
    private SdmxDate dateFrom;
    private ORDERED_OPERATOR dateToOperator;
    private ORDERED_OPERATOR dateFromOperator;
    private SdmxDate dateTo;

    public ComplexDataQuerySelectionGroupImpl(Set<ComplexDataQuerySelection> complexSelections, SdmxDate dateFrom, ORDERED_OPERATOR dateFromOperator, SdmxDate dateTo, ORDERED_OPERATOR dateToOperator, Set<ComplexComponentValue> primaryMeasureValues) {
        if (dateFromOperator.equals((Object)ORDERED_OPERATOR.NOT_EQUAL) || dateToOperator.equals((Object)ORDERED_OPERATOR.NOT_EQUAL)) {
            throw new SdmxSemmanticException(ExceptionCode.QUERY_SELECTION_ILLEGAL_OPERATOR, new Object[0]);
        }
        if (complexSelections == null) {
            return;
        }
        this.dateFrom = dateFrom;
        this.dateFromOperator = dateFromOperator;
        this.dateTo = dateTo;
        this.dateToOperator = dateToOperator;
        this.complexSelections = complexSelections;
        this.primaryMeasureValues = primaryMeasureValues;
        for (ComplexDataQuerySelection compSel : complexSelections) {
            if (this.complexSelectionForConcept.containsKey(compSel.getComponentId())) {
                throw new IllegalArgumentException("Duplicate concept");
            }
            this.complexSelectionForConcept.put(compSel.getComponentId(), compSel);
        }
    }

    @Override
    public ComplexDataQuerySelection getSelectionsForConcept(String componentId) {
        return this.complexSelectionForConcept.get(componentId);
    }

    @Override
    public boolean hasSelectionForConcept(String componentId) {
        return this.complexSelectionForConcept.containsKey(componentId);
    }

    @Override
    public Set<ComplexDataQuerySelection> getSelections() {
        return this.complexSelections;
    }

    @Override
    public SdmxDate getDateFrom() {
        return this.dateFrom;
    }

    @Override
    public ORDERED_OPERATOR getDateFromOperator() {
        return this.dateFromOperator;
    }

    @Override
    public SdmxDate getDateTo() {
        return this.dateTo;
    }

    @Override
    public ORDERED_OPERATOR getDateToOperator() {
        return this.dateToOperator;
    }

    @Override
    public Set<ComplexComponentValue> getPrimaryMeasureValue() {
        return this.primaryMeasureValues;
    }
}

