/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.data.query.complex;

import java.util.HashSet;
import java.util.Set;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.model.data.query.complex.ComplexComponentValue;
import org.sdmxsource.sdmx.api.model.data.query.complex.ComplexDataQuerySelection;
import org.sdmxsource.util.ObjectUtil;

public class ComplexDataQuerySelectionImpl
implements ComplexDataQuerySelection {
    private static final long serialVersionUID = 3184465505938333131L;
    String componentId;
    private Set<ComplexComponentValue> values = new HashSet<ComplexComponentValue>();

    public ComplexDataQuerySelectionImpl(String componentId, ComplexComponentValue ... value) {
        if (!ObjectUtil.validString(componentId)) {
            throw new SdmxSemmanticException(ExceptionCode.QUERY_SELECTION_MISSING_CONCEPT, new Object[0]);
        }
        this.componentId = componentId;
        if (value == null || value.length == 0) {
            throw new SdmxSemmanticException(ExceptionCode.QUERY_SELECTION_MISSING_CONCEPT_VALUE, new Object[0]);
        }
        for (ComplexComponentValue currentValue : value) {
            this.values.add(currentValue);
        }
    }

    public ComplexDataQuerySelectionImpl(String componentId, Set<ComplexComponentValue> values) {
        if (!ObjectUtil.validString(componentId)) {
            throw new SdmxSemmanticException(ExceptionCode.QUERY_SELECTION_MISSING_CONCEPT, new Object[0]);
        }
        this.componentId = componentId;
        if (!ObjectUtil.validCollection(values)) {
            throw new SdmxSemmanticException(ExceptionCode.QUERY_SELECTION_MISSING_CONCEPT_VALUE, new Object[0]);
        }
        this.values = new HashSet<ComplexComponentValue>(values);
    }

    public void addValue(ComplexComponentValue value) {
        this.values.add(value);
    }

    @Override
    public String getComponentId() {
        return this.componentId;
    }

    @Override
    public ComplexComponentValue getValue() {
        if (this.values.size() > 1) {
            throw new IllegalArgumentException("More than one value exists for this selection");
        }
        return (ComplexComponentValue)this.values.toArray()[0];
    }

    @Override
    public Set<ComplexComponentValue> getValues() {
        return this.values;
    }

    @Override
    public boolean hasMultipleValues() {
        return this.values.size() > 1;
    }

    public boolean equals(Object obj) {
        return obj instanceof ComplexDataQuerySelection && this.getComponentId().equals(((ComplexDataQuerySelection)obj).getComponentId()) && this.getValues().containsAll(((ComplexDataQuerySelection)obj).getValues()) && ((ComplexDataQuerySelection)obj).getValues().containsAll(this.getValues());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("");
        sb.append(this.componentId);
        sb.append("");
        sb.append(" : ");
        String concat = "";
        for (ComplexComponentValue currentValue : this.values) {
            sb.append(concat);
            sb.append(currentValue.getValue());
            concat = ",";
        }
        return sb.toString();
    }
}

