/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.header;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sdmx.resources.sdmxml.schemas.v20.common.TextType;
import org.sdmx.resources.sdmxml.schemas.v20.message.HeaderType;
import org.sdmx.resources.sdmxml.schemas.v20.message.PartyType;
import org.sdmx.resources.sdmxml.schemas.v21.common.PayloadStructureType;
import org.sdmx.resources.sdmxml.schemas.v21.message.BaseHeaderType;
import org.sdmxsource.sdmx.api.constants.DATASET_ACTION;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.model.beans.base.TextTypeWrapper;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.api.model.header.DatasetStructureReferenceBean;
import org.sdmxsource.sdmx.api.model.header.HeaderBean;
import org.sdmxsource.sdmx.api.model.header.PartyBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.TextTypeWrapperImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.header.DatasetStructureReferenceBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.header.PartyBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.util.RefUtil;
import org.sdmxsource.sdmx.util.date.DateUtil;
import org.sdmxsource.util.ObjectUtil;
import org.sdmxsource.util.random.RandomUtil;

public class HeaderBeanImpl
implements HeaderBean,
Serializable {
    private static final long serialVersionUID = -1069998895797472200L;
    private Map<String, String> additionalAttributes = new HashMap<String, String>();
    private StructureReferenceBean dataProviderReference;
    private DATASET_ACTION datasetAction;
    private String id;
    private String datasetId;
    private Date embargoDate;
    private Date extracted;
    private Date prepared;
    private Date reportingBegin;
    private Date reportingEnd;
    private List<TextTypeWrapper> name = new ArrayList<TextTypeWrapper>();
    private List<TextTypeWrapper> source = new ArrayList<TextTypeWrapper>();
    private List<PartyBean> receiver = new ArrayList<PartyBean>();
    private List<DatasetStructureReferenceBean> structureReferences = new ArrayList<DatasetStructureReferenceBean>();
    private PartyBean sender;
    private boolean test;

    public HeaderBeanImpl(String id, String senderId) {
        this.id = id;
        this.sender = new PartyBeanImpl(null, senderId, null, null);
        this.prepared = new Date();
    }

    public HeaderBeanImpl(String id, Date prepared, Date reportingBegin, Date reportingEnd, List<PartyBean> receiver, PartyBean sender) {
        this(null, null, null, null, id, null, null, null, prepared, reportingBegin, reportingEnd, null, null, receiver, sender, false);
    }

    public HeaderBeanImpl(Map<String, String> additionalAttributes, List<DatasetStructureReferenceBean> structures, StructureReferenceBean dataProviderReference, DATASET_ACTION datasetAction, String id, String datasetId, Date embargoDate, Date extracted, Date prepared, Date reportingBegin, Date reportingEnd, List<TextTypeWrapper> name, List<TextTypeWrapper> source, List<PartyBean> receiver, PartyBean sender, boolean test) {
        if (additionalAttributes != null) {
            this.additionalAttributes = new HashMap<String, String>(additionalAttributes);
        }
        if (structures != null) {
            this.structureReferences = new ArrayList<DatasetStructureReferenceBean>(structures);
        }
        this.dataProviderReference = dataProviderReference;
        this.datasetAction = datasetAction;
        this.id = id;
        this.datasetId = datasetId;
        if (embargoDate != null) {
            this.embargoDate = new Date(embargoDate.getTime());
        }
        if (extracted != null) {
            this.extracted = new Date(extracted.getTime());
        }
        if (prepared != null) {
            this.prepared = new Date(prepared.getTime());
        }
        if (reportingBegin != null) {
            this.reportingBegin = new Date(reportingBegin.getTime());
        }
        if (reportingEnd != null) {
            this.reportingEnd = new Date(reportingEnd.getTime());
        }
        if (name != null) {
            this.name = new ArrayList<TextTypeWrapper>(name);
        }
        if (source != null) {
            this.source = new ArrayList<TextTypeWrapper>(source);
        }
        if (receiver != null) {
            this.receiver = new ArrayList<PartyBean>(receiver);
        }
        this.sender = sender;
        this.test = test;
        this.validate();
    }

    public HeaderBeanImpl(BaseHeaderType headerType) {
        this.test = headerType.getTest();
        if (headerType.getDataProvider() != null) {
            this.dataProviderReference = RefUtil.createReference(headerType.getDataProvider());
        }
        if (headerType.getDataSetAction() != null) {
            switch (headerType.getDataSetAction().intValue()) {
                case 1: {
                    this.datasetAction = DATASET_ACTION.APPEND;
                    break;
                }
                case 2: {
                    this.datasetAction = DATASET_ACTION.REPLACE;
                    break;
                }
                case 3: {
                    this.datasetAction = DATASET_ACTION.DELETE;
                }
            }
        }
        if (ObjectUtil.validCollection(headerType.getDataSetIDList())) {
            this.datasetId = headerType.getDataSetIDArray(0);
        }
        this.id = headerType.getID();
        if (headerType.getEmbargoDate() != null) {
            this.embargoDate = headerType.getEmbargoDate().getTime();
        }
        if (headerType.getExtracted() != null) {
            this.extracted = headerType.getExtracted().getTime();
        }
        if (ObjectUtil.validCollection(headerType.getNameList())) {
            for (org.sdmx.resources.sdmxml.schemas.v21.common.TextType tt : headerType.getNameList()) {
                this.name.add(new TextTypeWrapperImpl(tt, null));
            }
        }
        if (headerType.getPrepared() != null) {
            this.prepared = headerType.getPrepared().getTime();
        }
        if (ObjectUtil.validCollection(headerType.getReceiverList())) {
            for (org.sdmx.resources.sdmxml.schemas.v21.message.PartyType party : headerType.getReceiverList()) {
                this.receiver.add(new PartyBeanImpl(party));
            }
        }
        if (headerType.getReportingBegin() != null) {
            this.reportingBegin = DateUtil.formatDate(headerType.getReportingBegin(), true);
        }
        if (headerType.getReportingEnd() != null) {
            this.reportingEnd = DateUtil.formatDate(headerType.getReportingEnd(), true);
        }
        if (headerType.getSender() != null) {
            this.sender = new PartyBeanImpl(headerType.getSender());
        }
        if (ObjectUtil.validCollection(headerType.getSourceList())) {
            for (org.sdmx.resources.sdmxml.schemas.v21.common.TextType tt : headerType.getSourceList()) {
                this.source.add(new TextTypeWrapperImpl(tt, null));
            }
        }
        if (ObjectUtil.validCollection(headerType.getStructureList())) {
            for (PayloadStructureType payloadSt : headerType.getStructureList()) {
                this.structureReferences.add(new DatasetStructureReferenceBeanImpl(payloadSt));
            }
        }
        this.validate();
    }

    public HeaderBeanImpl(HeaderType headerType) {
        this.test = headerType.getTest();
        if (headerType.getDataSetAction() != null) {
            switch (headerType.getDataSetAction().intValue()) {
                case 1: {
                    this.datasetAction = DATASET_ACTION.APPEND;
                    break;
                }
                case 2: {
                    this.datasetAction = DATASET_ACTION.REPLACE;
                    break;
                }
                case 3: {
                    this.datasetAction = DATASET_ACTION.DELETE;
                }
            }
        }
        this.id = headerType.getID();
        this.datasetId = headerType.getDataSetID();
        if (headerType.getExtracted() != null) {
            this.extracted = headerType.getExtracted().getTime();
        }
        if (ObjectUtil.validCollection(headerType.getNameList())) {
            for (TextType tt : headerType.getNameList()) {
                this.name.add(new TextTypeWrapperImpl(tt, null));
            }
        }
        if (headerType.getPrepared() != null) {
            this.prepared = headerType.getPrepared().getTime();
        }
        if (ObjectUtil.validCollection(headerType.getReceiverList())) {
            for (PartyType party : headerType.getReceiverList()) {
                this.receiver.add(new PartyBeanImpl(party));
            }
        }
        if (headerType.getReportingBegin() != null) {
            this.reportingBegin = DateUtil.formatDate(headerType.getReportingBegin(), true);
        }
        if (headerType.getReportingEnd() != null) {
            this.reportingEnd = DateUtil.formatDate(headerType.getReportingEnd(), true);
        }
        if (ObjectUtil.validCollection(headerType.getSenderList())) {
            this.sender = new PartyBeanImpl(headerType.getSenderList().get(0));
        }
        if (ObjectUtil.validCollection(headerType.getSourceList())) {
            for (TextType tt : headerType.getSourceList()) {
                this.source.add(new TextTypeWrapperImpl(tt, null));
            }
        }
        if (ObjectUtil.validString(headerType.getKeyFamilyAgency())) {
            this.additionalAttributes.put("DSD_AGENCY_ID", headerType.getKeyFamilyAgency());
        }
        if (ObjectUtil.validString(headerType.getKeyFamilyRef())) {
            this.additionalAttributes.put("DSD_REFERENCE", headerType.getKeyFamilyRef());
        }
        this.validate();
    }

    public HeaderBeanImpl(org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.message.HeaderType headerType) {
        this.test = headerType.getTest();
        if (headerType.getDataSetAction() != null) {
            switch (headerType.getDataSetAction().intValue()) {
                case 1: {
                    this.datasetAction = DATASET_ACTION.REPLACE;
                    break;
                }
                case 2: {
                    this.datasetAction = DATASET_ACTION.REPLACE;
                }
            }
        }
        this.id = headerType.getID();
        this.datasetId = headerType.getDataSetID();
        if (headerType.getExtracted() != null) {
            this.extracted = headerType.getExtracted().getTime();
        }
        if (ObjectUtil.validCollection(headerType.getNameList())) {
            for (org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.common.TextType tt : headerType.getNameList()) {
                this.name.add(new TextTypeWrapperImpl(tt, null));
            }
        }
        if (headerType.getPrepared() != null) {
            this.prepared = headerType.getPrepared().getTime();
        }
        if (ObjectUtil.validCollection(headerType.getReceiverList())) {
            for (org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.message.PartyType party : headerType.getReceiverList()) {
                this.receiver.add(new PartyBeanImpl(party));
            }
        }
        if (headerType.getReportingBegin() != null) {
            this.reportingBegin = DateUtil.formatDate(headerType.getReportingBegin(), true);
        }
        if (headerType.getReportingEnd() != null) {
            this.reportingEnd = DateUtil.formatDate(headerType.getReportingEnd(), true);
        }
        if (headerType.getSender() != null) {
            this.sender = new PartyBeanImpl(headerType.getSender());
        }
        if (ObjectUtil.validCollection(headerType.getSourceList())) {
            for (org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.common.TextType tt : headerType.getSourceList()) {
                this.source.add(new TextTypeWrapperImpl(tt, null));
            }
        }
        if (ObjectUtil.validString(headerType.getKeyFamilyAgency())) {
            this.additionalAttributes.put("DSD_AGENCY_ID", headerType.getKeyFamilyAgency());
        }
        if (ObjectUtil.validString(headerType.getKeyFamilyRef())) {
            this.additionalAttributes.put("DSD_REFERENCE", headerType.getKeyFamilyRef());
        }
        this.validate();
    }

    private void validate() {
        if (!ObjectUtil.validString(this.id)) {
            this.id = RandomUtil.generateRandomString();
        }
        if (this.prepared == null) {
            this.prepared = new Date();
        }
        if (this.sender == null && !ObjectUtil.validString(this.id)) {
            throw new SdmxSemmanticException("Header missing sender");
        }
    }

    @Override
    public StructureReferenceBean getDataProviderReference() {
        return this.dataProviderReference;
    }

    @Override
    public DatasetStructureReferenceBean getStructureById(String structureId) {
        for (DatasetStructureReferenceBean currentStructure : this.structureReferences) {
            if (!currentStructure.getId().equals(structureId)) continue;
            return currentStructure;
        }
        return null;
    }

    @Override
    public void setId(String id) {
        this.id = id;
        this.validate();
    }

    @Override
    public void setSender(PartyBean party) {
        this.sender = party;
        this.validate();
    }

    @Override
    public void setTest(boolean test) {
        this.test = test;
    }

    @Override
    public void addStructure(DatasetStructureReferenceBean ref) {
        this.structureReferences.add(ref);
    }

    @Override
    public List<DatasetStructureReferenceBean> getStructures() {
        return new ArrayList<DatasetStructureReferenceBean>(this.structureReferences);
    }

    @Override
    public DATASET_ACTION getAction() {
        return this.datasetAction;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getDatasetId() {
        return this.datasetId;
    }

    @Override
    public Date getEmbargoDate() {
        if (this.embargoDate != null) {
            return new Date(this.embargoDate.getTime());
        }
        return null;
    }

    @Override
    public Date getExtracted() {
        if (this.extracted != null) {
            return new Date(this.extracted.getTime());
        }
        return null;
    }

    @Override
    public List<TextTypeWrapper> getName() {
        return new ArrayList<TextTypeWrapper>(this.name);
    }

    @Override
    public Date getPrepared() {
        if (this.prepared != null) {
            return new Date(this.prepared.getTime());
        }
        return null;
    }

    @Override
    public List<PartyBean> getReceiver() {
        return new ArrayList<PartyBean>(this.receiver);
    }

    @Override
    public Date getReportingBegin() {
        return this.reportingBegin;
    }

    @Override
    public void setReportingBegin(Date date) {
        this.reportingBegin = date;
    }

    @Override
    public Date getReportingEnd() {
        return this.reportingEnd;
    }

    @Override
    public void setReportingEnd(Date date) {
        this.reportingEnd = date;
    }

    @Override
    public List<TextTypeWrapper> getSource() {
        return new ArrayList<TextTypeWrapper>(this.source);
    }

    @Override
    public PartyBean getSender() {
        return this.sender;
    }

    @Override
    public boolean isTest() {
        return this.test;
    }

    @Override
    public Map<String, String> getAdditionalAttributes() {
        return new HashMap<String, String>(this.additionalAttributes);
    }

    @Override
    public boolean hasAdditionalAttribute(String headerField) {
        return this.additionalAttributes.containsKey(headerField);
    }

    @Override
    public String getAdditionalAttribute(String headerField) {
        return this.additionalAttributes.get(headerField);
    }

    @Override
    public void setDataProviderReference(StructureReferenceBean dataProvider) {
        if (dataProvider != null) {
            if (dataProvider.getTargetReference() != SDMX_STRUCTURE_TYPE.DATA_PROVIDER) {
                throw new SdmxSemmanticException("Header.setDataProviderReference - structure type does not reference a data provider, it references a " + dataProvider.getTargetReference().getType());
            }
            if (dataProvider.getTargetUrn() == null) {
                throw new SdmxSemmanticException("Header.setDataProviderReference - data provider reference incomplete");
            }
        }
        this.dataProviderReference = dataProvider;
    }

    @Override
    public void setAction(DATASET_ACTION action) {
        this.datasetAction = action;
    }

    @Override
    public void setDatasetId(String datasetId) {
        this.datasetId = datasetId;
    }

    @Override
    public void addName(TextTypeWrapper name) {
        this.name.add(name);
    }

    @Override
    public void addReceiver(PartyBean recevier) {
        this.receiver.add(recevier);
    }

    @Override
    public void addSource(TextTypeWrapper source) {
        this.source.add(source);
    }
}

