/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.metadata;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sdmx.resources.sdmxml.schemas.v21.metadata.generic.ReportType;
import org.sdmx.resources.sdmxml.schemas.v21.metadata.generic.ReportedAttributeType;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.model.base.SdmxDate;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.reference.CrossReferenceBean;
import org.sdmxsource.sdmx.api.model.metadata.DataKeyBean;
import org.sdmxsource.sdmx.api.model.metadata.MetadataReportBean;
import org.sdmxsource.sdmx.api.model.metadata.MetadataSetBean;
import org.sdmxsource.sdmx.api.model.metadata.ReferenceValueBean;
import org.sdmxsource.sdmx.api.model.metadata.ReportedAttributeBean;
import org.sdmxsource.sdmx.api.model.metadata.TargetBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.SDMXBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.metadata.ReportedAttributeBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.metadata.TargetBeanImpl;
import org.sdmxsource.util.ObjectUtil;

public class MetadataReportBeanImpl
extends SDMXBeanImpl
implements MetadataReportBean {
    private static final long serialVersionUID = 4729253989941473368L;
    private TargetBean _target;
    private List<ReportedAttributeBean> _reportedAttributes = new ArrayList<ReportedAttributeBean>();
    private String id;

    public MetadataReportBeanImpl(MetadataSetBean parent, ReportType bean) {
        super(SDMX_STRUCTURE_TYPE.METADATA_REPORT, (SDMXBean)parent);
        this.id = bean.getId();
        if (bean.getTarget() != null) {
            this._target = new TargetBeanImpl(this, bean.getTarget());
        }
        if (bean.getAttributeSet() != null && ObjectUtil.validCollection(bean.getAttributeSet().getReportedAttributeList())) {
            this._reportedAttributes.clear();
            for (ReportedAttributeType each : bean.getAttributeSet().getReportedAttributeList()) {
                this._reportedAttributes.add(new ReportedAttributeBeanImpl(this, each));
            }
        }
        this.validate();
    }

    private void validate() {
        if (!ObjectUtil.validString(this.id)) {
            throw new SdmxSemmanticException("Metadata Report must have an Id");
        }
        if (this._target == null) {
            throw new SdmxSemmanticException("Metadata Report must have a Target");
        }
        if (!ObjectUtil.validCollection(this._reportedAttributes)) {
            throw new SdmxSemmanticException("Metadata Report must have at least one Reported Attribute");
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public TargetBean getTarget() {
        return this._target;
    }

    @Override
    public List<ReportedAttributeBean> getReportedAttributes() {
        return new ArrayList<ReportedAttributeBean>(this._reportedAttributes);
    }

    @Override
    public Set<ReferenceValueBean.TARGET_TYPE> getTargets() {
        HashSet<ReferenceValueBean.TARGET_TYPE> targets = new HashSet<ReferenceValueBean.TARGET_TYPE>();
        for (ReferenceValueBean rv : this._target.getReferenceValues()) {
            targets.add(rv.getTargetType());
        }
        return targets;
    }

    @Override
    public String getTargetDatasetId() {
        for (ReferenceValueBean rv : this._target.getReferenceValues()) {
            if (rv.getTargetType() != ReferenceValueBean.TARGET_TYPE.DATASET) continue;
            return rv.getDatasetId();
        }
        return null;
    }

    @Override
    public SdmxDate getTargetReportPeriod() {
        for (ReferenceValueBean rv : this._target.getReferenceValues()) {
            if (rv.getTargetType() != ReferenceValueBean.TARGET_TYPE.REPORT_PERIOD) continue;
            return rv.getReportPeriod();
        }
        return null;
    }

    @Override
    public CrossReferenceBean getTargetIdentifiableReference() {
        for (ReferenceValueBean rv : this._target.getReferenceValues()) {
            if (rv.getTargetType() != ReferenceValueBean.TARGET_TYPE.IDENTIFIABLE) continue;
            return rv.getIdentifiableReference();
        }
        return null;
    }

    @Override
    public CrossReferenceBean getTargetContentConstraintReference() {
        for (ReferenceValueBean rv : this._target.getReferenceValues()) {
            if (rv.getTargetType() != ReferenceValueBean.TARGET_TYPE.CONSTRAINT) continue;
            return rv.getContentConstraintReference();
        }
        return null;
    }

    @Override
    public List<DataKeyBean> getTargetDataKeys() {
        for (ReferenceValueBean rv : this._target.getReferenceValues()) {
            if (rv.getTargetType() != ReferenceValueBean.TARGET_TYPE.DATA_KEY) continue;
            return rv.getDataKeys();
        }
        return null;
    }

    @Override
    protected Set<SDMXBean> getCompositesInternal() {
        HashSet<SDMXBean> composites = new HashSet<SDMXBean>();
        super.addToCompositeSet(this._target, composites);
        super.addToCompositeSet(this._reportedAttributes, composites);
        return composites;
    }
}

