/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.metadata;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sdmx.resources.sdmxml.schemas.v21.metadata.generic.MetadataSetType;
import org.sdmx.resources.sdmxml.schemas.v21.metadata.generic.ReportType;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.constants.TIME_FORMAT;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.model.base.SdmxDate;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.base.TextTypeWrapper;
import org.sdmxsource.sdmx.api.model.beans.reference.CrossReferenceBean;
import org.sdmxsource.sdmx.api.model.header.DatasetStructureReferenceBean;
import org.sdmxsource.sdmx.api.model.metadata.MetadataBean;
import org.sdmxsource.sdmx.api.model.metadata.MetadataReportBean;
import org.sdmxsource.sdmx.api.model.metadata.MetadataSetBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.SDMXBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.SdmxDateImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.metadata.MetadataReportBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.util.RefUtil;
import org.sdmxsource.sdmx.sdmxbeans.util.TextTypeUtil;
import org.sdmxsource.sdmx.util.beans.reference.CrossReferenceBeanImpl;
import org.sdmxsource.util.ObjectUtil;

public class MetadataSetBeanImpl
extends SDMXBeanImpl
implements MetadataSetBean {
    private static final long serialVersionUID = -4992186811361863150L;
    private String _setId;
    private CrossReferenceBean _structureRef;
    private SdmxDate _reportingBeginDate;
    private SdmxDate _reportingEndDate;
    private SdmxDate _publicationYear;
    private SdmxDate _validFromDate;
    private SdmxDate _validToDate;
    private Object _publicationPeriod;
    private CrossReferenceBean _dataProviderReference;
    private List<TextTypeWrapper> _names = new ArrayList<TextTypeWrapper>();
    private List<MetadataReportBean> _reports = new ArrayList<MetadataReportBean>();

    private MetadataSetBeanImpl(MetadataSetBeanImpl metadataSet, MetadataReportBean report) {
        super(SDMX_STRUCTURE_TYPE.METADATA_SET, null);
        this._setId = metadataSet.getSetId();
        this._structureRef = metadataSet._structureRef;
        this._reportingBeginDate = metadataSet._reportingBeginDate;
        this._reportingEndDate = metadataSet._reportingEndDate;
        this._publicationYear = metadataSet._publicationYear;
        this._validFromDate = metadataSet._validFromDate;
        this._validToDate = metadataSet._validToDate;
        this._publicationPeriod = metadataSet._publicationPeriod;
        this._dataProviderReference = metadataSet._dataProviderReference;
        this._names = metadataSet.getNames();
        this._reports.add(report);
    }

    public MetadataSetBeanImpl(MetadataBean parent, MetadataSetType createdFrom) {
        super(SDMX_STRUCTURE_TYPE.METADATA_SET, (SDMXBean)parent);
        this._setId = createdFrom.getSetID();
        for (DatasetStructureReferenceBean structurereference : parent.getHeader().getStructures()) {
            if (!structurereference.getId().equals(createdFrom.getStructureRef())) continue;
            this._structureRef = new CrossReferenceBeanImpl((SDMXBean)this, structurereference.getStructureReference());
            break;
        }
        if (createdFrom.getNameList() != null) {
            this._names = TextTypeUtil.wrapTextTypeV21(createdFrom.getNameList(), this);
        }
        if (createdFrom.getReportingBeginDate() != null) {
            this._reportingBeginDate = new SdmxDateImpl(createdFrom.getReportingBeginDate().getTime(), TIME_FORMAT.DATE_TIME);
        }
        if (createdFrom.getReportingEndDate() != null) {
            this._reportingEndDate = new SdmxDateImpl(createdFrom.getReportingEndDate().getTime(), TIME_FORMAT.DATE_TIME);
        }
        if (createdFrom.getPublicationYear() != null) {
            this._publicationYear = new SdmxDateImpl(createdFrom.getPublicationYear().getTime(), TIME_FORMAT.DATE_TIME);
        }
        if (createdFrom.getValidFromDate() != null) {
            this._validFromDate = new SdmxDateImpl(createdFrom.getValidFromDate().getTime(), TIME_FORMAT.DATE_TIME);
        }
        if (createdFrom.getValidToDate() != null) {
            this._validToDate = new SdmxDateImpl(createdFrom.getValidToDate().getTime(), TIME_FORMAT.DATE_TIME);
        }
        this._publicationPeriod = createdFrom.getPublicationPeriod();
        if (createdFrom.getDataProvider() != null) {
            this._dataProviderReference = RefUtil.createReference(this, createdFrom.getDataProvider());
        }
        if (ObjectUtil.validCollection(createdFrom.getReportList())) {
            for (ReportType currentReport : createdFrom.getReportList()) {
                this._reports.add(new MetadataReportBeanImpl(this, currentReport));
            }
        }
        this.validate();
    }

    private void validate() throws SdmxSemmanticException {
        String setId = this.getSetId();
        if (setId == null) {
            setId = "";
        }
        if (!ObjectUtil.validCollection(this._reports)) {
            throw new SdmxSemmanticException("Metadata Set " + setId + " requires at least one Report");
        }
        if (this._structureRef == null) {
            throw new SdmxSemmanticException("Metadata Set " + setId + " requires a reference to an MSD");
        }
        if (this._structureRef.getTargetReference() != SDMX_STRUCTURE_TYPE.MSD) {
            throw new SdmxSemmanticException("Metadata Set " + setId + " reference must be a reference to an MSD");
        }
    }

    @Override
    public List<MetadataSetBean> splitReports() {
        ArrayList<MetadataSetBean> returnList = new ArrayList<MetadataSetBean>();
        for (MetadataReportBean reportBean : this._reports) {
            returnList.add(new MetadataSetBeanImpl(this, reportBean));
        }
        return returnList;
    }

    @Override
    public List<TextTypeWrapper> getNames() {
        return this._names;
    }

    @Override
    public String getSetId() {
        return this._setId;
    }

    @Override
    public CrossReferenceBean getMsdReference() {
        return this._structureRef;
    }

    @Override
    public SdmxDate getPublicationYear() {
        return this._publicationYear;
    }

    @Override
    public Object getPublicationPeriod() {
        return this._publicationPeriod;
    }

    @Override
    public CrossReferenceBean getDataProviderReference() {
        return this._dataProviderReference;
    }

    @Override
    public SdmxDate getReportingBeginDate() {
        return this._reportingBeginDate;
    }

    @Override
    public SdmxDate getReportingEndDate() {
        return this._reportingEndDate;
    }

    @Override
    public SdmxDate getValidFromDate() {
        return this._validFromDate;
    }

    @Override
    public SdmxDate getValidToDate() {
        return this._validToDate;
    }

    @Override
    public List<MetadataReportBean> getReports() {
        return new ArrayList<MetadataReportBean>(this._reports);
    }

    @Override
    protected Set<SDMXBean> getCompositesInternal() {
        HashSet<SDMXBean> composites = new HashSet<SDMXBean>();
        super.addToCompositeSet(this._names, composites);
        super.addToCompositeSet(this._reports, composites);
        return composites;
    }
}

