/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.metadata;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sdmx.resources.sdmxml.schemas.v21.common.ComponentValueSetType;
import org.sdmx.resources.sdmxml.schemas.v21.metadata.generic.ReferenceValueType;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.model.base.SdmxDate;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.reference.CrossReferenceBean;
import org.sdmxsource.sdmx.api.model.metadata.DataKeyBean;
import org.sdmxsource.sdmx.api.model.metadata.ReferenceValueBean;
import org.sdmxsource.sdmx.api.model.metadata.TargetBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.SDMXBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.SdmxDateImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.metadata.DataKeyBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.util.RefUtil;
import org.sdmxsource.util.ObjectUtil;

public class ReferenceValueBeanImpl
extends SDMXBeanImpl
implements ReferenceValueBean {
    private static final long serialVersionUID = 2865110943018956204L;
    private String id;
    private String datasetId;
    private CrossReferenceBean identifiableReference;
    private CrossReferenceBean constraintReference;
    private List<DataKeyBean> dataKeys = new ArrayList<DataKeyBean>();
    private SdmxDate reportPeriod;

    public ReferenceValueBeanImpl(TargetBean parent, ReferenceValueType type) {
        super(SDMX_STRUCTURE_TYPE.METADATA_REFERENCE_VALUE, (SDMXBean)parent);
        this.id = type.getId();
        if (type.getConstraintContentReference() != null) {
            this.constraintReference = RefUtil.createReference(this, type.getConstraintContentReference());
        }
        if (type.getObjectReference() != null) {
            this.identifiableReference = RefUtil.createReference(this, type.getObjectReference());
        }
        if (type.getDataSetReference() != null) {
            this.datasetId = type.getDataSetReference().getID();
            this.identifiableReference = RefUtil.createReference(this, type.getDataSetReference().getDataProvider());
        }
        if (type.getDataKey() != null) {
            for (ComponentValueSetType cvst : type.getDataKey().getKeyValueList()) {
                this.dataKeys.add(new DataKeyBeanImpl(this, cvst));
            }
        }
        if (type.getReportPeriod() != null) {
            this.reportPeriod = new SdmxDateImpl((String)type.getReportPeriod());
        }
        this.validate();
    }

    private void validate() {
        if (!ObjectUtil.validString(this.id)) {
            throw new SdmxSemmanticException("Metadata Report must have an Id");
        }
        if (ObjectUtil.validString(this.datasetId)) {
            if (this.identifiableReference != null) {
                throw new SdmxSemmanticException("Reference Value can only contain one target, a datakey, dataset, report period, or an identifiable.  '" + this.id + "' references both a dataset, and an Identifiable");
            }
            if (this.dataKeys.size() > 0) {
                throw new SdmxSemmanticException("Reference Value can only contain one target, a datakey, dataset, report period, or an identifiable.  '" + this.id + "' references both a dataset, and a DataKey");
            }
            if (this.reportPeriod != null) {
                throw new SdmxSemmanticException("Reference Value can only contain one target, a datakey, dataset, report period, or an identifiable.  '" + this.id + "' references both a dataset, and a Report Period");
            }
            if (this.constraintReference != null) {
                throw new SdmxSemmanticException("Reference Value can only contain one target, a datakey, dataset, report period, or an identifiable.  '" + this.id + "' references both a dataset, and a Constraint");
            }
        } else if (this.dataKeys.size() > 0) {
            if (this.identifiableReference != null) {
                throw new SdmxSemmanticException("Reference Value can only contain one target, a datakey, dataset, report period, or an identifiable.  '" + this.id + "' references both a DataKey, and an Identifiable");
            }
            if (ObjectUtil.validString(this.datasetId)) {
                throw new SdmxSemmanticException("Reference Value can only contain one target, a datakey, dataset, report period, or an identifiable.  '" + this.id + "' references both a DataKey, and a dataset");
            }
            if (this.reportPeriod != null) {
                throw new SdmxSemmanticException("Reference Value can only contain one target, a datakey, dataset, report period, or an identifiable.  '" + this.id + "' references both a DataKey, and a Report Period");
            }
            if (this.constraintReference != null) {
                throw new SdmxSemmanticException("Reference Value can only contain one target, a datakey, dataset, report period, or an identifiable.  '" + this.id + "' references both a DataKey, and a Constraint");
            }
        } else if (this.identifiableReference != null) {
            if (this.dataKeys.size() > 0) {
                throw new SdmxSemmanticException("Reference Value can only contain one target, a datakey, dataset, report period, or an identifiable.  '" + this.id + "' references both an Identifiable, and a DataKey");
            }
            if (ObjectUtil.validString(this.datasetId)) {
                throw new SdmxSemmanticException("Reference Value can only contain one target, a datakey, dataset, report period, or an identifiable.  '" + this.id + "' references both an Identifiable, and a dataset");
            }
            if (this.reportPeriod != null) {
                throw new SdmxSemmanticException("Reference Value can only contain one target, a datakey, dataset, report period, or an identifiable.  '" + this.id + "' references both an Identifiable, and a Report Period");
            }
            if (this.constraintReference != null) {
                throw new SdmxSemmanticException("Reference Value can only contain one target, a datakey, dataset, report period, or an identifiable.  '" + this.id + "' references both an Identifiable, and a Constraint");
            }
        } else if (this.reportPeriod != null) {
            if (this.identifiableReference != null) {
                throw new SdmxSemmanticException("Reference Value can only contain one target, a datakey, dataset, report period, or an identifiable.  '" + this.id + "' references both a Report Period, and an Identifiable");
            }
            if (this.dataKeys.size() > 0) {
                throw new SdmxSemmanticException("Reference Value can only contain one target, a datakey, dataset, report period, or an identifiable.  '" + this.id + "' references both a Report Period, and a DataKey");
            }
            if (ObjectUtil.validString(this.datasetId)) {
                throw new SdmxSemmanticException("Reference Value can only contain one target, a datakey, dataset, report period, or an identifiable.  '" + this.id + "' references both a Report Period, and a dataset");
            }
            if (this.constraintReference != null) {
                throw new SdmxSemmanticException("Reference Value can only contain one target, a datakey, dataset, report period, or an identifiable.  '" + this.id + "' references both a Report Period, and a Constraint");
            }
        } else if (this.constraintReference != null) {
            if (this.identifiableReference != null) {
                throw new SdmxSemmanticException("Reference Value can only contain one target, a datakey, dataset, report period, or an identifiable.  '" + this.id + "' references both a Constraint, and an Identifiable");
            }
            if (ObjectUtil.validString(this.datasetId)) {
                throw new SdmxSemmanticException("Reference Value can only contain one target, a datakey, dataset, report period, or an identifiable.  '" + this.id + "' references both a Constraint, and a dataset");
            }
            if (this.dataKeys.size() > 0) {
                throw new SdmxSemmanticException("Reference Value can only contain one target, a datakey, dataset, report period, or an identifiable.  '" + this.id + "' references both a Constraint, and a DataKey");
            }
            if (this.reportPeriod != null) {
                throw new SdmxSemmanticException("Reference Value can only contain one target, a datakey, dataset, report period, or an identifiable.  '" + this.id + "' references both a Constraint, and a Report Period");
            }
        } else {
            throw new SdmxSemmanticException("Metadata Reference Value must referenece either a datakey, dataset, report period, or an identifiable");
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public ReferenceValueBean.TARGET_TYPE getTargetType() {
        if (this.constraintReference != null) {
            return ReferenceValueBean.TARGET_TYPE.CONSTRAINT;
        }
        if (this.identifiableReference != null) {
            return ReferenceValueBean.TARGET_TYPE.IDENTIFIABLE;
        }
        if (ObjectUtil.validString(this.datasetId)) {
            return ReferenceValueBean.TARGET_TYPE.DATASET;
        }
        if (this.dataKeys.size() > 0) {
            return ReferenceValueBean.TARGET_TYPE.DATA_KEY;
        }
        if (this.reportPeriod != null) {
            return ReferenceValueBean.TARGET_TYPE.REPORT_PERIOD;
        }
        throw new RuntimeException("Reference value is not referencing anything");
    }

    @Override
    public String getDatasetId() {
        return this.datasetId;
    }

    @Override
    public SdmxDate getReportPeriod() {
        return this.reportPeriod;
    }

    @Override
    public CrossReferenceBean getIdentifiableReference() {
        return this.identifiableReference;
    }

    @Override
    public CrossReferenceBean getContentConstraintReference() {
        return this.constraintReference;
    }

    @Override
    public boolean isDatakeyReference() {
        return this.dataKeys.size() > 0;
    }

    @Override
    public boolean isContentConstriantReference() {
        return this.constraintReference != null;
    }

    @Override
    public List<DataKeyBean> getDataKeys() {
        return new ArrayList<DataKeyBean>(this.dataKeys);
    }

    @Override
    public boolean isDatasetReference() {
        return ObjectUtil.validString(this.datasetId);
    }

    @Override
    public boolean isIdentifiableReference() {
        return !this.isDatasetReference() && this.identifiableReference != null;
    }

    @Override
    protected Set<SDMXBean> getCompositesInternal() {
        HashSet<SDMXBean> composites = new HashSet<SDMXBean>();
        super.addToCompositeSet(this.dataKeys, composites);
        return composites;
    }
}

