/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.mutable.base;

import java.util.ArrayList;
import java.util.List;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.model.SdmxReader;
import org.sdmxsource.sdmx.api.model.beans.base.AnnotationBean;
import org.sdmxsource.sdmx.api.model.beans.base.TextTypeWrapper;
import org.sdmxsource.sdmx.api.model.mutable.base.AnnotationMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.base.TextTypeWrapperMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.base.MutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.base.TextTypeWrapperMutableBeanImpl;

public class AnnotationMutableBeanImpl
extends MutableBeanImpl
implements AnnotationMutableBean {
    private static final long serialVersionUID = 1L;
    private String id;
    private String title;
    private String type;
    private String uri;
    private List<TextTypeWrapperMutableBean> text;

    public AnnotationMutableBeanImpl() {
        super(SDMX_STRUCTURE_TYPE.ANNOTATION);
    }

    public AnnotationMutableBeanImpl(AnnotationBean annotation) {
        super(annotation);
        this.id = annotation.getId();
        this.title = annotation.getTitle();
        this.type = annotation.getType();
        if (annotation.getUri() != null) {
            this.uri = annotation.getUri().toString();
        }
        if (annotation.getText() != null) {
            this.text = new ArrayList<TextTypeWrapperMutableBean>();
            for (TextTypeWrapper currentTextType : annotation.getText()) {
                this.text.add(new TextTypeWrapperMutableBeanImpl(currentTextType));
            }
        }
    }

    public AnnotationMutableBeanImpl(SdmxReader reader) {
        super(SDMX_STRUCTURE_TYPE.ANNOTATION);
        this.id = reader.getAttributeValue("id", false);
        reader.moveNextElement();
        while (this.processReader(reader)) {
            reader.moveNextElement();
        }
    }

    protected boolean processReader(SdmxReader reader) {
        if (reader.getCurrentElement().equals("AnnotationType")) {
            this.type = reader.getCurrentElementValue();
            return true;
        }
        if (reader.getCurrentElement().equals("AnnotationTitle")) {
            this.title = reader.getCurrentElementValue();
            return true;
        }
        if (reader.getCurrentElement().equals("AnnotationText")) {
            this.addText(reader.getAttributeValue("lang", false), reader.getCurrentElementValue());
            return true;
        }
        if (reader.getCurrentElement().equals("AnnotationURL")) {
            this.uri = reader.getCurrentElementValue();
            return true;
        }
        return false;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String value) {
        this.id = value;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    @Override
    public void setUri(String uri) {
        this.uri = uri;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public List<TextTypeWrapperMutableBean> getText() {
        return this.text;
    }

    @Override
    public void setText(List<TextTypeWrapperMutableBean> text) {
        this.text = text;
    }

    @Override
    public void addText(TextTypeWrapperMutableBean text) {
        if (this.text == null) {
            this.text = new ArrayList<TextTypeWrapperMutableBean>();
        }
        this.text.add(text);
    }

    @Override
    public void addText(String locale, String text) {
        if (this.text == null) {
            this.text = new ArrayList<TextTypeWrapperMutableBean>();
        }
        TextTypeWrapperMutableBeanImpl tt = new TextTypeWrapperMutableBeanImpl();
        tt.setLocale(locale);
        tt.setValue(text);
        this.text.add(tt);
    }
}

