/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.mutable.codelist;

import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.model.SdmxReader;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodeBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodelistBean;
import org.sdmxsource.sdmx.api.model.mutable.codelist.CodeMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.codelist.CodelistMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.codelist.CodelistBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.base.ItemSchemeMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.codelist.CodeMutableBeanImpl;
import org.sdmxsource.util.ObjectUtil;

public class CodelistMutableBeanImpl
extends ItemSchemeMutableBeanImpl<CodeMutableBean>
implements CodelistMutableBean {
    private static final long serialVersionUID = 1L;

    public CodelistMutableBeanImpl() {
        super(SDMX_STRUCTURE_TYPE.CODE_LIST);
    }

    @Override
    public CodeMutableBean createItem(String id, String name) {
        CodeMutableBeanImpl code = new CodeMutableBeanImpl();
        code.setId(id);
        code.addName("en", name);
        this.addItem(code);
        return code;
    }

    public CodelistMutableBeanImpl(SdmxReader reader) {
        super(SDMX_STRUCTURE_TYPE.CODE_LIST);
        this.validateRootElement(reader);
        this.buildMaintainableAttributes(reader);
        reader.moveNextElement();
        while (this.processReader(reader)) {
            reader.moveNextElement();
        }
    }

    @Override
    protected boolean processReader(SdmxReader reader) {
        if (super.processReader(reader)) {
            return true;
        }
        if (reader.getCurrentElement().equals("Code")) {
            this.processCodes(reader);
        }
        return false;
    }

    private void processCodes(SdmxReader reader) {
        while (reader.getCurrentElement().equals("Code")) {
            CodeMutableBeanImpl newCode = new CodeMutableBeanImpl(reader);
            if (newCode.getNames() == null || newCode.getNames().size() == 0 || !ObjectUtil.validString(newCode.getNames().get(0).getValue())) {
                System.out.println("HERE");
            }
            this.addItem(newCode);
        }
    }

    private SDMX_STRUCTURE_TYPE validateRootElement(SdmxReader reader) {
        if (!reader.getCurrentElement().equals("Codelist")) {
            throw new SdmxSemmanticException("Can not construct codelist - expecting 'Codelist' Element in SDMX, actual element:" + reader.getCurrentElementValue());
        }
        return SDMX_STRUCTURE_TYPE.CODE_LIST;
    }

    public CodelistMutableBeanImpl(SDMX_STRUCTURE_TYPE structureType) {
        super(structureType);
    }

    @Override
    public CodeMutableBean getCodeById(String id) {
        for (CodeMutableBean currentCode : this.getItems()) {
            if (!currentCode.getId().equals(id)) continue;
            return currentCode;
        }
        return null;
    }

    public CodelistMutableBeanImpl(CodelistBean bean) {
        super(bean);
        if (bean.getItems() != null) {
            for (CodeBean currentBean : bean.getItems()) {
                this.addItem(new CodeMutableBeanImpl(currentBean));
            }
        }
    }

    @Override
    public CodelistBean getImmutableInstance() {
        return new CodelistBeanImpl(this);
    }

    @Override
    public void setIsPartial(boolean isPartial) {
        super.setPartial(isPartial);
    }
}

