/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.superbeans.metadata;

import java.util.ArrayList;
import java.util.List;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.manager.retrieval.IdentifiableRetrievalManager;
import org.sdmxsource.sdmx.api.model.base.SdmxDate;
import org.sdmxsource.sdmx.api.model.beans.base.DataProviderBean;
import org.sdmxsource.sdmx.api.model.beans.metadatastructure.MetadataStructureDefinitionBean;
import org.sdmxsource.sdmx.api.model.beans.metadatastructure.ReportStructureBean;
import org.sdmxsource.sdmx.api.model.metadata.MetadataReportBean;
import org.sdmxsource.sdmx.api.model.metadata.MetadataSetBean;
import org.sdmxsource.sdmx.api.model.superbeans.metadata.MetadataReportSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.metadata.MetadataSetSuperBean;
import org.sdmxsource.sdmx.sdmxbeans.model.superbeans.base.SuperBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.superbeans.metadata.MetadataReportSuperBeanImpl;

public class MetadataSetSuperBeanImpl
extends SuperBeanImpl
implements MetadataSetSuperBean {
    private static final long serialVersionUID = 7206438606756205144L;
    private MetadataStructureDefinitionBean metadataStructure;
    private DataProviderBean dataProvider;
    private List<MetadataReportSuperBean> reports = new ArrayList<MetadataReportSuperBean>();
    private MetadataSetBean builtFrom;

    public MetadataSetSuperBeanImpl(MetadataSetBean builtFrom, IdentifiableRetrievalManager retrievalManager) {
        super(builtFrom);
        this.builtFrom = builtFrom;
        this.metadataStructure = retrievalManager.getIdentifiableBean(builtFrom.getMsdReference(), MetadataStructureDefinitionBean.class);
        if (builtFrom.getDataProviderReference() != null) {
            this.dataProvider = retrievalManager.getIdentifiableBean(builtFrom.getDataProviderReference(), DataProviderBean.class);
        }
        if (builtFrom.getReports() != null) {
            for (MetadataReportBean currentMR : builtFrom.getReports()) {
                ReportStructureBean rs = this.getReportStructure(currentMR, this.metadataStructure.getReportStructures());
                this.reports.add(new MetadataReportSuperBeanImpl(rs, currentMR, retrievalManager));
            }
        }
    }

    private ReportStructureBean getReportStructure(MetadataReportBean currentMR, List<ReportStructureBean> reportStructures) {
        for (ReportStructureBean currentRS : reportStructures) {
            if (!currentRS.getId().equals(currentMR.getId())) continue;
            return currentRS;
        }
        throw new SdmxSemmanticException("Can not find reference to report structure with id " + currentMR.getId());
    }

    @Override
    public SdmxDate getReportingBeginDate() {
        return this.builtFrom.getReportingBeginDate();
    }

    @Override
    public SdmxDate getReportingEndDate() {
        return this.builtFrom.getReportingEndDate();
    }

    @Override
    public SdmxDate getValidFromDate() {
        return this.builtFrom.getValidFromDate();
    }

    @Override
    public SdmxDate getValidToDate() {
        return this.builtFrom.getValidToDate();
    }

    @Override
    public SdmxDate getPublicationYear() {
        return this.builtFrom.getPublicationYear();
    }

    @Override
    public Object getPublicationPeriod() {
        return this.builtFrom.getPublicationPeriod();
    }

    @Override
    public MetadataStructureDefinitionBean getMetadataStructure() {
        return this.metadataStructure;
    }

    @Override
    public DataProviderBean getDataProvider() {
        return this.dataProvider;
    }

    @Override
    public List<MetadataReportSuperBean> getReports() {
        return new ArrayList<MetadataReportSuperBean>(this.reports);
    }

    @Override
    public MetadataSetBean getBuiltFrom() {
        return this.builtFrom;
    }
}

