/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.query.impl;

import java.util.ArrayList;
import java.util.List;
import org.sdmx.resources.sdmxml.schemas.v20.message.QueryMessageType;
import org.sdmx.resources.sdmxml.schemas.v20.query.CategorySchemeWhereType;
import org.sdmx.resources.sdmxml.schemas.v20.query.CodelistWhereType;
import org.sdmx.resources.sdmxml.schemas.v20.query.ConceptSchemeWhereType;
import org.sdmx.resources.sdmxml.schemas.v20.query.ConceptWhereType;
import org.sdmx.resources.sdmxml.schemas.v20.query.DataflowWhereType;
import org.sdmx.resources.sdmxml.schemas.v20.query.HierarchicalCodelistWhereType;
import org.sdmx.resources.sdmxml.schemas.v20.query.KeyFamilyWhereType;
import org.sdmx.resources.sdmxml.schemas.v20.query.MetadataflowWhereType;
import org.sdmx.resources.sdmxml.schemas.v20.query.OrganisationSchemeWhereType;
import org.sdmx.resources.sdmxml.schemas.v20.query.ProcessWhereType;
import org.sdmx.resources.sdmxml.schemas.v20.query.QueryType;
import org.sdmx.resources.sdmxml.schemas.v20.query.ReportingTaxonomyWhereType;
import org.sdmx.resources.sdmxml.schemas.v20.query.StructureSetWhereType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.AgencyRefType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.CategorySchemeRefType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.CodelistRefType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.ConceptSchemeRefType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.DataProviderRefType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.DataflowRefType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.HierarchicalCodelistRefType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.KeyFamilyRefType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.MetadataStructureRefType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.MetadataflowRefType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.OrganisationSchemeRefType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.ProcessRefType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.ProvisionAgreementRefType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.QueryProvisioningRequestType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.QueryRegistrationRequestType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.QueryStructureRequestType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.ReportingTaxonomyRefType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.StructureSetRefType;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.SdmxNotImplementedException;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.util.beans.reference.StructureReferenceBeanImpl;
import org.sdmxsource.util.ObjectUtil;
import org.springframework.stereotype.Service;

@Service
public class QueryBeanBuilderV2 {
    public List<StructureReferenceBean> build(QueryStructureRequestType queryStructureRequests) {
        String version;
        String maintId;
        String agencyId;
        String urn;
        ArrayList<StructureReferenceBean> reutrnList = new ArrayList<StructureReferenceBean>();
        if (queryStructureRequests.getAgencyRefList() != null) {
            for (AgencyRefType agencyRefType : queryStructureRequests.getAgencyRefList()) {
                urn = agencyRefType.getURN();
                if (ObjectUtil.validString(urn)) {
                    reutrnList.add(new StructureReferenceBeanImpl(urn));
                    continue;
                }
                agencyId = agencyRefType.getAgencyID();
                maintId = agencyRefType.getOrganisationSchemeID();
                version = agencyRefType.getOrganisationSchemeAgencyID();
                reutrnList.add(new StructureReferenceBeanImpl(agencyId, maintId, version, SDMX_STRUCTURE_TYPE.AGENCY, new String[0]));
            }
        }
        if (queryStructureRequests.getCategorySchemeRefList() != null) {
            for (CategorySchemeRefType categorySchemeRefType : queryStructureRequests.getCategorySchemeRefList()) {
                urn = categorySchemeRefType.getURN();
                if (ObjectUtil.validString(urn)) {
                    reutrnList.add(new StructureReferenceBeanImpl(urn));
                    continue;
                }
                agencyId = categorySchemeRefType.getAgencyID();
                maintId = categorySchemeRefType.getCategorySchemeID();
                version = categorySchemeRefType.getVersion();
                reutrnList.add(new StructureReferenceBeanImpl(agencyId, maintId, version, SDMX_STRUCTURE_TYPE.CATEGORY_SCHEME, new String[0]));
            }
        }
        if (queryStructureRequests.getCodelistRefList() != null) {
            for (CodelistRefType codelistRefType : queryStructureRequests.getCodelistRefList()) {
                urn = codelistRefType.getURN();
                if (ObjectUtil.validString(urn)) {
                    reutrnList.add(new StructureReferenceBeanImpl(urn));
                    continue;
                }
                agencyId = codelistRefType.getAgencyID();
                maintId = codelistRefType.getCodelistID();
                version = codelistRefType.getVersion();
                reutrnList.add(new StructureReferenceBeanImpl(agencyId, maintId, version, SDMX_STRUCTURE_TYPE.CODE_LIST, new String[0]));
            }
        }
        if (queryStructureRequests.getConceptSchemeRefList() != null) {
            for (ConceptSchemeRefType conceptSchemeRefType : queryStructureRequests.getConceptSchemeRefList()) {
                urn = conceptSchemeRefType.getURN();
                if (ObjectUtil.validString(urn)) {
                    reutrnList.add(new StructureReferenceBeanImpl(urn));
                    continue;
                }
                agencyId = conceptSchemeRefType.getAgencyID();
                maintId = conceptSchemeRefType.getConceptSchemeID();
                version = conceptSchemeRefType.getVersion();
                reutrnList.add(new StructureReferenceBeanImpl(agencyId, maintId, version, SDMX_STRUCTURE_TYPE.CONCEPT_SCHEME, new String[0]));
            }
        }
        if (queryStructureRequests.getDataflowRefList() != null) {
            for (DataflowRefType dataflowRefType : queryStructureRequests.getDataflowRefList()) {
                reutrnList.add(this.buildDataflowQuery(dataflowRefType));
            }
        }
        if (queryStructureRequests.getDataProviderRefList() != null) {
            for (DataProviderRefType dataProviderRefType : queryStructureRequests.getDataProviderRefList()) {
                urn = dataProviderRefType.getURN();
                if (ObjectUtil.validString(urn)) {
                    reutrnList.add(new StructureReferenceBeanImpl(urn));
                    continue;
                }
                agencyId = dataProviderRefType.getOrganisationSchemeAgencyID();
                maintId = dataProviderRefType.getOrganisationSchemeAgencyID();
                version = dataProviderRefType.getVersion();
                String id = dataProviderRefType.getDataProviderID();
                reutrnList.add(new StructureReferenceBeanImpl(agencyId, maintId, version, SDMX_STRUCTURE_TYPE.DATA_PROVIDER, id));
            }
        }
        if (queryStructureRequests.getHierarchicalCodelistRefList() != null) {
            for (HierarchicalCodelistRefType hierarchicalCodelistRefType : queryStructureRequests.getHierarchicalCodelistRefList()) {
                urn = hierarchicalCodelistRefType.getURN();
                if (ObjectUtil.validString(urn)) {
                    reutrnList.add(new StructureReferenceBeanImpl(urn));
                    continue;
                }
                agencyId = hierarchicalCodelistRefType.getAgencyID();
                maintId = hierarchicalCodelistRefType.getHierarchicalCodelistID();
                version = hierarchicalCodelistRefType.getVersion();
                reutrnList.add(new StructureReferenceBeanImpl(agencyId, maintId, version, SDMX_STRUCTURE_TYPE.HIERARCHICAL_CODELIST, new String[0]));
            }
        }
        if (queryStructureRequests.getKeyFamilyRefList() != null) {
            for (KeyFamilyRefType keyFamilyRefType : queryStructureRequests.getKeyFamilyRefList()) {
                urn = keyFamilyRefType.getURN();
                if (ObjectUtil.validString(urn)) {
                    reutrnList.add(new StructureReferenceBeanImpl(urn));
                    continue;
                }
                agencyId = keyFamilyRefType.getAgencyID();
                maintId = keyFamilyRefType.getKeyFamilyID();
                version = keyFamilyRefType.getVersion();
                reutrnList.add(new StructureReferenceBeanImpl(agencyId, maintId, version, SDMX_STRUCTURE_TYPE.DSD, new String[0]));
            }
        }
        if (queryStructureRequests.getMetadataflowRefList() != null) {
            for (MetadataflowRefType metadataflowRefType : queryStructureRequests.getMetadataflowRefList()) {
                urn = metadataflowRefType.getURN();
                if (ObjectUtil.validString(urn)) {
                    reutrnList.add(new StructureReferenceBeanImpl(urn));
                    continue;
                }
                agencyId = metadataflowRefType.getAgencyID();
                maintId = metadataflowRefType.getMetadataflowID();
                version = metadataflowRefType.getVersion();
                reutrnList.add(new StructureReferenceBeanImpl(agencyId, maintId, version, SDMX_STRUCTURE_TYPE.METADATA_FLOW, new String[0]));
            }
        }
        if (queryStructureRequests.getMetadataStructureRefList() != null) {
            for (MetadataStructureRefType metadataStructureRefType : queryStructureRequests.getMetadataStructureRefList()) {
                urn = metadataStructureRefType.getURN();
                if (ObjectUtil.validString(urn)) {
                    reutrnList.add(new StructureReferenceBeanImpl(urn));
                    continue;
                }
                agencyId = metadataStructureRefType.getAgencyID();
                maintId = metadataStructureRefType.getMetadataStructureID();
                version = metadataStructureRefType.getVersion();
                reutrnList.add(new StructureReferenceBeanImpl(agencyId, maintId, version, SDMX_STRUCTURE_TYPE.MSD, new String[0]));
            }
        }
        if (queryStructureRequests.getOrganisationSchemeRefList() != null) {
            for (OrganisationSchemeRefType organisationSchemeRefType : queryStructureRequests.getOrganisationSchemeRefList()) {
                urn = organisationSchemeRefType.getURN();
                if (ObjectUtil.validString(urn)) {
                    reutrnList.add(new StructureReferenceBeanImpl(urn));
                    continue;
                }
                agencyId = organisationSchemeRefType.getAgencyID();
                maintId = organisationSchemeRefType.getOrganisationSchemeID();
                version = organisationSchemeRefType.getVersion();
                reutrnList.add(new StructureReferenceBeanImpl(agencyId, maintId, version, SDMX_STRUCTURE_TYPE.AGENCY_SCHEME, new String[0]));
                reutrnList.add(new StructureReferenceBeanImpl(agencyId, maintId, version, SDMX_STRUCTURE_TYPE.DATA_CONSUMER_SCHEME, new String[0]));
                reutrnList.add(new StructureReferenceBeanImpl(agencyId, maintId, version, SDMX_STRUCTURE_TYPE.DATA_PROVIDER_SCHEME, new String[0]));
            }
        }
        if (queryStructureRequests.getProcessRefList() != null) {
            for (ProcessRefType processRefType : queryStructureRequests.getProcessRefList()) {
                urn = processRefType.getURN();
                if (ObjectUtil.validString(urn)) {
                    reutrnList.add(new StructureReferenceBeanImpl(urn));
                    continue;
                }
                agencyId = processRefType.getAgencyID();
                maintId = processRefType.getProcessID();
                version = processRefType.getVersion();
                reutrnList.add(new StructureReferenceBeanImpl(agencyId, maintId, version, SDMX_STRUCTURE_TYPE.PROCESS, new String[0]));
            }
        }
        if (queryStructureRequests.getReportingTaxonomyRefList() != null) {
            for (ReportingTaxonomyRefType reportingTaxonomyRefType : queryStructureRequests.getReportingTaxonomyRefList()) {
                urn = reportingTaxonomyRefType.getURN();
                if (ObjectUtil.validString(urn)) {
                    reutrnList.add(new StructureReferenceBeanImpl(urn));
                    continue;
                }
                agencyId = reportingTaxonomyRefType.getAgencyID();
                maintId = reportingTaxonomyRefType.getReportingTaxonomyID();
                version = reportingTaxonomyRefType.getVersion();
                reutrnList.add(new StructureReferenceBeanImpl(agencyId, maintId, version, SDMX_STRUCTURE_TYPE.REPORTING_TAXONOMY, new String[0]));
            }
        }
        if (queryStructureRequests.getStructureSetRefList() != null) {
            for (StructureSetRefType structureSetRefType : queryStructureRequests.getStructureSetRefList()) {
                urn = structureSetRefType.getURN();
                if (ObjectUtil.validString(urn)) {
                    reutrnList.add(new StructureReferenceBeanImpl(urn));
                    continue;
                }
                agencyId = structureSetRefType.getAgencyID();
                maintId = structureSetRefType.getStructureSetID();
                version = structureSetRefType.getVersion();
                reutrnList.add(new StructureReferenceBeanImpl(agencyId, maintId, version, SDMX_STRUCTURE_TYPE.STRUCTURE_SET, new String[0]));
            }
        }
        return reutrnList;
    }

    protected StructureReferenceBean buildDataflowQuery(DataflowRefType refType) {
        String urn = refType.getURN();
        if (ObjectUtil.validString(urn)) {
            return new StructureReferenceBeanImpl(urn);
        }
        String agencyId = refType.getAgencyID();
        String maintId = refType.getDataflowID();
        String version = refType.getVersion();
        return new StructureReferenceBeanImpl(agencyId, maintId, version, SDMX_STRUCTURE_TYPE.DATAFLOW, new String[0]);
    }

    public StructureReferenceBean build(QueryRegistrationRequestType queryRegistrationRequestType) {
        DataflowRefType dataflowRef = queryRegistrationRequestType.getDataflowRef();
        DataProviderRefType dataProviderRef = queryRegistrationRequestType.getDataProviderRef();
        MetadataflowRefType metadataflowRef = queryRegistrationRequestType.getMetadataflowRef();
        ProvisionAgreementRefType provRef = queryRegistrationRequestType.getProvisionAgreementRef();
        if (dataProviderRef != null) {
            if (ObjectUtil.validString(dataProviderRef.getURN())) {
                return new StructureReferenceBeanImpl(dataProviderRef.getURN());
            }
            String agencyId = dataProviderRef.getOrganisationSchemeAgencyID();
            String maintId = dataProviderRef.getOrganisationSchemeID();
            String version = dataProviderRef.getVersion();
            String id = dataProviderRef.getDataProviderID();
            return new StructureReferenceBeanImpl(agencyId, maintId, version, SDMX_STRUCTURE_TYPE.DATA_PROVIDER, id);
        }
        if (provRef != null) {
            if (ObjectUtil.validString(provRef.getURN())) {
                return new StructureReferenceBeanImpl(provRef.getURN());
            }
            throw new IllegalArgumentException("Version 2.0 query for registration by provision agreement must use the provision URN");
        }
        if (dataflowRef != null) {
            if (ObjectUtil.validString(dataflowRef.getURN())) {
                return new StructureReferenceBeanImpl(dataflowRef.getURN());
            }
            String agencyId = dataflowRef.getAgencyID();
            String maintId = dataflowRef.getDataflowID();
            String version = dataflowRef.getVersion();
            return new StructureReferenceBeanImpl(agencyId, maintId, version, SDMX_STRUCTURE_TYPE.DATAFLOW, new String[0]);
        }
        if (metadataflowRef != null) {
            if (ObjectUtil.validString(metadataflowRef.getURN())) {
                return new StructureReferenceBeanImpl(metadataflowRef.getURN());
            }
            String agencyId = metadataflowRef.getAgencyID();
            String maintId = metadataflowRef.getMetadataflowID();
            String version = metadataflowRef.getVersion();
            return new StructureReferenceBeanImpl(agencyId, maintId, version, SDMX_STRUCTURE_TYPE.METADATA_FLOW, new String[0]);
        }
        return null;
    }

    public StructureReferenceBean build(QueryProvisioningRequestType queryProvisionRequestType) {
        DataflowRefType dataflowRef = queryProvisionRequestType.getDataflowRef();
        DataProviderRefType dataProviderRef = queryProvisionRequestType.getDataProviderRef();
        MetadataflowRefType metadataflowRef = queryProvisionRequestType.getMetadataflowRef();
        ProvisionAgreementRefType provRef = queryProvisionRequestType.getProvisionAgreementRef();
        if (dataProviderRef != null) {
            if (ObjectUtil.validString(dataProviderRef.getURN())) {
                return new StructureReferenceBeanImpl(dataProviderRef.getURN());
            }
            String agencyId = dataProviderRef.getOrganisationSchemeAgencyID();
            String maintId = dataProviderRef.getOrganisationSchemeID();
            String version = dataProviderRef.getVersion();
            String id = dataProviderRef.getDataProviderID();
            return new StructureReferenceBeanImpl(agencyId, maintId, version, SDMX_STRUCTURE_TYPE.DATA_PROVIDER, id);
        }
        if (provRef != null && ObjectUtil.validString(provRef.getURN())) {
            return new StructureReferenceBeanImpl(provRef.getURN());
        }
        if (dataflowRef != null) {
            if (ObjectUtil.validString(dataflowRef.getURN())) {
                return new StructureReferenceBeanImpl(dataflowRef.getURN());
            }
            String agencyId = dataflowRef.getAgencyID();
            String maintId = dataflowRef.getDataflowID();
            String version = dataflowRef.getVersion();
            return new StructureReferenceBeanImpl(agencyId, maintId, version, SDMX_STRUCTURE_TYPE.DATAFLOW, new String[0]);
        }
        if (metadataflowRef != null) {
            if (ObjectUtil.validString(metadataflowRef.getURN())) {
                return new StructureReferenceBeanImpl(metadataflowRef.getURN());
            }
            String agencyId = metadataflowRef.getAgencyID();
            String maintId = metadataflowRef.getMetadataflowID();
            String version = metadataflowRef.getVersion();
            return new StructureReferenceBeanImpl(agencyId, maintId, version, SDMX_STRUCTURE_TYPE.METADATA_FLOW, new String[0]);
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, "At version 2.0 provisions can only be queryies by Provision URN, Dataflow Ref, Data Provider Ref or Metadata Flow Ref");
    }

    public List<StructureReferenceBean> build(QueryMessageType queryMessage) {
        ArrayList<StructureReferenceBean> reutrnList = new ArrayList<StructureReferenceBean>();
        if (queryMessage.getQuery() != null) {
            StructureReferenceBeanImpl refBean;
            SDMX_STRUCTURE_TYPE structType;
            String version;
            String maintId;
            String agencyId;
            QueryType queryType = queryMessage.getQuery();
            if (queryType.getAgencyWhereList() != null && ObjectUtil.validCollection(queryMessage.getQuery().getAgencyWhereList())) {
                throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, "AgencyWhere");
            }
            if (queryType.getCategorySchemeWhereList() != null) {
                for (CategorySchemeWhereType categorySchemeWhereType : queryType.getCategorySchemeWhereList()) {
                    agencyId = categorySchemeWhereType.getAgencyID();
                    maintId = categorySchemeWhereType.getID();
                    version = categorySchemeWhereType.getVersion();
                    structType = SDMX_STRUCTURE_TYPE.CATEGORY_SCHEME;
                    refBean = new StructureReferenceBeanImpl(agencyId, maintId, version, structType, new String[0]);
                    reutrnList.add(refBean);
                }
            }
            if (queryType.getCodelistWhereList() != null) {
                for (CodelistWhereType codelistWhereType : queryType.getCodelistWhereList()) {
                    String codelistId = null;
                    if (codelistWhereType.getCodelist() != null) {
                        codelistId = codelistWhereType.getCodelist().getId();
                    }
                    String agencyId2 = codelistWhereType.getAgencyID();
                    String maintId2 = codelistId;
                    String version2 = codelistWhereType.getVersion();
                    SDMX_STRUCTURE_TYPE structType2 = SDMX_STRUCTURE_TYPE.CODE_LIST;
                    StructureReferenceBeanImpl refBean2 = new StructureReferenceBeanImpl(agencyId2, maintId2, version2, structType2, new String[0]);
                    reutrnList.add(refBean2);
                    if (codelistWhereType.getOr() != null) {
                        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, "CodelistWhere/Or");
                    }
                    if (codelistWhereType.getAnd() == null) continue;
                    throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, "CodelistWhere/And");
                }
            }
            if (queryType.getConceptSchemeWhereList() != null) {
                for (ConceptSchemeWhereType conceptSchemeWhereType : queryType.getConceptSchemeWhereList()) {
                    agencyId = conceptSchemeWhereType.getAgencyID();
                    maintId = conceptSchemeWhereType.getID();
                    version = conceptSchemeWhereType.getVersion();
                    structType = SDMX_STRUCTURE_TYPE.CONCEPT_SCHEME;
                    refBean = new StructureReferenceBeanImpl(agencyId, maintId, version, structType, new String[0]);
                    reutrnList.add(refBean);
                }
            }
            if (queryType.getConceptWhereList() != null) {
                for (ConceptWhereType conceptWhereType : queryType.getConceptWhereList()) {
                    agencyId = conceptWhereType.getAgencyID();
                    String conceptId = conceptWhereType.getConcept();
                    SDMX_STRUCTURE_TYPE structType3 = SDMX_STRUCTURE_TYPE.CONCEPT;
                    StructureReferenceBeanImpl refBean3 = new StructureReferenceBeanImpl(agencyId, "STANDALONE_CONCEPT_SCHEME", "1.0", structType3, conceptId);
                    reutrnList.add(refBean3);
                    if (conceptWhereType.getOr() != null) {
                        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, "ConceptWhere/Or");
                    }
                    if (conceptWhereType.getAnd() == null) continue;
                    throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, "ConceptWhere/And");
                }
            }
            if (queryType.getDataflowWhereList() != null) {
                for (DataflowWhereType dataflowWhereType : queryType.getDataflowWhereList()) {
                    agencyId = dataflowWhereType.getAgencyID();
                    maintId = dataflowWhereType.getID();
                    version = dataflowWhereType.getVersion();
                    structType = SDMX_STRUCTURE_TYPE.DATAFLOW;
                    refBean = new StructureReferenceBeanImpl(agencyId, maintId, version, structType, new String[0]);
                    reutrnList.add(refBean);
                }
            }
            if (queryType.getDataProviderWhereList() != null && queryType.getDataProviderWhereList().size() > 0) {
                throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, "DataProviderWhere");
            }
            if (queryType.getDataWhereList() != null && queryType.getDataWhereList().size() > 0) {
                throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, "DataWhere");
            }
            if (queryType.getHierarchicalCodelistWhereList() != null) {
                for (HierarchicalCodelistWhereType hierarchicalCodelistWhereType : queryType.getHierarchicalCodelistWhereList()) {
                    agencyId = hierarchicalCodelistWhereType.getAgencyID();
                    maintId = hierarchicalCodelistWhereType.getID();
                    version = hierarchicalCodelistWhereType.getVersion();
                    structType = SDMX_STRUCTURE_TYPE.HIERARCHICAL_CODELIST;
                    refBean = new StructureReferenceBeanImpl(agencyId, maintId, version, structType, new String[0]);
                    reutrnList.add(refBean);
                }
            }
            if (queryType.getKeyFamilyWhereList() != null) {
                for (KeyFamilyWhereType keyFamilyWhereType : queryType.getKeyFamilyWhereList()) {
                    agencyId = keyFamilyWhereType.getAgencyID();
                    maintId = keyFamilyWhereType.getKeyFamily();
                    version = keyFamilyWhereType.getVersion();
                    structType = SDMX_STRUCTURE_TYPE.DSD;
                    refBean = new StructureReferenceBeanImpl(agencyId, maintId, version, structType, new String[0]);
                    reutrnList.add(refBean);
                    if (keyFamilyWhereType.getOr() != null) {
                        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, "KeyFamilyWhere/Or");
                    }
                    if (keyFamilyWhereType.getAnd() != null) {
                        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, "KeyFamilyWhere/And");
                    }
                    if (keyFamilyWhereType.getDimension() != null) {
                        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, "KeyFamilyWhere/Dimension");
                    }
                    if (keyFamilyWhereType.getAttribute() != null) {
                        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, "KeyFamilyWhere/Attribute");
                    }
                    if (keyFamilyWhereType.getCodelist() != null) {
                        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, "KeyFamilyWhere/Codelist");
                    }
                    if (keyFamilyWhereType.getCategory() != null) {
                        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, "KeyFamilyWhere/Category");
                    }
                    if (keyFamilyWhereType.getConcept() == null) continue;
                    throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, "KeyFamilyWhere/Concept");
                }
            }
            if (queryType.getMetadataflowWhereList() != null) {
                for (MetadataflowWhereType metadataflowWhereType : queryType.getMetadataflowWhereList()) {
                    agencyId = metadataflowWhereType.getAgencyID();
                    maintId = metadataflowWhereType.getID();
                    version = metadataflowWhereType.getVersion();
                    structType = SDMX_STRUCTURE_TYPE.METADATA_FLOW;
                    refBean = new StructureReferenceBeanImpl(agencyId, maintId, version, structType, new String[0]);
                    reutrnList.add(refBean);
                }
            }
            if (queryType.getMetadataWhereList() != null && queryType.getMetadataWhereList().size() > 0) {
                throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, "DataWhere");
            }
            if (queryType.getOrganisationSchemeWhereList() != null) {
                for (OrganisationSchemeWhereType organisationSchemeWhereType : queryType.getOrganisationSchemeWhereList()) {
                    agencyId = organisationSchemeWhereType.getAgencyID();
                    maintId = organisationSchemeWhereType.getID();
                    version = organisationSchemeWhereType.getVersion();
                    structType = SDMX_STRUCTURE_TYPE.ORGANISATION_UNIT_SCHEME;
                    refBean = new StructureReferenceBeanImpl(agencyId, maintId, version, structType, new String[0]);
                    reutrnList.add(refBean);
                }
            }
            if (queryType.getProcessWhereList() != null) {
                for (ProcessWhereType processWhereType : queryType.getProcessWhereList()) {
                    agencyId = processWhereType.getAgencyID();
                    maintId = processWhereType.getID();
                    version = processWhereType.getVersion();
                    structType = SDMX_STRUCTURE_TYPE.PROCESS;
                    refBean = new StructureReferenceBeanImpl(agencyId, maintId, version, structType, new String[0]);
                    reutrnList.add(refBean);
                }
            }
            if (queryType.getStructureSetWhereList() != null) {
                for (StructureSetWhereType structureSetWhereType : queryType.getStructureSetWhereList()) {
                    agencyId = structureSetWhereType.getAgencyID();
                    maintId = structureSetWhereType.getID();
                    version = structureSetWhereType.getVersion();
                    structType = SDMX_STRUCTURE_TYPE.STRUCTURE_SET;
                    refBean = new StructureReferenceBeanImpl(agencyId, maintId, version, structType, new String[0]);
                    reutrnList.add(refBean);
                }
            }
            if (queryType.getReportingTaxonomyWhereList() != null) {
                for (ReportingTaxonomyWhereType reportingTaxonomyWhereType : queryType.getReportingTaxonomyWhereList()) {
                    agencyId = reportingTaxonomyWhereType.getAgencyID();
                    maintId = reportingTaxonomyWhereType.getID();
                    version = reportingTaxonomyWhereType.getVersion();
                    structType = SDMX_STRUCTURE_TYPE.REPORTING_TAXONOMY;
                    refBean = new StructureReferenceBeanImpl(agencyId, maintId, version, structType, new String[0]);
                    reutrnList.add(refBean);
                }
            }
        }
        return reutrnList;
    }
}

