/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.query.impl;

import java.util.ArrayList;
import java.util.List;
import org.sdmx.resources.sdmxml.schemas.v21.common.DataProviderReferenceType;
import org.sdmx.resources.sdmxml.schemas.v21.common.DataflowReferenceType;
import org.sdmx.resources.sdmxml.schemas.v21.common.MaintainableObjectTypeListType;
import org.sdmx.resources.sdmxml.schemas.v21.common.MetadataflowReferenceType;
import org.sdmx.resources.sdmxml.schemas.v21.common.ProvisionAgreementReferenceType;
import org.sdmx.resources.sdmxml.schemas.v21.common.TimePeriodRangeType;
import org.sdmx.resources.sdmxml.schemas.v21.common.TimeRangeValueType;
import org.sdmx.resources.sdmxml.schemas.v21.message.CategorisationQueryType;
import org.sdmx.resources.sdmxml.schemas.v21.message.ConstraintQueryType;
import org.sdmx.resources.sdmxml.schemas.v21.message.DataflowQueryType;
import org.sdmx.resources.sdmxml.schemas.v21.message.MetadataStructureQueryType;
import org.sdmx.resources.sdmxml.schemas.v21.message.MetadataflowQueryType;
import org.sdmx.resources.sdmxml.schemas.v21.message.ProcessQueryType;
import org.sdmx.resources.sdmxml.schemas.v21.message.StructuresQueryType;
import org.sdmx.resources.sdmxml.schemas.v21.query.AnnotationWhereType;
import org.sdmx.resources.sdmxml.schemas.v21.query.CategorySchemeQueryType;
import org.sdmx.resources.sdmxml.schemas.v21.query.CategorySchemeWhereType;
import org.sdmx.resources.sdmxml.schemas.v21.query.CodelistQueryType;
import org.sdmx.resources.sdmxml.schemas.v21.query.CodelistWhereType;
import org.sdmx.resources.sdmxml.schemas.v21.query.ConceptSchemeQueryType;
import org.sdmx.resources.sdmxml.schemas.v21.query.ConceptSchemeWhereType;
import org.sdmx.resources.sdmxml.schemas.v21.query.DataStructureQueryType;
import org.sdmx.resources.sdmxml.schemas.v21.query.HierarchicalCodelistQueryType;
import org.sdmx.resources.sdmxml.schemas.v21.query.ItemWhereType;
import org.sdmx.resources.sdmxml.schemas.v21.query.MaintainableWhereType;
import org.sdmx.resources.sdmxml.schemas.v21.query.OrganisationSchemeQueryType;
import org.sdmx.resources.sdmxml.schemas.v21.query.OrganisationSchemeWhereType;
import org.sdmx.resources.sdmxml.schemas.v21.query.ProvisionAgreementQueryType;
import org.sdmx.resources.sdmxml.schemas.v21.query.QueryIDType;
import org.sdmx.resources.sdmxml.schemas.v21.query.QueryNestedIDType;
import org.sdmx.resources.sdmxml.schemas.v21.query.QueryStringType;
import org.sdmx.resources.sdmxml.schemas.v21.query.QueryTextType;
import org.sdmx.resources.sdmxml.schemas.v21.query.ReferencesType;
import org.sdmx.resources.sdmxml.schemas.v21.query.ReportingTaxonomyQueryType;
import org.sdmx.resources.sdmxml.schemas.v21.query.ReportingTaxonomyWhereType;
import org.sdmx.resources.sdmxml.schemas.v21.query.StructureReturnDetailsType;
import org.sdmx.resources.sdmxml.schemas.v21.query.StructureSetQueryType;
import org.sdmx.resources.sdmxml.schemas.v21.registry.QueryRegistrationRequestType;
import org.sdmxsource.sdmx.api.constants.COMPLEX_MAINTAINABLE_QUERY_DETAIL;
import org.sdmxsource.sdmx.api.constants.COMPLEX_STRUCTURE_QUERY_DETAIL;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.constants.STRUCTURE_REFERENCE_DETAIL;
import org.sdmxsource.sdmx.api.constants.TERTIARY_BOOL;
import org.sdmxsource.sdmx.api.constants.TEXT_SEARCH;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.reference.complex.ComplexAnnotationReference;
import org.sdmxsource.sdmx.api.model.beans.reference.complex.ComplexIdentifiableReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.reference.complex.ComplexStructureQuery;
import org.sdmxsource.sdmx.api.model.beans.reference.complex.ComplexStructureQueryMetadata;
import org.sdmxsource.sdmx.api.model.beans.reference.complex.ComplexStructureReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.reference.complex.ComplexTextReference;
import org.sdmxsource.sdmx.api.model.beans.reference.complex.ComplexVersionReference;
import org.sdmxsource.sdmx.api.model.beans.reference.complex.TimeRange;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.SdmxDateImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.reference.complex.ComplexAnnotationReferenceImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.reference.complex.ComplexIdentifiableReferenceBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.reference.complex.ComplexStructureQueryImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.reference.complex.ComplexStructureQueryMetadataImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.reference.complex.ComplexStructureReferenceBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.reference.complex.ComplexTextReferenceImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.reference.complex.ComplexVersionReferenceImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.reference.complex.TimeRangeImpl;
import org.sdmxsource.sdmx.sdmxbeans.util.RefUtil;
import org.sdmxsource.sdmx.util.beans.reference.StructureReferenceBeanImpl;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Service
public class QueryBeanBuilderV2_1 {
    public StructureReferenceBean build(QueryRegistrationRequestType queryRegistrationRequestType) {
        if (queryRegistrationRequestType != null) {
            if (queryRegistrationRequestType.getAll() != null) {
                return new StructureReferenceBeanImpl(SDMX_STRUCTURE_TYPE.PROVISION_AGREEMENT);
            }
            DataflowReferenceType dataflowRef = queryRegistrationRequestType.getDataflow();
            DataProviderReferenceType dataProviderRef = queryRegistrationRequestType.getDataProvider();
            ProvisionAgreementReferenceType provRef = queryRegistrationRequestType.getProvisionAgreement();
            MetadataflowReferenceType mdfRef = queryRegistrationRequestType.getMetadataflow();
            if (dataProviderRef != null) {
                return RefUtil.createReference(dataProviderRef);
            }
            if (provRef != null) {
                return RefUtil.createReference(provRef);
            }
            if (dataflowRef != null) {
                return RefUtil.createReference(dataflowRef);
            }
            if (mdfRef != null) {
                return RefUtil.createReference(mdfRef);
            }
        }
        return null;
    }

    private ComplexIdentifiableReferenceBean buildIdentifiableReference(ItemWhereType itemWhereType, SDMX_STRUCTURE_TYPE itemType) {
        if (itemWhereType == null) {
            return null;
        }
        QueryIDType idType = itemWhereType.getID();
        ComplexTextReference id = null;
        if (idType != null) {
            id = this.buildTextReference(null, idType.getOperator(), idType.getStringValue());
        }
        ComplexAnnotationReference annotationRef = this.buildAnnotationReference(itemWhereType.getAnnotation());
        QueryTextType nameType = itemWhereType.getName();
        ComplexTextReference nameRef = null;
        if (nameType != null) {
            nameRef = this.buildTextReference(nameType.getLang(), nameType.getOperator(), nameType.getStringValue());
        }
        QueryTextType descriptionType = itemWhereType.getDescription();
        ComplexTextReference descriptionRef = null;
        if (descriptionType != null) {
            descriptionRef = this.buildTextReference(descriptionType.getLang(), descriptionType.getOperator(), descriptionType.getStringValue());
        }
        ComplexIdentifiableReferenceBean childRef = null;
        List<ItemWhereType> itemWhereList = itemWhereType.getItemWhereList();
        if (itemWhereList != null && !itemWhereList.isEmpty()) {
            itemWhereList.size();
            childRef = this.buildIdentifiableReference(itemWhereList.get(0), itemType);
        }
        return new ComplexIdentifiableReferenceBeanImpl(id, itemType, annotationRef, nameRef, descriptionRef, childRef);
    }

    private ComplexStructureReferenceBean buildMaintainableWhere(MaintainableWhereType maintainableWhere, ComplexIdentifiableReferenceBean childRef) {
        QueryNestedIDType agencyIDType = maintainableWhere.getAgencyID();
        ComplexTextReference agencyId = null;
        if (agencyIDType != null) {
            agencyId = this.buildTextReference(null, agencyIDType.getOperator(), agencyIDType.getStringValue());
        }
        QueryIDType queryIDType = maintainableWhere.getID();
        ComplexTextReference id = null;
        if (queryIDType != null) {
            id = this.buildTextReference(null, queryIDType.getOperator(), queryIDType.getStringValue());
        }
        ComplexVersionReference versionRef = this.buildVersionReference(maintainableWhere.getVersion(), maintainableWhere.getVersionFrom(), maintainableWhere.getVersionTo());
        SDMX_STRUCTURE_TYPE structureType = maintainableWhere.getType().toString().equals("OrganisationScheme") ? SDMX_STRUCTURE_TYPE.ORGANISATION_SCHEME : (maintainableWhere.getType().toString().equals("Constraint") ? SDMX_STRUCTURE_TYPE.CONSTRAINT : (maintainableWhere.getType().toString().equals("Any") ? SDMX_STRUCTURE_TYPE.ANY : SDMX_STRUCTURE_TYPE.parseClass(maintainableWhere.getType().toString())));
        ComplexAnnotationReference annotationRef = this.buildAnnotationReference(maintainableWhere.getAnnotation());
        QueryTextType nameType = maintainableWhere.getName();
        ComplexTextReference nameRef = null;
        if (nameType != null) {
            nameRef = this.buildTextReference(nameType.getLang(), nameType.getOperator(), nameType.getStringValue());
        }
        QueryTextType descriptionType = maintainableWhere.getDescription();
        ComplexTextReference descriptionRef = null;
        if (descriptionType != null) {
            descriptionRef = this.buildTextReference(descriptionType.getLang(), descriptionType.getOperator(), descriptionType.getStringValue());
        }
        return new ComplexStructureReferenceBeanImpl(agencyId, id, versionRef, structureType, annotationRef, nameRef, descriptionRef, childRef);
    }

    private ComplexAnnotationReference buildAnnotationReference(AnnotationWhereType annotationWhereType) {
        if (annotationWhereType == null) {
            return null;
        }
        QueryStringType type = annotationWhereType.getType();
        ComplexTextReference typeRef = null;
        if (type != null) {
            typeRef = this.buildTextReference(null, type.getOperator(), type.getStringValue());
        }
        QueryStringType title = annotationWhereType.getTitle();
        ComplexTextReference titleRef = null;
        if (title != null) {
            titleRef = this.buildTextReference(null, title.getOperator(), title.getStringValue());
        }
        QueryTextType text = annotationWhereType.getText();
        ComplexTextReference textRef = null;
        if (text != null) {
            textRef = this.buildTextReference(text.getLang(), text.getOperator(), text.getStringValue());
        }
        return new ComplexAnnotationReferenceImpl(typeRef, titleRef, textRef);
    }

    private ComplexVersionReference buildVersionReference(String version, TimeRangeValueType versionFromType, TimeRangeValueType versionToType) {
        TERTIARY_BOOL returnLatest = TERTIARY_BOOL.UNSET;
        String emptyCheckedString = null;
        if (StringUtils.hasText((String)version)) {
            if (version.equals("*")) {
                returnLatest = TERTIARY_BOOL.TRUE;
                emptyCheckedString = null;
            } else {
                emptyCheckedString = version;
                returnLatest = TERTIARY_BOOL.FALSE;
            }
        }
        TimeRange validFrom = this.buildTimeRange(versionFromType);
        TimeRange validTo = this.buildTimeRange(versionToType);
        return new ComplexVersionReferenceImpl(returnLatest, emptyCheckedString, validFrom, validTo);
    }

    private TimeRange buildTimeRange(TimeRangeValueType timeRangeValueType) {
        if (timeRangeValueType == null) {
            return null;
        }
        boolean range = false;
        SdmxDateImpl startDate = null;
        SdmxDateImpl endDate = null;
        boolean endInclusive = false;
        boolean startInclusive = false;
        if (timeRangeValueType.isSetAfterPeriod()) {
            TimePeriodRangeType afterPeriod = timeRangeValueType.getAfterPeriod();
            startDate = new SdmxDateImpl(afterPeriod.getStringValue());
            startInclusive = afterPeriod.getIsInclusive();
        } else if (timeRangeValueType.isSetBeforePeriod()) {
            TimePeriodRangeType beforePeriod = timeRangeValueType.getBeforePeriod();
            endDate = new SdmxDateImpl(beforePeriod.getStringValue());
            endInclusive = beforePeriod.getIsInclusive();
        } else {
            range = true;
            TimePeriodRangeType startPeriod = timeRangeValueType.getStartPeriod();
            startDate = new SdmxDateImpl(startPeriod.getStringValue());
            startInclusive = startPeriod.getIsInclusive();
            TimePeriodRangeType endPeriod = timeRangeValueType.getEndPeriod();
            endDate = new SdmxDateImpl(endPeriod.getStringValue());
            endInclusive = endPeriod.getIsInclusive();
        }
        return new TimeRangeImpl(range, startDate, endDate, startInclusive, endInclusive);
    }

    private ComplexTextReference buildTextReference(String lang, String operator, String value) {
        String emptyCheckedLang = "en";
        if (StringUtils.hasText((String)lang)) {
            emptyCheckedLang = lang;
        }
        TEXT_SEARCH defaultCheckedOperator = TEXT_SEARCH.EQUAL;
        if (StringUtils.hasText((String)operator)) {
            defaultCheckedOperator = TEXT_SEARCH.parseString(operator);
        }
        return new ComplexTextReferenceImpl(emptyCheckedLang, defaultCheckedOperator, value);
    }

    private ComplexStructureQueryMetadata buildQueryDetails(StructureReturnDetailsType returnDetails) {
        boolean returnMatchedartefact = returnDetails.getReturnMatchedArtefact();
        COMPLEX_STRUCTURE_QUERY_DETAIL queryDetail = COMPLEX_STRUCTURE_QUERY_DETAIL.parseString(returnDetails.getDetail());
        ReferencesType references = returnDetails.getReferences();
        COMPLEX_MAINTAINABLE_QUERY_DETAIL referencesQueryDetail = references.isSetDetail() ? COMPLEX_MAINTAINABLE_QUERY_DETAIL.parseString(references.getDetail().toString()) : COMPLEX_MAINTAINABLE_QUERY_DETAIL.FULL;
        STRUCTURE_REFERENCE_DETAIL referenceDetail = null;
        ArrayList<SDMX_STRUCTURE_TYPE> referenceSpecificStructures = null;
        if (references.isSetAll()) {
            referenceDetail = STRUCTURE_REFERENCE_DETAIL.ALL;
        } else if (references.isSetChildren()) {
            referenceDetail = STRUCTURE_REFERENCE_DETAIL.CHILDREN;
        } else if (references.isSetDescendants()) {
            referenceDetail = STRUCTURE_REFERENCE_DETAIL.DESCENDANTS;
        } else if (references.isSetNone()) {
            referenceDetail = STRUCTURE_REFERENCE_DETAIL.NONE;
        } else if (references.isSetParents()) {
            referenceDetail = STRUCTURE_REFERENCE_DETAIL.PARENTS;
        } else if (references.isSetParentsAndSiblings()) {
            referenceDetail = STRUCTURE_REFERENCE_DETAIL.PARENTS_SIBLINGS;
        } else if (references.isSetSpecificObjects()) {
            referenceDetail = STRUCTURE_REFERENCE_DETAIL.SPECIFIC;
            referenceSpecificStructures = new ArrayList<SDMX_STRUCTURE_TYPE>();
            MaintainableObjectTypeListType specificObjects = references.getSpecificObjects();
            Node domNode = specificObjects.getDomNode();
            NodeList childNodes = domNode.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                Node item = childNodes.item(i);
                if (StringUtils.hasText((String)item.getLocalName())) {
                    referenceSpecificStructures.add(SDMX_STRUCTURE_TYPE.parseClass(item.getLocalName()));
                }
                ++i;
            }
        }
        return new ComplexStructureQueryMetadataImpl(returnMatchedartefact, queryDetail, referencesQueryDetail, referenceDetail, referenceSpecificStructures);
    }

    public ComplexStructureQuery build(DataflowQueryType dataflowQueryMsg) {
        org.sdmx.resources.sdmxml.schemas.v21.query.DataflowQueryType query = dataflowQueryMsg.getQuery();
        StructureReturnDetailsType returnDetails = query.getReturnDetails();
        ComplexStructureQueryMetadata queryMetadata = this.buildQueryDetails(returnDetails);
        ComplexStructureReferenceBean structureRef = this.buildMaintainableWhere(query.getStructuralMetadataWhere(), null);
        return new ComplexStructureQueryImpl(structureRef, queryMetadata);
    }

    public ComplexStructureQuery build(MetadataflowQueryType metadataflowQueryMsg) {
        org.sdmx.resources.sdmxml.schemas.v21.query.MetadataflowQueryType query = metadataflowQueryMsg.getQuery();
        StructureReturnDetailsType returnDetails = query.getReturnDetails();
        ComplexStructureQueryMetadata queryMetadata = this.buildQueryDetails(returnDetails);
        ComplexStructureReferenceBean structureRef = this.buildMaintainableWhere(query.getStructuralMetadataWhere(), null);
        return new ComplexStructureQueryImpl(structureRef, queryMetadata);
    }

    public ComplexStructureQuery build(org.sdmx.resources.sdmxml.schemas.v21.message.DataStructureQueryType dataStructureQueryMsg) {
        DataStructureQueryType query = dataStructureQueryMsg.getQuery();
        StructureReturnDetailsType returnDetails = query.getReturnDetails();
        ComplexStructureQueryMetadata queryMetadata = this.buildQueryDetails(returnDetails);
        ComplexStructureReferenceBean structureRef = this.buildMaintainableWhere(query.getStructuralMetadataWhere(), null);
        return new ComplexStructureQueryImpl(structureRef, queryMetadata);
    }

    public ComplexStructureQuery build(MetadataStructureQueryType metadataStructureQueryMsg) {
        org.sdmx.resources.sdmxml.schemas.v21.query.MetadataStructureQueryType query = metadataStructureQueryMsg.getQuery();
        StructureReturnDetailsType returnDetails = query.getReturnDetails();
        ComplexStructureQueryMetadata queryMetadata = this.buildQueryDetails(returnDetails);
        ComplexStructureReferenceBean structureRef = this.buildMaintainableWhere(query.getStructuralMetadataWhere(), null);
        return new ComplexStructureQueryImpl(structureRef, queryMetadata);
    }

    public ComplexStructureQuery build(org.sdmx.resources.sdmxml.schemas.v21.message.CategorySchemeQueryType categorySchemeQueryMsg) {
        CategorySchemeQueryType query = categorySchemeQueryMsg.getQuery();
        StructureReturnDetailsType returnDetails = query.getReturnDetails();
        ComplexStructureQueryMetadata queryMetadata = this.buildQueryDetails(returnDetails);
        CategorySchemeWhereType categorySchemeWhere = query.getCategorySchemeWhere();
        List<ItemWhereType> itemWhereList = categorySchemeWhere.getItemWhereList();
        ComplexIdentifiableReferenceBean childRef = null;
        if (itemWhereList != null && !itemWhereList.isEmpty()) {
            itemWhereList.size();
            childRef = this.buildIdentifiableReference(itemWhereList.get(0), SDMX_STRUCTURE_TYPE.CATEGORY);
        }
        ComplexStructureReferenceBean structureRef = this.buildMaintainableWhere(query.getStructuralMetadataWhere(), childRef);
        return new ComplexStructureQueryImpl(structureRef, queryMetadata);
    }

    public ComplexStructureQuery build(org.sdmx.resources.sdmxml.schemas.v21.message.ConceptSchemeQueryType conceptSchemeQueryMsg) {
        ConceptSchemeQueryType query = conceptSchemeQueryMsg.getQuery();
        StructureReturnDetailsType returnDetails = query.getReturnDetails();
        ComplexStructureQueryMetadata queryMetadata = this.buildQueryDetails(returnDetails);
        ConceptSchemeWhereType conceptSchemeWhere = query.getConceptSchemeWhere();
        List<ItemWhereType> itemWhereList = conceptSchemeWhere.getItemWhereList();
        ComplexIdentifiableReferenceBean childRef = null;
        if (itemWhereList != null && !itemWhereList.isEmpty()) {
            itemWhereList.size();
            childRef = this.buildIdentifiableReference(itemWhereList.get(0), SDMX_STRUCTURE_TYPE.CONCEPT);
        }
        ComplexStructureReferenceBean structureRef = this.buildMaintainableWhere(query.getStructuralMetadataWhere(), childRef);
        return new ComplexStructureQueryImpl(structureRef, queryMetadata);
    }

    public ComplexStructureQuery build(org.sdmx.resources.sdmxml.schemas.v21.message.CodelistQueryType codelistQueryMsg) {
        CodelistQueryType query = codelistQueryMsg.getQuery();
        StructureReturnDetailsType returnDetails = query.getReturnDetails();
        ComplexStructureQueryMetadata queryMetadata = this.buildQueryDetails(returnDetails);
        CodelistWhereType codelistWhere = query.getCodelistWhere();
        List<ItemWhereType> itemWhereList = codelistWhere.getItemWhereList();
        ComplexIdentifiableReferenceBean childRef = null;
        if (itemWhereList != null && !itemWhereList.isEmpty()) {
            itemWhereList.size();
            childRef = this.buildIdentifiableReference(itemWhereList.get(0), SDMX_STRUCTURE_TYPE.CODE);
        }
        ComplexStructureReferenceBean structureRef = this.buildMaintainableWhere(query.getStructuralMetadataWhere(), childRef);
        return new ComplexStructureQueryImpl(structureRef, queryMetadata);
    }

    public ComplexStructureQuery build(org.sdmx.resources.sdmxml.schemas.v21.message.HierarchicalCodelistQueryType hierarchicalCodelistQueryMsg) {
        HierarchicalCodelistQueryType query = hierarchicalCodelistQueryMsg.getQuery();
        StructureReturnDetailsType returnDetails = query.getReturnDetails();
        ComplexStructureQueryMetadata queryMetadata = this.buildQueryDetails(returnDetails);
        ComplexStructureReferenceBean structureRef = this.buildMaintainableWhere(query.getStructuralMetadataWhere(), null);
        return new ComplexStructureQueryImpl(structureRef, queryMetadata);
    }

    public ComplexStructureQuery build(org.sdmx.resources.sdmxml.schemas.v21.message.OrganisationSchemeQueryType organisationSchemeQueryMsg) {
        SDMX_STRUCTURE_TYPE orgType;
        OrganisationSchemeQueryType query = organisationSchemeQueryMsg.getQuery();
        StructureReturnDetailsType returnDetails = query.getReturnDetails();
        ComplexStructureQueryMetadata queryMetadata = this.buildQueryDetails(returnDetails);
        OrganisationSchemeWhereType organisationSchemeWhere = query.getOrganisationSchemeWhere();
        String orgSchemeStr = organisationSchemeWhere.getType().toString();
        SDMX_STRUCTURE_TYPE orgSchemeType = orgSchemeStr.equals("OrganisationScheme") ? SDMX_STRUCTURE_TYPE.ORGANISATION_SCHEME : SDMX_STRUCTURE_TYPE.parseClass(orgSchemeStr);
        switch (orgSchemeType) {
            case AGENCY_SCHEME: {
                orgType = SDMX_STRUCTURE_TYPE.AGENCY;
                break;
            }
            case DATA_CONSUMER_SCHEME: {
                orgType = SDMX_STRUCTURE_TYPE.DATA_CONSUMER;
                break;
            }
            case DATA_PROVIDER_SCHEME: {
                orgType = SDMX_STRUCTURE_TYPE.DATA_PROVIDER;
                break;
            }
            case ORGANISATION_UNIT_SCHEME: {
                orgType = SDMX_STRUCTURE_TYPE.ORGANISATION_UNIT;
                break;
            }
            case ORGANISATION_SCHEME: {
                orgType = SDMX_STRUCTURE_TYPE.ORGANISATION;
                break;
            }
            default: {
                throw new IllegalArgumentException("An organisation scheme type expected instead of: " + (Object)((Object)orgSchemeType));
            }
        }
        List<ItemWhereType> itemWhereList = organisationSchemeWhere.getItemWhereList();
        ComplexIdentifiableReferenceBean childRef = null;
        if (itemWhereList != null && !itemWhereList.isEmpty()) {
            itemWhereList.size();
            childRef = this.buildIdentifiableReference(itemWhereList.get(0), orgType);
        }
        ComplexStructureReferenceBean structureRef = this.buildMaintainableWhere(query.getStructuralMetadataWhere(), childRef);
        return new ComplexStructureQueryImpl(structureRef, queryMetadata);
    }

    public ComplexStructureQuery build(org.sdmx.resources.sdmxml.schemas.v21.message.ReportingTaxonomyQueryType reportingTaxonomyQueryMsg) {
        ReportingTaxonomyQueryType query = reportingTaxonomyQueryMsg.getQuery();
        StructureReturnDetailsType returnDetails = query.getReturnDetails();
        ComplexStructureQueryMetadata queryMetadata = this.buildQueryDetails(returnDetails);
        ReportingTaxonomyWhereType reportingTaxonomyWhere = query.getReportingTaxonomyWhere();
        List<ItemWhereType> itemWhereList = reportingTaxonomyWhere.getItemWhereList();
        ComplexIdentifiableReferenceBean childRef = null;
        if (itemWhereList != null && !itemWhereList.isEmpty()) {
            itemWhereList.size();
            childRef = this.buildIdentifiableReference(itemWhereList.get(0), SDMX_STRUCTURE_TYPE.REPORTING_CATEGORY);
        }
        ComplexStructureReferenceBean structureRef = this.buildMaintainableWhere(query.getStructuralMetadataWhere(), childRef);
        return new ComplexStructureQueryImpl(structureRef, queryMetadata);
    }

    public ComplexStructureQuery build(org.sdmx.resources.sdmxml.schemas.v21.message.StructureSetQueryType structureSetQueryMsg) {
        StructureSetQueryType query = structureSetQueryMsg.getQuery();
        StructureReturnDetailsType returnDetails = query.getReturnDetails();
        ComplexStructureQueryMetadata queryMetadata = this.buildQueryDetails(returnDetails);
        ComplexStructureReferenceBean structureRef = this.buildMaintainableWhere(query.getStructuralMetadataWhere(), null);
        return new ComplexStructureQueryImpl(structureRef, queryMetadata);
    }

    public ComplexStructureQuery build(ProcessQueryType processQueryMsg) {
        org.sdmx.resources.sdmxml.schemas.v21.query.ProcessQueryType query = processQueryMsg.getQuery();
        StructureReturnDetailsType returnDetails = query.getReturnDetails();
        ComplexStructureQueryMetadata queryMetadata = this.buildQueryDetails(returnDetails);
        ComplexStructureReferenceBean structureRef = this.buildMaintainableWhere(query.getStructuralMetadataWhere(), null);
        return new ComplexStructureQueryImpl(structureRef, queryMetadata);
    }

    public ComplexStructureQuery build(CategorisationQueryType categorisationQueryMsg) {
        org.sdmx.resources.sdmxml.schemas.v21.query.CategorisationQueryType query = categorisationQueryMsg.getQuery();
        StructureReturnDetailsType returnDetails = query.getReturnDetails();
        ComplexStructureQueryMetadata queryMetadata = this.buildQueryDetails(returnDetails);
        ComplexStructureReferenceBean structureRef = this.buildMaintainableWhere(query.getStructuralMetadataWhere(), null);
        return new ComplexStructureQueryImpl(structureRef, queryMetadata);
    }

    public ComplexStructureQuery build(org.sdmx.resources.sdmxml.schemas.v21.message.ProvisionAgreementQueryType provisionAgreementQueryMsg) {
        ProvisionAgreementQueryType query = provisionAgreementQueryMsg.getQuery();
        StructureReturnDetailsType returnDetails = query.getReturnDetails();
        ComplexStructureQueryMetadata queryMetadata = this.buildQueryDetails(returnDetails);
        ComplexStructureReferenceBean structureRef = this.buildMaintainableWhere(query.getStructuralMetadataWhere(), null);
        return new ComplexStructureQueryImpl(structureRef, queryMetadata);
    }

    public ComplexStructureQuery build(ConstraintQueryType constraintQueryMsg) {
        org.sdmx.resources.sdmxml.schemas.v21.query.ConstraintQueryType query = constraintQueryMsg.getQuery();
        StructureReturnDetailsType returnDetails = query.getReturnDetails();
        ComplexStructureQueryMetadata queryMetadata = this.buildQueryDetails(returnDetails);
        ComplexStructureReferenceBean structureRef = this.buildMaintainableWhere(query.getStructuralMetadataWhere(), null);
        return new ComplexStructureQueryImpl(structureRef, queryMetadata);
    }

    public ComplexStructureQuery build(StructuresQueryType structuresQueryMsg) {
        org.sdmx.resources.sdmxml.schemas.v21.query.StructuresQueryType query = structuresQueryMsg.getQuery();
        StructureReturnDetailsType returnDetails = query.getReturnDetails();
        ComplexStructureQueryMetadata queryMetadata = this.buildQueryDetails(returnDetails);
        ComplexStructureReferenceBean structureRef = this.buildMaintainableWhere(query.getStructuralMetadataWhere(), null);
        return new ComplexStructureQueryImpl(structureRef, queryMetadata);
    }
}

