/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.query.v21;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sdmx.resources.sdmxml.schemas.v21.common.DataProviderReferenceType;
import org.sdmx.resources.sdmxml.schemas.v21.common.DataStructureRequestType;
import org.sdmx.resources.sdmxml.schemas.v21.common.TimePeriodRangeType;
import org.sdmx.resources.sdmxml.schemas.v21.common.TimeRangeValueType;
import org.sdmx.resources.sdmxml.schemas.v21.query.AttributeValueType;
import org.sdmx.resources.sdmxml.schemas.v21.query.DataParametersAndType;
import org.sdmx.resources.sdmxml.schemas.v21.query.DataParametersOrType;
import org.sdmx.resources.sdmxml.schemas.v21.query.DataQueryType;
import org.sdmx.resources.sdmxml.schemas.v21.query.DataReturnDetailsType;
import org.sdmx.resources.sdmxml.schemas.v21.query.DataStructureComponentValueQueryType;
import org.sdmx.resources.sdmxml.schemas.v21.query.DimensionValueType;
import org.sdmx.resources.sdmxml.schemas.v21.query.NumericValueType;
import org.sdmx.resources.sdmxml.schemas.v21.query.PrimaryMeasureValueType;
import org.sdmx.resources.sdmxml.schemas.v21.query.QueryTextType;
import org.sdmx.resources.sdmxml.schemas.v21.query.TimeDimensionValueType;
import org.sdmx.resources.sdmxml.schemas.v21.query.TimePeriodValueType;
import org.sdmxsource.sdmx.api.constants.DATA_QUERY_DETAIL;
import org.sdmxsource.sdmx.api.constants.OBSERVATION_ACTION;
import org.sdmxsource.sdmx.api.constants.ORDERED_OPERATOR;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.constants.TEXT_SEARCH;
import org.sdmxsource.sdmx.api.manager.retrieval.SdmxBeanRetrievalManager;
import org.sdmxsource.sdmx.api.model.base.SdmxDate;
import org.sdmxsource.sdmx.api.model.beans.base.DataProviderBean;
import org.sdmxsource.sdmx.api.model.beans.base.DataProviderSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataflowBean;
import org.sdmxsource.sdmx.api.model.beans.reference.MaintainableRefBean;
import org.sdmxsource.sdmx.api.model.beans.reference.complex.TimeRange;
import org.sdmxsource.sdmx.api.model.beans.registry.ProvisionAgreementBean;
import org.sdmxsource.sdmx.api.model.data.query.complex.ComplexComponentValue;
import org.sdmxsource.sdmx.api.model.data.query.complex.ComplexDataQuery;
import org.sdmxsource.sdmx.api.model.data.query.complex.ComplexDataQuerySelection;
import org.sdmxsource.sdmx.api.model.data.query.complex.ComplexDataQuerySelectionGroup;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.SdmxDateImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.reference.complex.TimeRangeImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.data.query.complex.ComplexComponentValueImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.data.query.complex.ComplexDataQueryImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.data.query.complex.ComplexDataQuerySelectionGroupImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.data.query.complex.ComplexDataQuerySelectionImpl;
import org.sdmxsource.sdmx.util.beans.reference.MaintainableRefBeanImpl;
import org.sdmxsource.util.ObjectUtil;
import org.springframework.stereotype.Service;

@Service
public class DataQueryBuilderV21 {
    public List<ComplexDataQuery> buildComplexDataQuery(DataQueryType dataQueryType, SdmxBeanRetrievalManager structureRetrievalManager) {
        if (structureRetrievalManager == null) {
            throw new RuntimeException("ComplexDataQueryBuilder expectes a SdmxBeanRetrievalManager");
        }
        ArrayList<ComplexDataQuery> returnList = new ArrayList<ComplexDataQuery>();
        DataReturnDetailsType returnDetails = dataQueryType.getReturnDetails();
        DataParametersAndType dataWhere = dataQueryType.getDataWhere();
        DATA_QUERY_DETAIL queryDetail = this.getReturnDetailsDetail(returnDetails);
        Integer firstNObs = this.getReturnDetailsFirstNobs(returnDetails);
        Integer lastNObs = this.getReturnDetailsLastNobs(returnDetails);
        Integer defaultLimit = this.getReturnDetailsDefaultLimit(returnDetails);
        OBSERVATION_ACTION obsAction = this.getReturnDetailsObsAction(returnDetails);
        List structureReferenceDetails = this.getStructureRefDetails(returnDetails);
        String dimensionAtObservation = structureReferenceDetails != null ? (String)structureReferenceDetails.get(0) : null;
        boolean hasExplicitMeasures = structureReferenceDetails != null && structureReferenceDetails.size() > 1 ? (Boolean)structureReferenceDetails.get(1) : false;
        Set<DataProviderBean> dataProviders = this.getDataWhereDataProviders(dataWhere, structureRetrievalManager);
        String[] datasetArray = this.getDataWhereDatasetId(dataWhere);
        String datasetId = datasetArray != null ? datasetArray[0] : null;
        TEXT_SEARCH datasetIdOper = datasetArray != null ? TEXT_SEARCH.parseString(datasetArray[1]) : null;
        DataflowBean dataFlow = this.getDataWhereDataFlow(dataWhere, structureRetrievalManager);
        DataStructureBean dataStructure = this.getDataWhereDataStrucuture(dataWhere, structureRetrievalManager, dataFlow);
        ProvisionAgreementBean provisionAgreement = this.getProvisionAgreement(dataWhere, structureRetrievalManager);
        List<TimeRange> updatedDates = this.getDataWhereUpdatedDates(dataWhere);
        Set<ComplexDataQuerySelectionGroup> complexDataQuerySelectionGroups = this.buildComplexDataQueryGroups(dataWhere, structureRetrievalManager, dataProviders);
        ComplexDataQueryImpl complexQuery = new ComplexDataQueryImpl(datasetId, datasetIdOper, dataProviders, dataStructure, dataFlow, provisionAgreement, updatedDates, firstNObs, lastNObs, defaultLimit, obsAction, dimensionAtObservation, hasExplicitMeasures, queryDetail, complexDataQuerySelectionGroups);
        returnList.add(complexQuery);
        return returnList;
    }

    private List<TimeRange> getDataWhereUpdatedDates(DataParametersAndType dataWhere) {
        ArrayList<TimeRange> updatedDates = new ArrayList<TimeRange>();
        if (dataWhere.getUpdatedList().size() > 0) {
            int i = 0;
            while (i < dataWhere.getUpdatedList().size()) {
                TimeRangeValueType timeRangeValueType = dataWhere.getUpdatedList().get(i);
                updatedDates.add(this.buildTimeRange(timeRangeValueType));
                ++i;
            }
        }
        return updatedDates;
    }

    private ProvisionAgreementBean getProvisionAgreement(DataParametersAndType dataWhere, SdmxBeanRetrievalManager structureRetrievalManager) {
        ProvisionAgreementBean provisionAgreement = null;
        if (dataWhere.getProvisionAgreementList() != null && dataWhere.getProvisionAgreementList().size() > 0) {
            MaintainableRefBeanImpl praRef;
            String praAgency = dataWhere.getProvisionAgreementList().get(0).getRef().getAgencyID();
            String praId = dataWhere.getProvisionAgreementList().get(0).getRef().getId();
            String praVersion = "1.0";
            if (dataWhere.getProvisionAgreementList().get(0).getRef().getVersion() != null) {
                praVersion = dataWhere.getProvisionAgreementList().get(0).getRef().getVersion();
            }
            if ((provisionAgreement = structureRetrievalManager.getProvisionAgreementBean(praRef = new MaintainableRefBeanImpl(praAgency, praId, praVersion))) == null) {
                throw new RuntimeException("Provision Agreement not found: " + praRef);
            }
        }
        return provisionAgreement;
    }

    private DataStructureBean getDataWhereDataStrucuture(DataParametersAndType dataWhere, SdmxBeanRetrievalManager structureRetrievalManager, DataflowBean dataFlow) {
        DataStructureBean dataStructure = null;
        if (dataWhere.getDataStructureList() != null && dataWhere.getDataStructureList().size() > 0) {
            MaintainableRefBeanImpl dsdRef;
            String dataStructureAgency = dataWhere.getDataStructureList().get(0).getRef().getAgencyID();
            String dataStructureId = dataWhere.getDataStructureList().get(0).getRef().getId();
            String dataStructureVersion = "1.0";
            if (dataWhere.getDataStructureList().get(0).getRef().getVersion() != null) {
                dataStructureVersion = dataWhere.getDataStructureList().get(0).getRef().getVersion();
            }
            if ((dataStructure = structureRetrievalManager.getDataStructure(dsdRef = new MaintainableRefBeanImpl(dataStructureAgency, dataStructureId, dataStructureVersion))) == null) {
                throw new RuntimeException("DSD not found: " + dsdRef);
            }
        } else {
            MaintainableRefBean dsdRef = dataFlow.getDataStructureRef().getMaintainableReference();
            dataStructure = structureRetrievalManager.getDataStructure(dsdRef);
            if (dataStructure == null) {
                throw new RuntimeException("Data Structure not found: " + dataFlow.getDataStructureRef());
            }
        }
        return dataStructure;
    }

    private DataflowBean getDataWhereDataFlow(DataParametersAndType dataWhere, SdmxBeanRetrievalManager structureRetrievalManager) {
        DataflowBean dataFlow = null;
        if (dataWhere.getDataflowList() != null && dataWhere.getDataflowList().size() > 0) {
            MaintainableRefBeanImpl flowRef;
            String dataFlowAgency = dataWhere.getDataflowList().get(0).getRef().getAgencyID();
            String dataFlowId = dataWhere.getDataflowList().get(0).getRef().getId();
            String dataFlowVersion = "1.0";
            if (dataWhere.getDataflowList().get(0).getRef().getVersion() != null) {
                dataFlowVersion = dataWhere.getDataflowList().get(0).getRef().getVersion();
            }
            if ((dataFlow = structureRetrievalManager.getDataflow(flowRef = new MaintainableRefBeanImpl(dataFlowAgency, dataFlowId, dataFlowVersion))) == null) {
                throw new RuntimeException("Dataflow not found: " + flowRef);
            }
        } else {
            throw new IllegalArgumentException("Can not create DataQuery, Dataflow is required");
        }
        return dataFlow;
    }

    private String[] getDataWhereDatasetId(DataParametersAndType dataWhere) {
        String[] datasetArray = null;
        String datasetId = null;
        String datasetIdOperator = null;
        if (dataWhere.getDataSetIDList() != null && dataWhere.getDataSetIDList().size() > 0) {
            datasetArray = new String[2];
            datasetArray[0] = datasetId = dataWhere.getDataSetIDList().get(0).getStringValue();
            String operator = dataWhere.getDataSetIDList().get(0).getOperator();
            datasetIdOperator = operator != null ? operator : "equals";
            datasetArray[1] = datasetIdOperator;
        }
        return datasetArray;
    }

    private Set<DataProviderBean> getDataWhereDataProviders(DataParametersAndType dataWhere, SdmxBeanRetrievalManager structureRetrievalManager) {
        HashSet<DataProviderBean> dataProviders = new HashSet<DataProviderBean>();
        if (dataWhere.getDataProviderList() != null && dataWhere.getDataProviderList().size() > 0) {
            for (DataProviderReferenceType dataProviderRefType : dataWhere.getDataProviderList()) {
                DataProviderBean dataProviderBean = this.processDataProviderType(dataProviderRefType, structureRetrievalManager);
                dataProviders.add(dataProviderBean);
            }
        }
        return dataProviders;
    }

    private DATA_QUERY_DETAIL getReturnDetailsDetail(DataReturnDetailsType returnDetails) {
        if (returnDetails.isSetDetail()) {
            return DATA_QUERY_DETAIL.parseString(returnDetails.getDetail());
        }
        return DATA_QUERY_DETAIL.FULL;
    }

    private Integer getReturnDetailsFirstNobs(DataReturnDetailsType returnDetails) {
        if (returnDetails.isSetFirstNObservations()) {
            return returnDetails.getFirstNObservations();
        }
        return null;
    }

    private Integer getReturnDetailsLastNobs(DataReturnDetailsType returnDetails) {
        if (returnDetails.isSetLastNObservations()) {
            return returnDetails.getLastNObservations();
        }
        return null;
    }

    private Integer getReturnDetailsDefaultLimit(DataReturnDetailsType returnDetails) {
        if (returnDetails.isSetDefaultLimit()) {
            return returnDetails.getDefaultLimit().intValue();
        }
        return null;
    }

    private OBSERVATION_ACTION getReturnDetailsObsAction(DataReturnDetailsType returnDetails) {
        if (returnDetails.isSetObservationAction()) {
            return OBSERVATION_ACTION.parseString(returnDetails.getObservationAction().toString());
        }
        return OBSERVATION_ACTION.ACTIVE;
    }

    private List getStructureRefDetails(DataReturnDetailsType returnDetails) {
        ArrayList<Object> structureRefDetails = null;
        if (returnDetails.getStructureList() != null && returnDetails.getStructureList().size() > 0) {
            structureRefDetails = new ArrayList<Object>();
            List<DataStructureRequestType> structureList = returnDetails.getStructureList();
            DataStructureRequestType structure = structureList.get(0);
            structureRefDetails.add(structure.getDimensionAtObservation());
            if (structure.isSetExplicitMeasures()) {
                structureRefDetails.add(structure.getExplicitMeasures());
            }
        }
        return structureRefDetails;
    }

    private Set<ComplexDataQuerySelectionGroup> buildComplexDataQueryGroups(DataParametersAndType dataWhere, SdmxBeanRetrievalManager structureRetrievalManager, Set<DataProviderBean> dataProviders) {
        ComplexComponentValue comValue;
        ComplexComponentValue complexValue;
        HashSet<ComplexDataQuerySelectionGroup> complexDataQuerySelectionGroups = new HashSet<ComplexDataQuerySelectionGroup>();
        HashSet<ComplexDataQuerySelection> complexSelections = new HashSet<ComplexDataQuerySelection>();
        HashSet<ComplexComponentValue> primaryMeasureValues = new HashSet<ComplexComponentValue>();
        ORDERED_OPERATOR dateFromOperator = ORDERED_OPERATOR.EQUAL;
        ORDERED_OPERATOR dateToOperator = ORDERED_OPERATOR.EQUAL;
        SdmxDateImpl dateFrom = null;
        SdmxDateImpl dateTo = null;
        if (dataWhere.getPrimaryMeasureValueList() != null && dataWhere.getPrimaryMeasureValueList().size() > 0) {
            PrimaryMeasureValueType primaryMeasure = dataWhere.getPrimaryMeasureValueList().get(0);
            complexValue = this.getComplexComponentValue(primaryMeasure, SDMX_STRUCTURE_TYPE.PRIMARY_MEASURE);
            primaryMeasureValues.add(complexValue);
        }
        if (dataWhere.getTimeDimensionValueList() != null && dataWhere.getTimeDimensionValueList().size() > 0) {
            TimeDimensionValueType timeValue = dataWhere.getTimeDimensionValueList().get(0);
            complexValue = this.getComplexComponentValue(timeValue, SDMX_STRUCTURE_TYPE.TIME_DIMENSION);
            if (complexValue.getOrderedOperator().equals((Object)ORDERED_OPERATOR.GREATER_THAN) || complexValue.getOrderedOperator().equals((Object)ORDERED_OPERATOR.GREATER_THAN_OR_EQUAL) || complexValue.getOrderedOperator().equals((Object)ORDERED_OPERATOR.EQUAL)) {
                dateFromOperator = complexValue.getOrderedOperator();
                dateFrom = new SdmxDateImpl(complexValue.getValue());
            } else {
                dateToOperator = complexValue.getOrderedOperator();
                dateTo = new SdmxDateImpl(complexValue.getValue());
            }
        }
        if (dataWhere.getDimensionValueList() != null && dataWhere.getDimensionValueList().size() > 0) {
            for (DimensionValueType dimValue : dataWhere.getDimensionValueList()) {
                comValue = this.getComplexComponentValue(dimValue, SDMX_STRUCTURE_TYPE.DIMENSION);
                this.addComponentSelection(complexSelections, dimValue.getID(), comValue);
            }
        }
        if (dataWhere.getAttributeValueList() != null && dataWhere.getAttributeValueList().size() > 0) {
            for (AttributeValueType attrValue : dataWhere.getAttributeValueList()) {
                comValue = this.getComplexComponentValue(attrValue, SDMX_STRUCTURE_TYPE.DATA_ATTRIBUTE);
                this.addComponentSelection(complexSelections, attrValue.getID(), comValue);
            }
        }
        this.processParametersOrType(dataWhere.getOrList(), complexSelections, structureRetrievalManager, dataProviders);
        this.addGroupIfSelectionsExist(complexSelections, dateFrom, dateFromOperator, dateTo, dateToOperator, primaryMeasureValues, complexDataQuerySelectionGroups);
        return complexDataQuerySelectionGroups;
    }

    private DataProviderBean processDataProviderType(DataProviderReferenceType dataProviderRef, SdmxBeanRetrievalManager structureRetrievalManager) {
        String agencyId = dataProviderRef.getRef().getAgencyID();
        String id = dataProviderRef.getRef().getMaintainableParentID();
        String version = dataProviderRef.getRef().getMaintainableParentVersion();
        MaintainableRefBeanImpl orgSchemeRef = new MaintainableRefBeanImpl(agencyId, id, version);
        DataProviderSchemeBean dataProviderScheme = structureRetrievalManager.getDataProviderSchemeBean(orgSchemeRef);
        for (DataProviderBean dp : dataProviderScheme.getItems()) {
            if (!dp.getId().equals(dataProviderRef.getRef().getId())) continue;
            return dp;
        }
        return null;
    }

    private void processParametersAndType(List<DataParametersAndType> andTypeList, Set<ComplexDataQuerySelection> complexSelections) {
        if (andTypeList != null) {
            for (DataParametersAndType andType : andTypeList) {
                this.processParametersAndType(andType, complexSelections);
            }
        }
    }

    private void processParametersAndType(DataParametersAndType andType, Set<ComplexDataQuerySelection> complexSelections) {
    }

    private void processParametersOrType(List<DataParametersOrType> orTypeList, Set<ComplexDataQuerySelection> complexSelections, SdmxBeanRetrievalManager structureRetrievalManager, Set<DataProviderBean> dataProviders) {
        if (orTypeList != null) {
            for (DataParametersOrType orType : orTypeList) {
                this.processParametersOrType(orType, complexSelections, structureRetrievalManager, dataProviders);
            }
        }
    }

    private void processParametersOrType(DataParametersOrType orType, Set<ComplexDataQuerySelection> complexSelections, SdmxBeanRetrievalManager structureRetrievalManager, Set<DataProviderBean> dataProviders) {
        ComplexComponentValue comValue;
        if (orType.getDataProviderList() != null && orType.getDataProviderList().size() > 0) {
            for (DataProviderReferenceType dataProviderRefType : orType.getDataProviderList()) {
                DataProviderBean dataProviderBean = this.processDataProviderType(dataProviderRefType, structureRetrievalManager);
                dataProviders.add(dataProviderBean);
            }
        }
        if (orType.getDimensionValueList() != null && orType.getDimensionValueList().size() > 0) {
            for (DimensionValueType dimValue : orType.getDimensionValueList()) {
                comValue = this.getComplexComponentValue(dimValue, SDMX_STRUCTURE_TYPE.DIMENSION);
                this.addComponentSelection(complexSelections, dimValue.getID(), comValue);
            }
        }
        if (orType.getAttributeValueList() != null && orType.getAttributeValueList().size() > 0) {
            for (AttributeValueType attrValue : orType.getAttributeValueList()) {
                comValue = this.getComplexComponentValue(attrValue, SDMX_STRUCTURE_TYPE.DATA_ATTRIBUTE);
                this.addComponentSelection(complexSelections, attrValue.getID(), comValue);
            }
        }
        if (orType.getPrimaryMeasureValueList() != null && orType.getPrimaryMeasureValueList().size() > 0) {
            for (PrimaryMeasureValueType measureValue : orType.getPrimaryMeasureValueList()) {
                comValue = this.getComplexComponentValue(measureValue, SDMX_STRUCTURE_TYPE.PRIMARY_MEASURE);
                this.addComponentSelection(complexSelections, measureValue.getID(), comValue);
            }
        }
        if (orType.getTimeDimensionValueList() != null && orType.getTimeDimensionValueList().size() > 0) {
            for (TimeDimensionValueType timeValue : orType.getTimeDimensionValueList()) {
                comValue = this.getComplexComponentValue(timeValue, SDMX_STRUCTURE_TYPE.TIME_DIMENSION);
                this.addComponentSelection(complexSelections, timeValue.getID(), comValue);
            }
        }
    }

    private ComplexComponentValue getComplexComponentValue(DataStructureComponentValueQueryType compValue, SDMX_STRUCTURE_TYPE compType) {
        ORDERED_OPERATOR orderedOperator;
        ComplexComponentValueImpl comValue = null;
        if (compValue.getNumericValueList() != null) {
            for (NumericValueType numerValue : compValue.getNumericValueList()) {
                orderedOperator = ORDERED_OPERATOR.parseString(numerValue.getOperator());
                comValue = new ComplexComponentValueImpl(numerValue.getStringValue(), orderedOperator, compType);
            }
        }
        if (compValue.getTimeValueList() != null) {
            for (TimePeriodValueType timeValue : compValue.getTimeValueList()) {
                orderedOperator = ORDERED_OPERATOR.parseString(timeValue.getOperator());
                comValue = new ComplexComponentValueImpl(timeValue.getStringValue(), orderedOperator, compType);
            }
        }
        if ((compType.equals((Object)SDMX_STRUCTURE_TYPE.PRIMARY_MEASURE) || compType.equals((Object)SDMX_STRUCTURE_TYPE.DATA_ATTRIBUTE)) && compValue.getTextValueList() != null) {
            for (QueryTextType textValue : compValue.getTextValueList()) {
                TEXT_SEARCH textOperator = TEXT_SEARCH.parseString(textValue.getOperator());
                comValue = new ComplexComponentValueImpl(textValue.getStringValue(), textOperator, compType);
            }
        }
        if (compValue.getValue() != null) {
            ORDERED_OPERATOR orderedOperator2 = ORDERED_OPERATOR.parseString(compValue.getValue().getOperator().toString());
            comValue = new ComplexComponentValueImpl(compValue.getValue().getStringValue(), orderedOperator2, compType);
        }
        return comValue;
    }

    private void addComponentSelection(Set<ComplexDataQuerySelection> complexSelections, String conceptId, ComplexComponentValue value) {
        for (ComplexDataQuerySelection selection : complexSelections) {
            if (!selection.getComponentId().equals(conceptId)) continue;
            ((ComplexDataQuerySelectionImpl)selection).addValue(value);
            return;
        }
        ComplexDataQuerySelectionImpl newSelection = new ComplexDataQuerySelectionImpl(conceptId, value);
        complexSelections.add(newSelection);
    }

    private void addGroupIfSelectionsExist(Set<ComplexDataQuerySelection> complexSelections, SdmxDate dateFrom, ORDERED_OPERATOR dateFromOperator, SdmxDate dateTo, ORDERED_OPERATOR dateToOperator, Set<ComplexComponentValue> primaryMeasureValues, Set<ComplexDataQuerySelectionGroup> complexDataQuerySelectionGroups) {
        if (ObjectUtil.validCollection(complexSelections) || dateFrom != null || dateTo != null || ObjectUtil.validCollection(primaryMeasureValues)) {
            complexDataQuerySelectionGroups.add(new ComplexDataQuerySelectionGroupImpl(complexSelections, dateFrom, dateFromOperator, dateTo, dateToOperator, primaryMeasureValues));
        }
    }

    private TimeRange buildTimeRange(TimeRangeValueType timeRangeValueType) {
        boolean range = false;
        SdmxDateImpl startDate = null;
        SdmxDateImpl endDate = null;
        boolean endInclusive = false;
        boolean startInclusive = false;
        if (timeRangeValueType.isSetAfterPeriod()) {
            TimePeriodRangeType afterPeriod = timeRangeValueType.getAfterPeriod();
            startDate = new SdmxDateImpl(afterPeriod.getStringValue());
            startInclusive = afterPeriod.getIsInclusive();
        } else if (timeRangeValueType.isSetBeforePeriod()) {
            TimePeriodRangeType beforePeriod = timeRangeValueType.getBeforePeriod();
            endDate = new SdmxDateImpl(beforePeriod.getStringValue());
            endInclusive = beforePeriod.getIsInclusive();
        } else {
            range = true;
            TimePeriodRangeType startPeriod = timeRangeValueType.getStartPeriod();
            startDate = new SdmxDateImpl(startPeriod.getStringValue());
            startInclusive = startPeriod.getIsInclusive();
            TimePeriodRangeType endPeriod = timeRangeValueType.getEndPeriod();
            endDate = new SdmxDateImpl(endPeriod.getStringValue());
            endInclusive = endPeriod.getIsInclusive();
        }
        return new TimeRangeImpl(range, startDate, endDate, startInclusive, endInclusive);
    }
}

