/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.sdmxbeans.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.sdmx.resources.sdmxml.schemas.v20.message.StructureDocument;
import org.sdmx.resources.sdmxml.schemas.v20.message.StructureType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.AttributeType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.CodeListType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.ComponentsType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.ConceptSchemeType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.ConceptType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.DimensionType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.HierarchicalCodelistType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.KeyFamilyType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.OrganisationSchemeType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.ProcessType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.ReportingTaxonomyType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.StructureSetType;
import org.sdmxsource.sdmx.api.builder.Builder;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.MaintainableBeanException;
import org.sdmxsource.sdmx.api.exception.SdmxException;
import org.sdmxsource.sdmx.api.exception.SdmxNotImplementedException;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.model.beans.SdmxBeans;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.api.model.mutable.datastructure.CrossSectionalDataStructureMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.datastructure.CrossSectionalMeasureMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.datastructure.DimensionMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.AgencySchemeBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.DataConsumerSchemeBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.DataProviderSchemeBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.categoryscheme.ReportingTaxonomyBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.codelist.CodelistBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.codelist.HierarchicalCodelistBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.conceptscheme.ConceptSchemeBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.datastructure.CrossSectionalDataStructureBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.datastructure.DataStructureBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.mapping.StructureSetBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.process.ProcessBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.header.HeaderBeanImpl;
import org.sdmxsource.sdmx.structureparser.builder.sdmxbeans.impl.AbstractSdmxBeansV2Builder;
import org.sdmxsource.sdmx.util.beans.container.SdmxBeansImpl;
import org.sdmxsource.sdmx.util.beans.reference.StructureReferenceBeanImpl;
import org.sdmxsource.util.ObjectUtil;
import org.springframework.stereotype.Service;

@Service
public class SdmxBeansV2StrucDocBuilder
extends AbstractSdmxBeansV2Builder
implements Builder<SdmxBeans, StructureDocument> {
    @Override
    public SdmxBeans build(StructureDocument structuresDoc) throws SdmxException {
        HashSet<String> urns = new HashSet<String>();
        StructureType structures = structuresDoc.getStructure();
        SdmxBeansImpl beans = new SdmxBeansImpl(new HeaderBeanImpl(structures.getHeader()));
        this.processCategorySchemes(structures.getCategorySchemes(), beans);
        if (structures.getCodeLists() != null && structures.getCodeLists().getCodeListList() != null) {
            for (CodeListType codeListType : structures.getCodeLists().getCodeListList()) {
                try {
                    this.addIfNotDuplicateURN(beans, urns, new CodelistBeanImpl(codeListType));
                }
                catch (Throwable th) {
                    throw new MaintainableBeanException(th, SDMX_STRUCTURE_TYPE.CODE_LIST, codeListType.getAgencyID(), codeListType.getId(), codeListType.getVersion());
                }
            }
        }
        if (structures.getConcepts() != null && structures.getConcepts().getConceptSchemeList() != null) {
            for (ConceptSchemeType conceptSchemeType : structures.getConcepts().getConceptSchemeList()) {
                try {
                    this.addIfNotDuplicateURN(beans, urns, new ConceptSchemeBeanImpl(conceptSchemeType));
                }
                catch (Throwable th) {
                    throw new MaintainableBeanException(th, SDMX_STRUCTURE_TYPE.CONCEPT_SCHEME, conceptSchemeType.getAgencyID(), conceptSchemeType.getId(), conceptSchemeType.getVersion());
                }
            }
        }
        HashMap hashMap = new HashMap();
        if (structures.getConcepts() != null && structures.getConcepts().getConceptList() != null) {
            for (ConceptType conceptType : structures.getConcepts().getConceptList()) {
                List<ConceptType> concepts;
                if (hashMap.containsKey(conceptType.getAgencyID())) {
                    concepts = (List)hashMap.get(conceptType.getAgencyID());
                } else {
                    concepts = new ArrayList();
                    hashMap.put(conceptType.getAgencyID(), concepts);
                }
                concepts.add(conceptType);
            }
        }
        for (String string : hashMap.keySet()) {
            try {
                this.addIfNotDuplicateURN(beans, urns, new ConceptSchemeBeanImpl((List)hashMap.get(string), string));
            }
            catch (Throwable th) {
                throw new MaintainableBeanException(th, SDMX_STRUCTURE_TYPE.CONCEPT_SCHEME, string, "STANDALONE_CONCEPT_SCHEME", "1.0");
            }
        }
        this.processDataflows(structures.getDataflows(), beans);
        if (structures.getHierarchicalCodelists() != null && structures.getHierarchicalCodelists().getHierarchicalCodelistList() != null) {
            for (HierarchicalCodelistType hierarchicalCodelistType : structures.getHierarchicalCodelists().getHierarchicalCodelistList()) {
                try {
                    this.addIfNotDuplicateURN(beans, urns, new HierarchicalCodelistBeanImpl(hierarchicalCodelistType));
                }
                catch (Throwable th) {
                    throw new MaintainableBeanException(th, SDMX_STRUCTURE_TYPE.HIERARCHICAL_CODELIST, hierarchicalCodelistType.getAgencyID(), hierarchicalCodelistType.getId(), hierarchicalCodelistType.getVersion());
                }
            }
        }
        if (structures.getKeyFamilies() != null && structures.getKeyFamilies().getKeyFamilyList() != null) {
            for (KeyFamilyType keyFamilyType : structures.getKeyFamilies().getKeyFamilyList()) {
                try {
                    if (this.isXsDataStructure(keyFamilyType)) {
                        CrossSectionalDataStructureBeanImpl xsdBean = new CrossSectionalDataStructureBeanImpl(keyFamilyType);
                        CrossSectionalDataStructureMutableBean mutable = xsdBean.getMutableInstance();
                        if (mutable.getCrossSectionalMeasures().size() > 0) {
                            CrossSectionalMeasureMutableBean xsMutable = mutable.getCrossSectionalMeasures().get(0);
                            StructureReferenceBean sRef = xsMutable.getConceptRef();
                            HashMap<String, StructureReferenceBean> mapping = new HashMap<String, StructureReferenceBean>();
                            StructureReferenceBeanImpl cocneptSchemeRef = new StructureReferenceBeanImpl(sRef.getMaintainableReference(), SDMX_STRUCTURE_TYPE.CONCEPT_SCHEME);
                            for (DimensionMutableBean dim : mutable.getDimensions()) {
                                if (!dim.isMeasureDimension()) continue;
                                mapping.put(dim.getId(), dim.getRepresentation().getRepresentation());
                                dim.getRepresentation().setRepresentation(cocneptSchemeRef);
                            }
                            mutable.setMeasureDimensionCodelistMapping(mapping);
                        }
                        this.addIfNotDuplicateURN(beans, urns, mutable.getImmutableInstance());
                        continue;
                    }
                    this.addIfNotDuplicateURN(beans, urns, new DataStructureBeanImpl(keyFamilyType));
                }
                catch (Throwable th) {
                    throw new MaintainableBeanException(th, SDMX_STRUCTURE_TYPE.DSD, keyFamilyType.getAgencyID(), keyFamilyType.getId(), keyFamilyType.getVersion());
                }
            }
        }
        this.processMetadataFlows(structures.getMetadataflows(), beans);
        if (structures.getMetadataStructureDefinitions() != null && structures.getMetadataStructureDefinitions().getMetadataStructureDefinitionList() != null) {
            throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, "Metadata Structure Definition at SMDX v2.0 - please use SDMX v2.1");
        }
        if (structures.getOrganisationSchemes() != null) {
            for (OrganisationSchemeType organisationSchemeType : structures.getOrganisationSchemes().getOrganisationSchemeList()) {
                if (ObjectUtil.validCollection(organisationSchemeType.getAgenciesList())) {
                    try {
                        this.addIfNotDuplicateURN(beans, urns, new AgencySchemeBeanImpl(organisationSchemeType));
                    }
                    catch (Throwable th) {
                        throw new MaintainableBeanException(th, SDMX_STRUCTURE_TYPE.AGENCY_SCHEME, organisationSchemeType.getAgencyID(), organisationSchemeType.getId(), organisationSchemeType.getVersion());
                    }
                }
                if (ObjectUtil.validCollection(organisationSchemeType.getDataConsumersList())) {
                    try {
                        this.addIfNotDuplicateURN(beans, urns, new DataConsumerSchemeBeanImpl(organisationSchemeType));
                    }
                    catch (Throwable th) {
                        throw new MaintainableBeanException(th, SDMX_STRUCTURE_TYPE.DATA_CONSUMER_SCHEME, organisationSchemeType.getAgencyID(), organisationSchemeType.getId(), organisationSchemeType.getVersion());
                    }
                }
                if (ObjectUtil.validCollection(organisationSchemeType.getDataProvidersList())) {
                    try {
                        this.addIfNotDuplicateURN(beans, urns, new DataProviderSchemeBeanImpl(organisationSchemeType));
                    }
                    catch (Throwable th) {
                        throw new MaintainableBeanException(th, SDMX_STRUCTURE_TYPE.DATA_PROVIDER_SCHEME, organisationSchemeType.getAgencyID(), organisationSchemeType.getId(), organisationSchemeType.getVersion());
                    }
                }
                if (!organisationSchemeType.getAgenciesList().isEmpty() || !organisationSchemeType.getDataConsumersList().isEmpty() || !organisationSchemeType.getDataProvidersList().isEmpty()) continue;
                throw new SdmxSemmanticException(ExceptionCode.STRUCTURE_INVALID_ORGANISATION_SCHEME_NO_CONTENT, organisationSchemeType.getAgencyID(), organisationSchemeType.getId());
            }
        }
        if (structures.getProcesses() != null && structures.getProcesses().getProcessList() != null) {
            for (ProcessType processType : structures.getProcesses().getProcessList()) {
                try {
                    this.addIfNotDuplicateURN(beans, urns, new ProcessBeanImpl(processType));
                }
                catch (Throwable th) {
                    throw new MaintainableBeanException(th, SDMX_STRUCTURE_TYPE.PROCESS, processType.getAgencyID(), processType.getId(), processType.getVersion());
                }
            }
        }
        if (structures.getReportingTaxonomies() != null && structures.getReportingTaxonomies().getReportingTaxonomyList() != null) {
            for (ReportingTaxonomyType reportingTaxonomyType : structures.getReportingTaxonomies().getReportingTaxonomyList()) {
                try {
                    this.addIfNotDuplicateURN(beans, urns, new ReportingTaxonomyBeanImpl(reportingTaxonomyType));
                }
                catch (Throwable th) {
                    throw new MaintainableBeanException(th, SDMX_STRUCTURE_TYPE.REPORTING_TAXONOMY, reportingTaxonomyType.getAgencyID(), reportingTaxonomyType.getId(), reportingTaxonomyType.getVersion());
                }
            }
        }
        if (structures.getStructureSets() != null && structures.getStructureSets().getStructureSetList() != null) {
            for (StructureSetType structureSetType : structures.getStructureSets().getStructureSetList()) {
                try {
                    this.addIfNotDuplicateURN(beans, urns, new StructureSetBeanImpl(structureSetType));
                }
                catch (Throwable th) {
                    throw new MaintainableBeanException(th, SDMX_STRUCTURE_TYPE.STRUCTURE_SET, structureSetType.getAgencyID(), structureSetType.getId(), structureSetType.getVersion());
                }
            }
        }
        return beans;
    }

    private boolean isXsDataStructure(KeyFamilyType keyFamilyType) {
        ComponentsType components = keyFamilyType.getComponents();
        if (components != null) {
            if (ObjectUtil.validCollection(components.getDimensionList())) {
                for (DimensionType dim : components.getDimensionList()) {
                    if (!dim.getCrossSectionalAttachDataSet() && !dim.getCrossSectionalAttachGroup() && !dim.getCrossSectionalAttachSection() && !dim.getCrossSectionalAttachObservation()) continue;
                    return true;
                }
            }
            if (ObjectUtil.validCollection(components.getAttributeList())) {
                for (AttributeType att : components.getAttributeList()) {
                    if (!att.getCrossSectionalAttachDataSet() && !att.getCrossSectionalAttachGroup() && !att.getCrossSectionalAttachSection() && !att.getCrossSectionalAttachObservation()) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

