/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.xmlBeans;

import org.apache.xmlbeans.XmlObject;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_SCHEMA;
import org.sdmxsource.sdmx.api.exception.SdmxNotImplementedException;
import org.sdmxsource.sdmx.structureparser.engine.writing.SchemaLocationWriter;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class XmlBeanBuilder {
    @Autowired(required=false)
    private SchemaLocationWriter schemaLocationWriter;

    protected void writeSchemaLocation(XmlObject doc, SDMX_SCHEMA schemaVersion) {
        if (this.schemaLocationWriter != null) {
            String schemaUri = null;
            switch (schemaVersion) {
                case VERSION_ONE: {
                    schemaUri = "http://www.SDMX.org/resources/SDMXML/schemas/v1_0/message";
                    break;
                }
                case VERSION_TWO: {
                    schemaUri = "http://www.SDMX.org/resources/SDMXML/schemas/v2_0/message";
                    break;
                }
                case VERSION_TWO_POINT_ONE: {
                    schemaUri = "http://www.sdmx.org/resources/sdmxml/schemas/v2_1/message";
                    break;
                }
                default: {
                    throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, "Schema Version " + (Object)((Object)schemaVersion));
                }
            }
            this.schemaLocationWriter.writeSchemaLocation(doc, schemaUri);
        }
    }
}

