/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.xmlBeans.error.impl;

import org.apache.xmlbeans.XmlObject;
import org.sdmx.resources.sdmxml.schemas.v21.common.CodedStatusMessageType;
import org.sdmx.resources.sdmxml.schemas.v21.common.TextType;
import org.sdmx.resources.sdmxml.schemas.v21.message.ErrorDocument;
import org.sdmx.resources.sdmxml.schemas.v21.message.ErrorType;
import org.sdmxsource.sdmx.api.constants.SDMX_SCHEMA;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.XmlBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.error.ErrorResponseBuilder;
import org.sdmxsource.sdmx.util.exception.SchemaValidationException;
import org.springframework.stereotype.Service;

@Service
public class ErrorResponseBuilderImpl
extends XmlBeanBuilder
implements ErrorResponseBuilder {
    @Override
    public XmlObject buildErrorResponse(Throwable th, String exceptionCode) {
        ErrorDocument errorDocument = ErrorDocument.Factory.newInstance();
        ErrorType errorType = errorDocument.addNewError();
        CodedStatusMessageType errorMessage = errorType.addNewErrorMessage();
        errorMessage.setCode(exceptionCode);
        while (th != null) {
            if (th instanceof SchemaValidationException) {
                this.processSchemaValidationError(errorMessage, (SchemaValidationException)th);
            } else {
                this.processThrowable(errorMessage, th);
            }
            th = th.getCause();
        }
        super.writeSchemaLocation(errorDocument, SDMX_SCHEMA.VERSION_TWO_POINT_ONE);
        return errorDocument;
    }

    private void processSchemaValidationError(CodedStatusMessageType errorMessage, SchemaValidationException e) {
        for (String error : e.getValidationErrors()) {
            TextType text = errorMessage.addNewText();
            text.setStringValue(error);
        }
    }

    private void processThrowable(CodedStatusMessageType errorMessage, Throwable th) {
        TextType text = errorMessage.addNewText();
        if (th.getMessage() == null) {
            if (th.getCause() != null) {
                text.setStringValue(th.getCause().getMessage());
            } else if (th instanceof NullPointerException) {
                text.setStringValue("Null Pointer Exception");
            } else {
                text.setStringValue("No Error Message Provided");
            }
        } else {
            text.setStringValue(th.getMessage());
        }
    }
}

