/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.xmlBeans.registry.response.impl.v2;

import org.sdmx.resources.sdmxml.schemas.v20.common.TextType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.DatasourceType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.QueryableDatasourceType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.StatusMessageType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.StatusType;
import org.sdmxsource.sdmx.api.exception.SdmxException;
import org.sdmxsource.sdmx.api.model.beans.base.AnnotableBean;
import org.sdmxsource.sdmx.api.model.beans.base.DataSourceBean;
import org.sdmxsource.util.ObjectUtil;

public abstract class AbstractResponseBuilder {
    AbstractResponseBuilder() {
    }

    public void addStatus(StatusMessageType statusMessage, Throwable th) {
        if (th == null) {
            statusMessage.setStatus(StatusType.SUCCESS);
        } else {
            statusMessage.setStatus(StatusType.FAILURE);
            TextType tt = statusMessage.addNewMessageText();
            if (th instanceof SdmxException) {
                tt.setStringValue(((SdmxException)th).getFullMessage());
            } else {
                tt.setStringValue(th.getMessage());
            }
        }
    }

    public void addDatasource(DataSourceBean datasourceBean, DatasourceType datasourceType) {
        if (datasourceBean.isSimpleDatasource()) {
            if (datasourceBean.getDataUrl() != null) {
                datasourceType.setSimpleDatasource(datasourceBean.getDataUrl().toString());
            }
        } else {
            QueryableDatasourceType queryableDatasourceType = datasourceType.addNewQueryableDatasource();
            if (datasourceBean.getDataUrl() != null) {
                queryableDatasourceType.setDataUrl(datasourceBean.getDataUrl().toString());
            }
            queryableDatasourceType.setIsRESTDatasource(datasourceBean.isRESTDatasource());
            queryableDatasourceType.setIsWebServiceDatasource(datasourceBean.isWebServiceDatasource());
            if (datasourceBean.getWSDLUrl() != null) {
                queryableDatasourceType.setWSDLUrl(datasourceBean.getWSDLUrl().toString());
            }
        }
    }

    boolean hasAnnotations(AnnotableBean annotable) {
        return ObjectUtil.validCollection(annotable.getAnnotations());
    }
}

