/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v1;

import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.common.AnnotationType;
import org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.common.AnnotationsType;
import org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.common.TextType;
import org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.structure.TextFormatType;
import org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.structure.TextTypeType;
import org.sdmxsource.sdmx.api.model.beans.base.AnnotableBean;
import org.sdmxsource.sdmx.api.model.beans.base.AnnotationBean;
import org.sdmxsource.sdmx.api.model.beans.base.TextFormatBean;
import org.sdmxsource.sdmx.api.model.beans.base.TextTypeWrapper;
import org.sdmxsource.util.ObjectUtil;
import org.sdmxsource.util.log.LoggingUtil;

public class AbstractBuilder {
    static Logger log;

    boolean validString(String string) {
        return ObjectUtil.validString(string);
    }

    boolean validCollection(Collection collection) {
        return ObjectUtil.validCollection(collection);
    }

    void populateTextFormatType(TextFormatType textFormatType, TextFormatBean textFormat) {
        if (textFormat.getMaxLength() != null) {
            textFormatType.setLength(textFormat.getMaxLength());
        }
        if (textFormat.getDecimals() != null) {
            textFormatType.setDecimals(textFormat.getDecimals());
        }
        if (textFormat.getTextType() != null) {
            switch (textFormat.getTextType()) {
                case BIG_INTEGER: {
                    textFormatType.setTextType(TextTypeType.NUM);
                    break;
                }
                case BOOLEAN: {
                    LoggingUtil.warn(log, "can not map text type BOOLEAN to SDMX version 1.0 schema instance, property ignored ");
                    break;
                }
                case COUNT: {
                    LoggingUtil.warn(log, "can not map text type COUNT to SDMX version 1.0 schema instance, property ignored ");
                    break;
                }
                case DATE: {
                    LoggingUtil.warn(log, "can not map text type DATE to SDMX version 1.0 schema instance, property ignored ");
                    break;
                }
                case DATE_TIME: {
                    LoggingUtil.warn(log, "can not map text type DATE TIME to SDMX version 1.0 schema instance, property ignored ");
                    break;
                }
                case DAY: {
                    LoggingUtil.warn(log, "can not map text type DAY to SDMX version 1.0 schema instance, property ignored ");
                    break;
                }
                case DECIMAL: {
                    textFormatType.setTextType(TextTypeType.NUM);
                    break;
                }
                case DOUBLE: {
                    textFormatType.setTextType(TextTypeType.NUM);
                    break;
                }
                case DURATION: {
                    LoggingUtil.warn(log, "can not map text type DURATION to SDMX version 1.0 schema instance, property ignored ");
                    break;
                }
                case EXCLUSIVE_VALUE_RANGE: {
                    LoggingUtil.warn(log, "can not map text type EXCLUSIVE VALUE RANGE to SDMX version 1.0 schema instance, property ignored ");
                    break;
                }
                case FLOAT: {
                    textFormatType.setTextType(TextTypeType.NUM);
                    break;
                }
                case INCLUSIVE_VALUE_RANGE: {
                    LoggingUtil.warn(log, "can not map text type INCLUSIVE VALUE RANGE to SDMX version 1.0 schema instance, property ignored ");
                    break;
                }
                case INCREMENTAL: {
                    LoggingUtil.warn(log, "can not map text type INCREMENTAL to SDMX version 1.0 schema instance, property ignored ");
                    break;
                }
                case LONG: {
                    textFormatType.setTextType(TextTypeType.NUM);
                    break;
                }
                case MONTH: {
                    LoggingUtil.warn(log, "can not map text type MONTH to SDMX version 1.0 schema instance, property ignored ");
                    break;
                }
                case MONTH_DAY: {
                    LoggingUtil.warn(log, "can not map text type MONTH DAY to SDMX version 1.0 schema instance, property ignored ");
                    break;
                }
                case OBSERVATIONAL_TIME_PERIOD: {
                    LoggingUtil.warn(log, "can not map text type OBSERVATIONAL TIME PERIOD to SDMX version 1.0 schema instance, property ignored ");
                    break;
                }
                case SHORT: {
                    textFormatType.setTextType(TextTypeType.NUM);
                    break;
                }
                case STRING: {
                    textFormatType.setTextType(TextTypeType.ALPHA);
                    break;
                }
                case TIME: {
                    LoggingUtil.warn(log, "can not map text type TIME to SDMX version 1.0 schema instance, property ignored ");
                    break;
                }
                case TIMESPAN: {
                    LoggingUtil.warn(log, "can not map text type TIMESPAN to SDMX version 1.0 schema instance, property ignored ");
                    break;
                }
                case URI: {
                    LoggingUtil.warn(log, "can not map text type URI to SDMX version 1.0 schema instance, property ignored ");
                    break;
                }
                case YEAR: {
                    LoggingUtil.warn(log, "can not map text type YEAR to SDMX version 1.0 schema instance, property ignored ");
                    break;
                }
                case YEAR_MONTH: {
                    LoggingUtil.warn(log, "can not map text type YEAR MONTH to SDMX version 1.0 schema instance, property ignored ");
                }
            }
        }
    }

    TextType[] getTextType(List<TextTypeWrapper> ttWrapper) {
        if (!ObjectUtil.validCollection(ttWrapper)) {
            return null;
        }
        TextType[] ttArr = new TextType[ttWrapper.size()];
        int i = 0;
        while (i < ttWrapper.size()) {
            TextType tt;
            ttArr[i] = tt = this.getTextType(ttWrapper.get(i));
            ++i;
        }
        return ttArr;
    }

    TextType getTextType(TextTypeWrapper ttWrapper) {
        TextType tt = TextType.Factory.newInstance();
        tt.setLang(ttWrapper.getLocale());
        tt.setStringValue(ttWrapper.getValue());
        return tt;
    }

    boolean hasAnnotations(AnnotableBean annotable) {
        return ObjectUtil.validCollection(annotable.getAnnotations());
    }

    AnnotationsType getAnnotationsType(AnnotableBean annotable) {
        if (!ObjectUtil.validCollection(annotable.getAnnotations())) {
            return null;
        }
        AnnotationsType returnType = AnnotationsType.Factory.newInstance();
        for (AnnotationBean currentAnnotationBean : annotable.getAnnotations()) {
            AnnotationType annotation = returnType.addNewAnnotation();
            annotation.setAnnotationTextArray(this.getTextType(currentAnnotationBean.getText()));
            annotation.setAnnotationTitle(currentAnnotationBean.getTitle());
            annotation.setAnnotationType(currentAnnotationBean.getType());
            if (currentAnnotationBean.getUri() == null) continue;
            annotation.setAnnotationURL(currentAnnotationBean.getUri().toString());
        }
        return returnType;
    }
}

