/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v1;

import java.util.Calendar;
import org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.common.ActionType;
import org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.message.HeaderType;
import org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.message.PartyType;
import org.sdmxsource.sdmx.api.builder.Builder;
import org.sdmxsource.sdmx.api.exception.SdmxException;
import org.sdmxsource.sdmx.api.model.header.HeaderBean;
import org.sdmxsource.sdmx.api.model.header.PartyBean;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v1.AbstractBuilder;
import org.sdmxsource.util.ObjectUtil;
import org.springframework.stereotype.Service;

@Service(value="headerXmlBeansBuilderV1")
public class HeaderXmlBeansBuilder
extends AbstractBuilder
implements Builder<HeaderType, HeaderBean> {
    @Override
    public HeaderType build(HeaderBean buildFrom) throws SdmxException {
        HeaderType headerType = HeaderType.Factory.newInstance();
        if (buildFrom != null && ObjectUtil.validString(buildFrom.getId())) {
            headerType.setID(buildFrom.getId());
        } else {
            headerType.setID("unassigned");
        }
        if (buildFrom != null && buildFrom.getPrepared() != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(buildFrom.getPrepared());
            headerType.setPrepared(cal);
        } else {
            headerType.setPrepared(Calendar.getInstance());
        }
        if (buildFrom != null && buildFrom.getAction() != null) {
            switch (buildFrom.getAction()) {
                case APPEND: {
                    headerType.setDataSetAction(ActionType.UPDATE);
                    break;
                }
                case REPLACE: {
                    headerType.setDataSetAction(ActionType.UPDATE);
                    break;
                }
                case DELETE: {
                    headerType.setDataSetAction(ActionType.DELETE);
                    break;
                }
                default: {
                    headerType.setDataSetAction(ActionType.UPDATE);
                    break;
                }
            }
        } else {
            headerType.setDataSetAction(ActionType.UPDATE);
        }
        if (buildFrom != null && buildFrom.getSender() != null) {
            this.setSenderInfo(headerType, buildFrom.getSender());
        } else {
            PartyType sender = headerType.addNewSender();
            sender.setId("unknown");
        }
        return headerType;
    }

    private void setSenderInfo(HeaderType headerType, PartyBean party) {
        PartyType sender = headerType.addNewSender();
        if (ObjectUtil.validString(party.getId())) {
            sender.setId(party.getId());
        }
    }
}

