/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v1;

import java.util.ArrayList;
import org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.message.HeaderType;
import org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.message.StructureDocument;
import org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.message.StructureType;
import org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.structure.AgenciesType;
import org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.structure.CodeListsType;
import org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.structure.ConceptsType;
import org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.structure.KeyFamiliesType;
import org.sdmxsource.sdmx.api.builder.Builder;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.SdmxException;
import org.sdmxsource.sdmx.api.exception.SdmxNotImplementedException;
import org.sdmxsource.sdmx.api.model.beans.SdmxBeans;
import org.sdmxsource.sdmx.api.model.beans.base.AgencyBean;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodelistBean;
import org.sdmxsource.sdmx.api.model.beans.conceptscheme.ConceptBean;
import org.sdmxsource.sdmx.api.model.beans.conceptscheme.ConceptSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.registry.response.impl.v1.V1Helper;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v1.AgencyXmlBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v1.CodelistXmlBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v1.ConceptXmlBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v1.DataStructureXmlBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v1.StructureHeaderXmlBeanBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="StructureXmlBeanBuilderV1")
public class StructureXmlBeanBuilder
implements Builder<StructureDocument, SdmxBeans> {
    @Autowired
    private AgencyXmlBeanBuilder agencyXmlBeanBuilder;
    @Autowired
    private CodelistXmlBeanBuilder codelistXmlBeanBuilder;
    @Autowired
    private ConceptXmlBeanBuilder conceptXmlBeanBuilder;
    @Autowired
    private DataStructureXmlBeanBuilder dataStructureXmlBeanBuilder;
    @Autowired
    private StructureHeaderXmlBeanBuilder structureHeaderXmlBeanBuilder;

    @Override
    public StructureDocument build(SdmxBeans buildFrom) throws SdmxException {
        this.validateSupport(buildFrom);
        StructureDocument doc = StructureDocument.Factory.newInstance();
        StructureType returnType = doc.addNewStructure();
        HeaderType headerType = null;
        if (buildFrom.getHeader() != null) {
            headerType = this.structureHeaderXmlBeanBuilder.build(buildFrom.getHeader());
            returnType.setHeader(headerType);
        } else {
            headerType = returnType.addNewHeader();
            V1Helper.setHeader(headerType, buildFrom);
        }
        if (buildFrom.getCodelists().size() > 0) {
            CodeListsType codeListsType = returnType.addNewCodeLists();
            for (CodelistBean codelistBean : buildFrom.getCodelists()) {
                codeListsType.getCodeListList().add(this.codelistXmlBeanBuilder.build(codelistBean));
            }
        }
        if (buildFrom.getConceptSchemes().size() > 0) {
            ConceptsType conceptsType = returnType.addNewConcepts();
            for (ConceptSchemeBean conceptSchemeBean : buildFrom.getConceptSchemes()) {
                for (ConceptBean conceptBean : conceptSchemeBean.getItems()) {
                    conceptsType.getConceptList().add(this.conceptXmlBeanBuilder.build(conceptBean));
                }
            }
        }
        if (buildFrom.getDataStructures().size() > 0) {
            KeyFamiliesType keyFamiliesType = returnType.addNewKeyFamilies();
            for (DataStructureBean currentBean : buildFrom.getDataStructures()) {
                keyFamiliesType.getKeyFamilyList().add(this.dataStructureXmlBeanBuilder.build(currentBean));
            }
        }
        AgenciesType agencies = null;
        if (buildFrom.getAgencies().size() > 0) {
            agencies = returnType.addNewAgencies();
            for (AgencyBean agencyBean : buildFrom.getAgencies()) {
                agencies.getAgencyList().add(this.agencyXmlBeanBuilder.build(agencyBean));
            }
        }
        return doc;
    }

    private void validateSupport(SdmxBeans beans) {
        ArrayList<SDMX_STRUCTURE_TYPE> supportedStructres = new ArrayList<SDMX_STRUCTURE_TYPE>();
        supportedStructres.add(SDMX_STRUCTURE_TYPE.AGENCY_SCHEME);
        supportedStructres.add(SDMX_STRUCTURE_TYPE.DSD);
        supportedStructres.add(SDMX_STRUCTURE_TYPE.CONCEPT_SCHEME);
        supportedStructres.add(SDMX_STRUCTURE_TYPE.CODE_LIST);
        for (MaintainableBean maintainableBean : beans.getAllMaintainables(new SDMX_STRUCTURE_TYPE[0])) {
            if (supportedStructres.contains((Object)maintainableBean.getStructureType())) continue;
            throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, String.valueOf(maintainableBean.getStructureType().getType()) + " at SMDX v1.0 - please use SDMX v2.0 or v2.1");
        }
    }
}

