/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2;

import org.sdmx.resources.sdmxml.schemas.v20.structure.AssignmentStatusType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.AttachmentLevelType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.AttributeType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.TextFormatType;
import org.sdmxsource.sdmx.api.builder.Builder;
import org.sdmxsource.sdmx.api.exception.SdmxException;
import org.sdmxsource.sdmx.api.model.beans.datastructure.AttributeBean;
import org.sdmxsource.sdmx.api.model.beans.reference.MaintainableRefBean;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2.AbstractBuilder;
import org.sdmxsource.util.ObjectUtil;
import org.springframework.stereotype.Service;

@Service(value="AttributeXmlBeanBuilderV2")
public class AttributeXmlBeanBuilder
extends AbstractBuilder
implements Builder<AttributeType, AttributeBean> {
    @Override
    public AttributeType build(AttributeBean buildFrom) throws SdmxException {
        MaintainableRefBean maintRef;
        AttributeType builtObj = AttributeType.Factory.newInstance();
        if (this.hasAnnotations(buildFrom)) {
            builtObj.setAnnotations(this.getAnnotationsType(buildFrom));
        }
        if (this.validString(buildFrom.getAssignmentStatus())) {
            if (buildFrom.getAssignmentStatus().equals(AssignmentStatusType.CONDITIONAL.toString())) {
                builtObj.setAssignmentStatus(AssignmentStatusType.CONDITIONAL);
            } else if (buildFrom.getAssignmentStatus().equals(AssignmentStatusType.MANDATORY.toString())) {
                builtObj.setAssignmentStatus(AssignmentStatusType.MANDATORY);
            } else {
                throw new IllegalArgumentException("Unknown assignment status: " + buildFrom.getAssignmentStatus());
            }
        }
        if (ObjectUtil.validString(buildFrom.getAttachmentGroup())) {
            String[] arr = new String[]{buildFrom.getAttachmentGroup()};
            builtObj.setAttachmentGroupArray(arr);
        }
        if (buildFrom.getAttachmentLevel() != null) {
            switch (buildFrom.getAttachmentLevel()) {
                case DATA_SET: {
                    builtObj.setAttachmentLevel(AttachmentLevelType.DATA_SET);
                    break;
                }
                case DIMENSION_GROUP: {
                    builtObj.setAttachmentLevel(AttachmentLevelType.SERIES);
                    break;
                }
                case OBSERVATION: {
                    builtObj.setAttachmentLevel(AttachmentLevelType.OBSERVATION);
                    break;
                }
                case GROUP: {
                    builtObj.setAttachmentLevel(AttachmentLevelType.GROUP);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown attachment level: " + buildFrom.getAssignmentStatus());
                }
            }
        }
        if (buildFrom.hasCodedRepresentation()) {
            maintRef = buildFrom.getRepresentation().getRepresentation().getMaintainableReference();
            if (this.validString(maintRef.getMaintainableId())) {
                builtObj.setCodelist(maintRef.getMaintainableId());
            }
            if (this.validString(maintRef.getAgencyId())) {
                builtObj.setCodelistAgency(maintRef.getAgencyId());
            }
            if (this.validString(maintRef.getVersion())) {
                builtObj.setCodelistVersion(maintRef.getVersion());
            }
        }
        if (buildFrom.getConceptRef() != null) {
            maintRef = buildFrom.getConceptRef().getMaintainableReference();
            if (this.validString(maintRef.getAgencyId())) {
                builtObj.setConceptSchemeAgency(maintRef.getAgencyId());
            }
            if (this.validString(maintRef.getMaintainableId())) {
                builtObj.setConceptSchemeRef(maintRef.getMaintainableId());
            }
            if (this.validString(buildFrom.getConceptRef().getChildReference().getId())) {
                builtObj.setConceptRef(buildFrom.getConceptRef().getChildReference().getId());
            }
            if (this.validString(maintRef.getVersion())) {
                builtObj.setConceptVersion(maintRef.getVersion());
            }
        }
        if (buildFrom.getRepresentation() != null && buildFrom.getRepresentation().getTextFormat() != null) {
            TextFormatType textFormatType = TextFormatType.Factory.newInstance();
            this.populateTextFormatType(textFormatType, buildFrom.getRepresentation().getTextFormat());
            builtObj.setTextFormat(textFormatType);
        }
        if (buildFrom.getId().equals("TIME_FORMAT")) {
            builtObj.setIsTimeFormat(true);
        }
        return builtObj;
    }
}

